/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeWithCPIndex;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;

public class BytecodeWithKlass
extends BytecodeWithCPIndex {
    BytecodeWithKlass(Method method, int bci) {
        super(method, bci);
    }

    protected Klass getKlass() {
        return this.method().getConstants().getKlassRefAt(this.index());
    }

    public Symbol getClassName() {
        Oop obj = this.method().getConstants().getObjAt(this.index());
        if (obj instanceof Symbol) {
            return (Symbol)obj;
        }
        return ((Klass)obj).getName();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getJavaBytecodeName());
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.index()));
        buf.append(" ");
        buf.append("[Class ");
        buf.append(this.getClassName().asString().replace('/', '.'));
        buf.append(']');
        if (this.code() != this.javaCode()) {
            buf.append(" ");
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }
}

