/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.ui.SAEditorPane;
import sun.jvm.hotspot.ui.classbrowser.HTMLGenerator;

public class JavaStackTracePanel
extends JPanel {
    private JSplitPane splitPane;
    private SAEditorPane stackTraceEditor;
    private SAEditorPane contentEditor;
    private HTMLGenerator htmlGen = new HTMLGenerator();

    public JavaStackTracePanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        HyperlinkListener hyperListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JavaStackTracePanel.this.setContentText(JavaStackTracePanel.this.htmlGen.genHTMLForHyperlink(e.getDescription()));
                }
            }
        };
        this.stackTraceEditor = new SAEditorPane();
        this.stackTraceEditor.addHyperlinkListener(hyperListener);
        this.contentEditor = new SAEditorPane();
        this.contentEditor.addHyperlinkListener(hyperListener);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JScrollPane(this.stackTraceEditor), "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)new JScrollPane(this.contentEditor), "Center");
        this.splitPane = new JSplitPane(0, topPanel, bottomPanel);
        this.splitPane.setDividerLocation(0.4);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
    }

    public void setJavaThread(JavaThread thread) {
        this.setStackTraceText(this.htmlGen.genHTMLForJavaStackTrace(thread));
    }

    private void setStackTraceText(String text) {
        this.stackTraceEditor.setText(text);
    }

    private void setContentText(String text) {
        this.contentEditor.setText(text);
    }
}

