/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.BasicHashtableEntry;
import sun.jvm.hotspot.utilities.HashtableBucket;

public class BasicHashtable
extends VMObject {
    private static CIntegerField tableSizeField;
    private static AddressField bucketsField;
    private static long bucketSize;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("BasicHashtable");
        tableSizeField = type.getCIntegerField("_table_size");
        bucketsField = type.getAddressField("_buckets");
        bucketSize = db.lookupType("HashtableBucket").getSize();
    }

    protected int tableSize() {
        return (int)tableSizeField.getValue(this.addr);
    }

    protected BasicHashtableEntry bucket(int i) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(i >= 0 && i < this.tableSize(), "Invalid bucket id");
        }
        Address tmp = bucketsField.getValue(this.addr);
        tmp = tmp.addOffsetTo((long)i * bucketSize);
        HashtableBucket bucket = (HashtableBucket)VMObjectFactory.newObject(HashtableBucket.class, tmp);
        return bucket.getEntry(this.getHashtableEntryClass());
    }

    protected Class getHashtableEntryClass() {
        return BasicHashtableEntry.class;
    }

    public BasicHashtable(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                BasicHashtable.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

