/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.ChunkStream;
import com.sun.imageio.plugins.png.IDATOutputStream;
import com.sun.imageio.plugins.png.PNGImageReader;
import com.sun.imageio.plugins.png.PNGImageWriteParam;
import com.sun.imageio.plugins.png.PNGMetadata;
import com.sun.imageio.plugins.png.RowFilter;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class PNGImageWriter
extends ImageWriter {
    ImageOutputStream stream = null;
    PNGMetadata metadata = null;
    int sourceXOffset = 0;
    int sourceYOffset = 0;
    int sourceWidth = 0;
    int sourceHeight = 0;
    int[] sourceBands = null;
    int periodX = 1;
    int periodY = 1;
    int numBands;
    int bpp;
    RowFilter rowFilter = new RowFilter();
    byte[] prevRow = null;
    byte[] currRow = null;
    byte[][] filteredRows = null;
    int[] sampleSize = null;
    int scalingBitDepth = -1;
    byte[][] scale = null;
    byte[] scale0 = null;
    byte[][] scaleh = null;
    byte[][] scalel = null;
    int totalPixels;
    int pixelsDone;
    private static int[] allowedProgressivePasses = new int[]{1, 7};

    public PNGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new PNGImageWriteParam(this.getLocale());
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        PNGMetadata pNGMetadata = new PNGMetadata();
        pNGMetadata.initialize(imageTypeSpecifier, imageTypeSpecifier.getSampleModel().getNumBands());
        return pNGMetadata;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata instanceof PNGMetadata) {
            return (PNGMetadata)((PNGMetadata)iIOMetadata).clone();
        }
        return new PNGMetadata(iIOMetadata);
    }

    private void write_magic() throws IOException {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.stream.write(byArray);
    }

    private void write_IHDR() throws IOException {
        ChunkStream chunkStream = new ChunkStream(1229472850, this.stream);
        chunkStream.writeInt(this.metadata.IHDR_width);
        chunkStream.writeInt(this.metadata.IHDR_height);
        chunkStream.writeByte(this.metadata.IHDR_bitDepth);
        chunkStream.writeByte(this.metadata.IHDR_colorType);
        if (this.metadata.IHDR_compressionMethod != 0) {
            throw new IIOException("Only compression method 0 is defined in PNG 1.1");
        }
        chunkStream.writeByte(this.metadata.IHDR_compressionMethod);
        if (this.metadata.IHDR_filterMethod != 0) {
            throw new IIOException("Only filter method 0 is defined in PNG 1.1");
        }
        chunkStream.writeByte(this.metadata.IHDR_filterMethod);
        if (this.metadata.IHDR_interlaceMethod < 0 || this.metadata.IHDR_interlaceMethod > 1) {
            throw new IIOException("Only interlace methods 0 (node) and 1 (adam7) are defined in PNG 1.1");
        }
        chunkStream.writeByte(this.metadata.IHDR_interlaceMethod);
        chunkStream.finish();
    }

    private void write_cHRM() throws IOException {
        if (this.metadata.cHRM_present) {
            ChunkStream chunkStream = new ChunkStream(1665684045, this.stream);
            chunkStream.writeInt(this.metadata.cHRM_whitePointX);
            chunkStream.writeInt(this.metadata.cHRM_whitePointY);
            chunkStream.writeInt(this.metadata.cHRM_redX);
            chunkStream.writeInt(this.metadata.cHRM_redY);
            chunkStream.writeInt(this.metadata.cHRM_greenX);
            chunkStream.writeInt(this.metadata.cHRM_greenY);
            chunkStream.writeInt(this.metadata.cHRM_blueX);
            chunkStream.writeInt(this.metadata.cHRM_blueY);
            chunkStream.finish();
        }
    }

    private void write_gAMA() throws IOException {
        if (this.metadata.gAMA_present) {
            ChunkStream chunkStream = new ChunkStream(1732332865, this.stream);
            chunkStream.writeInt(this.metadata.gAMA_gamma);
            chunkStream.finish();
        }
    }

    private void write_iCCP() throws IOException {
        if (this.metadata.iCCP_present) {
            ChunkStream chunkStream = new ChunkStream(1766015824, this.stream);
            chunkStream.writeBytes(this.metadata.iCCP_profileName);
            chunkStream.writeByte(0);
            chunkStream.writeByte(this.metadata.iCCP_compressionMethod);
            chunkStream.write(this.metadata.iCCP_compressedProfile);
            chunkStream.finish();
        }
    }

    private void write_sBIT() throws IOException {
        if (this.metadata.sBIT_present) {
            ChunkStream chunkStream = new ChunkStream(1933723988, this.stream);
            int n = this.metadata.IHDR_colorType;
            if (this.metadata.sBIT_colorType != n) {
                this.processWarningOccurred(0, "sBIT metadata has wrong color type.\nThe chunk will not be written.");
                return;
            }
            if (n == 0 || n == 4) {
                chunkStream.writeByte(this.metadata.sBIT_grayBits);
            } else if (n == 2 || n == 3 || n == 6) {
                chunkStream.writeByte(this.metadata.sBIT_redBits);
                chunkStream.writeByte(this.metadata.sBIT_greenBits);
                chunkStream.writeByte(this.metadata.sBIT_blueBits);
            }
            if (n == 4 || n == 6) {
                chunkStream.writeByte(this.metadata.sBIT_alphaBits);
            }
            chunkStream.finish();
        }
    }

    private void write_sRGB() throws IOException {
        if (this.metadata.sRGB_present) {
            ChunkStream chunkStream = new ChunkStream(1934772034, this.stream);
            chunkStream.writeByte(this.metadata.sRGB_renderingIntent);
            chunkStream.finish();
        }
    }

    private void write_PLTE() throws IOException {
        if (this.metadata.PLTE_present) {
            if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
                this.processWarningOccurred(0, "A PLTE chunk may not appear in a gray or gray alpha image.\nThe chunk will not be written");
                return;
            }
            ChunkStream chunkStream = new ChunkStream(1347179589, this.stream);
            int n = this.metadata.PLTE_red.length;
            byte[] byArray = new byte[n * 3];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                byArray[n2++] = this.metadata.PLTE_red[i];
                byArray[n2++] = this.metadata.PLTE_green[i];
                byArray[n2++] = this.metadata.PLTE_blue[i];
            }
            chunkStream.write(byArray);
            chunkStream.finish();
        }
    }

    private void write_hIST() throws IOException, IIOException {
        if (this.metadata.hIST_present) {
            ChunkStream chunkStream = new ChunkStream(1749635924, this.stream);
            if (!this.metadata.PLTE_present) {
                throw new IIOException("hIST chunk without PLTE chunk!");
            }
            chunkStream.writeChars(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
            chunkStream.finish();
        }
    }

    private void write_tRNS() throws IOException, IIOException {
        if (this.metadata.tRNS_present) {
            ChunkStream chunkStream = new ChunkStream(1951551059, this.stream);
            int n = this.metadata.IHDR_colorType;
            int n2 = this.metadata.tRNS_colorType;
            int n3 = this.metadata.tRNS_red;
            int n4 = this.metadata.tRNS_green;
            int n5 = this.metadata.tRNS_blue;
            if (n == 2 && n2 == 0) {
                n2 = n;
                n4 = n5 = this.metadata.tRNS_gray;
                n3 = n5;
            }
            if (n2 != n) {
                this.processWarningOccurred(0, "tRNS metadata has incompatible color type.\nThe chunk will not be written.");
                return;
            }
            if (n == 3) {
                if (!this.metadata.PLTE_present) {
                    throw new IIOException("tRNS chunk without PLTE chunk!");
                }
                chunkStream.write(this.metadata.tRNS_alpha);
            } else if (n == 0) {
                chunkStream.writeShort(this.metadata.tRNS_gray);
            } else if (n == 2) {
                chunkStream.writeShort(n3);
                chunkStream.writeShort(n4);
                chunkStream.writeShort(n5);
            } else {
                throw new IIOException("tRNS chunk for color type 4 or 6!");
            }
            chunkStream.finish();
        }
    }

    private void write_bKGD() throws IOException {
        if (this.metadata.bKGD_present) {
            ChunkStream chunkStream = new ChunkStream(1649100612, this.stream);
            int n = this.metadata.IHDR_colorType & 3;
            int n2 = this.metadata.bKGD_colorType;
            int n3 = this.metadata.bKGD_red;
            int n4 = this.metadata.bKGD_red;
            int n5 = this.metadata.bKGD_red;
            if (n == 2 && n2 == 0) {
                n2 = n;
                n4 = n5 = this.metadata.bKGD_gray;
                n3 = n5;
            }
            if (n2 != n) {
                this.processWarningOccurred(0, "bKGD metadata has incompatible color type.\nThe chunk will not be written.");
                return;
            }
            if (n == 3) {
                chunkStream.writeByte(this.metadata.bKGD_index);
            } else if (n == 0 || n == 4) {
                chunkStream.writeShort(this.metadata.bKGD_gray);
            } else {
                chunkStream.writeShort(n3);
                chunkStream.writeShort(n4);
                chunkStream.writeShort(n5);
            }
            chunkStream.finish();
        }
    }

    private void write_pHYs() throws IOException {
        if (this.metadata.pHYs_present) {
            ChunkStream chunkStream = new ChunkStream(1883789683, this.stream);
            chunkStream.writeInt(this.metadata.pHYs_pixelsPerUnitXAxis);
            chunkStream.writeInt(this.metadata.pHYs_pixelsPerUnitYAxis);
            chunkStream.writeByte(this.metadata.pHYs_unitSpecifier);
            chunkStream.finish();
        }
    }

    private void write_sPLT() throws IOException {
        if (this.metadata.sPLT_present) {
            ChunkStream chunkStream = new ChunkStream(1934642260, this.stream);
            chunkStream.writeBytes(this.metadata.sPLT_paletteName);
            chunkStream.writeByte(0);
            chunkStream.writeByte(this.metadata.sPLT_sampleDepth);
            int n = this.metadata.sPLT_red.length;
            if (this.metadata.sPLT_sampleDepth == 8) {
                for (int i = 0; i < n; ++i) {
                    chunkStream.writeByte(this.metadata.sPLT_red[i]);
                    chunkStream.writeByte(this.metadata.sPLT_green[i]);
                    chunkStream.writeByte(this.metadata.sPLT_blue[i]);
                    chunkStream.writeByte(this.metadata.sPLT_alpha[i]);
                    chunkStream.writeShort(this.metadata.sPLT_frequency[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    chunkStream.writeShort(this.metadata.sPLT_red[i]);
                    chunkStream.writeShort(this.metadata.sPLT_green[i]);
                    chunkStream.writeShort(this.metadata.sPLT_blue[i]);
                    chunkStream.writeShort(this.metadata.sPLT_alpha[i]);
                    chunkStream.writeShort(this.metadata.sPLT_frequency[i]);
                }
            }
            chunkStream.finish();
        }
    }

    private void write_tIME() throws IOException {
        if (this.metadata.tIME_present) {
            ChunkStream chunkStream = new ChunkStream(1950960965, this.stream);
            chunkStream.writeShort(this.metadata.tIME_year);
            chunkStream.writeByte(this.metadata.tIME_month);
            chunkStream.writeByte(this.metadata.tIME_day);
            chunkStream.writeByte(this.metadata.tIME_hour);
            chunkStream.writeByte(this.metadata.tIME_minute);
            chunkStream.writeByte(this.metadata.tIME_second);
            chunkStream.finish();
        }
    }

    private void write_tEXt() throws IOException {
        Iterator iterator = this.metadata.tEXt_keyword.iterator();
        Iterator iterator2 = this.metadata.tEXt_text.iterator();
        while (iterator.hasNext()) {
            ChunkStream chunkStream = new ChunkStream(1950701684, this.stream);
            String string = (String)iterator.next();
            chunkStream.writeBytes(string);
            chunkStream.writeByte(0);
            String string2 = (String)iterator2.next();
            chunkStream.writeBytes(string2);
            chunkStream.finish();
        }
    }

    private byte[] deflate(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            deflaterOutputStream.write(0xFF & byArray[i]);
        }
        deflaterOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void write_iTXt() throws IOException {
        Iterator iterator = this.metadata.iTXt_keyword.iterator();
        Iterator iterator2 = this.metadata.iTXt_compressionFlag.iterator();
        Iterator iterator3 = this.metadata.iTXt_compressionMethod.iterator();
        Iterator iterator4 = this.metadata.iTXt_languageTag.iterator();
        Iterator iterator5 = this.metadata.iTXt_translatedKeyword.iterator();
        Iterator iterator6 = this.metadata.iTXt_text.iterator();
        while (iterator.hasNext()) {
            ChunkStream chunkStream = new ChunkStream(1767135348, this.stream);
            chunkStream.writeBytes((String)iterator.next());
            chunkStream.writeByte(0);
            Boolean bl = (Boolean)iterator2.next();
            chunkStream.writeByte(bl != false ? 1 : 0);
            chunkStream.writeByte((Integer)iterator3.next());
            chunkStream.writeBytes((String)iterator4.next());
            chunkStream.writeByte(0);
            chunkStream.write(((String)iterator5.next()).getBytes("UTF8"));
            chunkStream.writeByte(0);
            String string = (String)iterator6.next();
            if (bl.booleanValue()) {
                chunkStream.write(this.deflate(string.getBytes("UTF8")));
            } else {
                chunkStream.write(string.getBytes("UTF8"));
            }
            chunkStream.finish();
        }
    }

    private void write_zTXt() throws IOException {
        Iterator iterator = this.metadata.zTXt_keyword.iterator();
        Iterator iterator2 = this.metadata.zTXt_compressionMethod.iterator();
        Iterator iterator3 = this.metadata.zTXt_text.iterator();
        while (iterator.hasNext()) {
            ChunkStream chunkStream = new ChunkStream(2052348020, this.stream);
            String string = (String)iterator.next();
            chunkStream.writeBytes(string);
            chunkStream.writeByte(0);
            int n = (Integer)iterator2.next();
            chunkStream.writeByte(n);
            String string2 = (String)iterator3.next();
            chunkStream.write(this.deflate(string2.getBytes()));
            chunkStream.finish();
        }
    }

    private void writeUnknownChunks() throws IOException {
        Iterator iterator = this.metadata.unknownChunkType.iterator();
        Iterator iterator2 = this.metadata.unknownChunkData.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string = (String)iterator.next();
            ChunkStream chunkStream = new ChunkStream(PNGImageWriter.chunkType(string), this.stream);
            byte[] byArray = (byte[])iterator2.next();
            chunkStream.write(byArray);
            chunkStream.finish();
        }
    }

    private static int chunkType(String string) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        char c3 = string.charAt(2);
        char c4 = string.charAt(3);
        int n = c << 24 | c2 << 16 | c3 << 8 | c4;
        return n;
    }

    private void encodePass(ImageOutputStream imageOutputStream, RenderedImage renderedImage, int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.sourceXOffset;
        int n6 = this.sourceYOffset;
        int n7 = this.sourceWidth;
        int n8 = this.sourceHeight;
        int n9 = (n7 - (n *= this.periodX) + (n3 *= this.periodX) - 1) / n3;
        int n10 = (n8 - (n2 *= this.periodY) + (n4 *= this.periodY) - 1) / n4;
        if (n9 == 0 || n10 == 0) {
            return;
        }
        n *= this.numBands;
        n3 *= this.numBands;
        int n11 = 8 / this.metadata.IHDR_bitDepth;
        int n12 = n7 * this.numBands;
        int[] nArray = new int[n12];
        int n13 = n9 * this.numBands;
        if (this.metadata.IHDR_bitDepth < 8) {
            n13 = (n13 + n11 - 1) / n11;
        } else if (this.metadata.IHDR_bitDepth == 16) {
            n13 *= 2;
        }
        IndexColorModel indexColorModel = null;
        if (this.metadata.IHDR_colorType == 4 && renderedImage.getColorModel() instanceof IndexColorModel) {
            n13 *= 2;
            indexColorModel = (IndexColorModel)renderedImage.getColorModel();
        }
        this.currRow = new byte[n13 + this.bpp];
        this.prevRow = new byte[n13 + this.bpp];
        this.filteredRows = new byte[5][n13 + this.bpp];
        int n14 = this.metadata.IHDR_bitDepth;
        for (int i = n6 + n2; i < n6 + n8; i += n4) {
            int n15;
            int n16;
            Object object;
            Rectangle rectangle = new Rectangle(n5, i, n7, 1);
            Raster raster = renderedImage.getData(rectangle);
            if (this.sourceBands != null) {
                raster = raster.createChild(n5, i, n7, 1, n5, i, this.sourceBands);
            }
            raster.getPixels(n5, i, n7, 1, nArray);
            if (renderedImage.getColorModel().isAlphaPremultiplied()) {
                object = raster.createCompatibleWritableRaster();
                ((WritableRaster)object).setPixels(((Raster)object).getMinX(), ((Raster)object).getMinY(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), nArray);
                renderedImage.getColorModel().coerceData((WritableRaster)object, false);
                ((Raster)object).getPixels(((Raster)object).getMinX(), ((Raster)object).getMinY(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), nArray);
            }
            if ((object = (Object)this.metadata.PLTE_order) != null) {
                for (n16 = 0; n16 < n12; ++n16) {
                    nArray[n16] = (int)object[nArray[n16]];
                }
            }
            n16 = this.bpp;
            int n17 = 0;
            int n18 = 0;
            switch (n14) {
                case 1: 
                case 2: 
                case 4: {
                    int n19;
                    n15 = n11 - 1;
                    for (int j = n; j < n12; j += n3) {
                        n19 = this.scale0[nArray[j]];
                        n18 = n18 << n14 | n19;
                        if ((n17++ & n15) != n15) continue;
                        this.currRow[n16++] = (byte)n18;
                        n18 = 0;
                        n17 = 0;
                    }
                    if ((n17 & n15) == 0) break;
                    this.currRow[n16++] = (byte)(n18 <<= (8 / n14 - n17) * n14);
                    break;
                }
                case 8: {
                    int n19;
                    if (this.numBands == 1) {
                        for (int j = n; j < n12; j += n3) {
                            this.currRow[n16++] = this.scale0[nArray[j]];
                            if (indexColorModel == null) continue;
                            this.currRow[n16++] = this.scale0[indexColorModel.getAlpha(0xFF & nArray[j])];
                        }
                    } else {
                        for (int j = n; j < n12; j += n3) {
                            for (n19 = 0; n19 < this.numBands; ++n19) {
                                this.currRow[n16++] = this.scale[n19][nArray[j + n19]];
                            }
                        }
                    }
                    break;
                }
                case 16: {
                    int n19;
                    for (int j = n; j < n12; j += n3) {
                        for (n19 = 0; n19 < this.numBands; ++n19) {
                            this.currRow[n16++] = this.scaleh[n19][nArray[j + n19]];
                            this.currRow[n16++] = this.scalel[n19][nArray[j + n19]];
                        }
                    }
                    break;
                }
            }
            n15 = this.rowFilter.filterRow(this.metadata.IHDR_colorType, this.currRow, this.prevRow, this.filteredRows, n13, this.bpp);
            imageOutputStream.write(n15);
            imageOutputStream.write(this.filteredRows[n15], this.bpp, n13);
            byte[] byArray = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = byArray;
            this.pixelsDone += n9;
            this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
            if (!this.abortRequested()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_IDAT(RenderedImage renderedImage) throws IOException {
        block5: {
            IDATOutputStream iDATOutputStream = new IDATOutputStream(this.stream, 32768);
            try {
                if (this.metadata.IHDR_interlaceMethod == 1) {
                    for (int i = 0; i < 7; ++i) {
                        this.encodePass(iDATOutputStream, renderedImage, PNGImageReader.adam7XOffset[i], PNGImageReader.adam7YOffset[i], PNGImageReader.adam7XSubsampling[i], PNGImageReader.adam7YSubsampling[i]);
                        if (!this.abortRequested()) continue;
                        break block5;
                    }
                    break block5;
                }
                this.encodePass(iDATOutputStream, renderedImage, 0, 0, 1, 1);
            }
            finally {
                iDATOutputStream.finish();
            }
        }
    }

    private void writeIEND() throws IOException {
        ChunkStream chunkStream = new ChunkStream(1229278788, this.stream);
        chunkStream.finish();
    }

    private boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void initializeScaleTables(int[] nArray) {
        int n = this.metadata.IHDR_bitDepth;
        if (n == this.scalingBitDepth && this.equals(nArray, this.sampleSize)) {
            return;
        }
        this.sampleSize = nArray;
        this.scalingBitDepth = n;
        int n2 = (1 << n) - 1;
        if (n <= 8) {
            this.scale = new byte[this.numBands][];
            for (int i = 0; i < this.numBands; ++i) {
                int n3 = (1 << nArray[i]) - 1;
                int n4 = n3 / 2;
                this.scale[i] = new byte[n3 + 1];
                for (int j = 0; j <= n3; ++j) {
                    this.scale[i][j] = (byte)((j * n2 + n4) / n3);
                }
            }
            this.scale0 = this.scale[0];
            this.scalel = null;
            this.scaleh = this.scalel;
        } else {
            this.scaleh = new byte[this.numBands][];
            this.scalel = new byte[this.numBands][];
            for (int i = 0; i < this.numBands; ++i) {
                int n5 = (1 << nArray[i]) - 1;
                int n6 = n5 / 2;
                this.scaleh[i] = new byte[n5 + 1];
                this.scalel[i] = new byte[n5 + 1];
                for (int j = 0; j <= n5; ++j) {
                    int n7 = (j * n2 + n6) / n5;
                    this.scaleh[i][j] = (byte)(n7 >> 8);
                    this.scalel[i][j] = (byte)(n7 & 0xFF);
                }
            }
            this.scale = null;
            this.scale0 = null;
        }
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IIOException {
        int n;
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("image has a Raster!");
        }
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        SampleModel sampleModel = renderedImage.getSampleModel();
        this.numBands = sampleModel.getNumBands();
        this.sourceXOffset = renderedImage.getMinX();
        this.sourceYOffset = renderedImage.getMinY();
        this.sourceWidth = renderedImage.getWidth();
        this.sourceHeight = renderedImage.getHeight();
        this.sourceBands = null;
        this.periodX = 1;
        this.periodY = 1;
        if (imageWriteParam != null) {
            Rectangle rectangle = imageWriteParam.getSourceRegion();
            if (rectangle != null) {
                Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
                rectangle = rectangle.intersection(rectangle2);
                this.sourceXOffset = rectangle.x;
                this.sourceYOffset = rectangle.y;
                this.sourceWidth = rectangle.width;
                this.sourceHeight = rectangle.height;
            }
            n = imageWriteParam.getSubsamplingXOffset();
            int n2 = imageWriteParam.getSubsamplingYOffset();
            this.sourceXOffset += n;
            this.sourceYOffset += n2;
            this.sourceWidth -= n;
            this.sourceHeight -= n2;
            this.periodX = imageWriteParam.getSourceXSubsampling();
            this.periodY = imageWriteParam.getSourceYSubsampling();
            int[] nArray = imageWriteParam.getSourceBands();
            if (nArray != null) {
                this.sourceBands = nArray;
                this.numBands = this.sourceBands.length;
            }
        }
        int n3 = (this.sourceWidth + this.periodX - 1) / this.periodX;
        n = (this.sourceHeight + this.periodY - 1) / this.periodY;
        if (n3 <= 0 || n <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
        this.totalPixels = n3 * n;
        this.pixelsDone = 0;
        IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
        this.metadata = iIOMetadata2 != null ? (PNGMetadata)this.convertImageMetadata(iIOMetadata2, ImageTypeSpecifier.createFromRenderedImage(renderedImage), null) : new PNGMetadata();
        if (imageWriteParam != null) {
            switch (imageWriteParam.getProgressiveMode()) {
                case 1: {
                    this.metadata.IHDR_interlaceMethod = 1;
                    break;
                }
                case 0: {
                    this.metadata.IHDR_interlaceMethod = 0;
                }
            }
        }
        this.metadata.initialize(new ImageTypeSpecifier(renderedImage), this.numBands);
        this.metadata.IHDR_width = n3;
        this.metadata.IHDR_height = n;
        this.bpp = this.numBands * (this.metadata.IHDR_bitDepth == 16 ? 2 : 1);
        this.initializeScaleTables(sampleModel.getSampleSize());
        this.clearAbortRequest();
        this.processImageStarted(0);
        try {
            this.write_magic();
            this.write_IHDR();
            this.write_cHRM();
            this.write_gAMA();
            this.write_iCCP();
            this.write_sBIT();
            this.write_sRGB();
            this.write_PLTE();
            this.write_hIST();
            this.write_tRNS();
            this.write_bKGD();
            this.write_pHYs();
            this.write_sPLT();
            this.write_tIME();
            this.write_tEXt();
            this.write_iTXt();
            this.write_zTXt();
            this.writeUnknownChunks();
            this.write_IDAT(renderedImage);
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.writeIEND();
                this.processImageComplete();
            }
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error writing PNG file!", iOException);
        }
    }
}

