/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.addressing.model.MissingAddressingHeaderException;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Headers;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codecs;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.DOMMessage;
import com.sun.xml.internal.ws.message.EmptyMessageImpl;
import com.sun.xml.internal.ws.message.ProblemActionHeader;
import com.sun.xml.internal.ws.message.jaxb.JAXBMessage;
import com.sun.xml.internal.ws.message.saaj.SAAJMessage;
import com.sun.xml.internal.ws.message.source.PayloadSourceMessage;
import com.sun.xml.internal.ws.message.source.ProtocolSourceMessage;
import com.sun.xml.internal.ws.message.stream.PayloadStreamReaderMessage;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.DOMUtil;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Messages {
    private Messages() {
    }

    public static Message create(JAXBRIContext jAXBRIContext, Object object, SOAPVersion sOAPVersion) {
        return JAXBMessage.create(jAXBRIContext, object, sOAPVersion);
    }

    public static Message create(Marshaller marshaller, Object object, SOAPVersion sOAPVersion) {
        return Messages.create(((MarshallerImpl)marshaller).getContext(), object, sOAPVersion);
    }

    public static Message create(SOAPMessage sOAPMessage) {
        return new SAAJMessage(sOAPMessage);
    }

    public static Message createUsingPayload(Source source, SOAPVersion sOAPVersion) {
        return new PayloadSourceMessage(source, sOAPVersion);
    }

    public static Message createUsingPayload(XMLStreamReader xMLStreamReader, SOAPVersion sOAPVersion) {
        return new PayloadStreamReaderMessage(xMLStreamReader, sOAPVersion);
    }

    public static Message createUsingPayload(Element element, SOAPVersion sOAPVersion) {
        return new DOMMessage(sOAPVersion, element);
    }

    public static Message create(Element element) {
        Node node;
        SOAPVersion sOAPVersion = SOAPVersion.fromNsUri(element.getNamespaceURI());
        Element element2 = DOMUtil.getFirstChild(element, sOAPVersion.nsUri, "Header");
        HeaderList headerList = null;
        if (element2 != null) {
            for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                if (headerList == null) {
                    headerList = new HeaderList();
                }
                headerList.add(Headers.create((Element)node));
            }
        }
        if ((node = DOMUtil.getFirstChild(element, sOAPVersion.nsUri, "Body")) == null) {
            throw new WebServiceException("Message doesn't have <S:Body> " + element);
        }
        Element element3 = DOMUtil.getFirstChild(element, sOAPVersion.nsUri, "Body");
        if (element3 == null) {
            return new EmptyMessageImpl(headerList, new AttachmentSetImpl(), sOAPVersion);
        }
        return new DOMMessage(sOAPVersion, headerList, element3);
    }

    public static Message create(Source source, SOAPVersion sOAPVersion) {
        return new ProtocolSourceMessage(source, sOAPVersion);
    }

    public static Message createEmpty(SOAPVersion sOAPVersion) {
        return new EmptyMessageImpl(sOAPVersion);
    }

    @NotNull
    public static Message create(@NotNull XMLStreamReader xMLStreamReader) {
        if (xMLStreamReader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        assert (xMLStreamReader.getEventType() == 1) : xMLStreamReader.getEventType();
        SOAPVersion sOAPVersion = SOAPVersion.fromNsUri(xMLStreamReader.getNamespaceURI());
        return Codecs.createSOAPEnvelopeXmlCodec(sOAPVersion).decode(xMLStreamReader);
    }

    @NotNull
    public static Message create(@NotNull XMLStreamBuffer xMLStreamBuffer) {
        try {
            return Messages.create(xMLStreamBuffer.readAsXMLStreamReader());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLStreamReaderException(xMLStreamException);
        }
    }

    public static Message create(Throwable throwable, SOAPVersion sOAPVersion) {
        return SOAPFaultBuilder.createSOAPFaultMessage(sOAPVersion, null, throwable);
    }

    public static Message create(SOAPFault sOAPFault) {
        SOAPVersion sOAPVersion = SOAPVersion.fromNsUri(sOAPFault.getNamespaceURI());
        return new DOMMessage(sOAPVersion, sOAPFault);
    }

    public static Message createAddressingFaultMessage(WSBinding wSBinding, QName qName) {
        return Messages.createAddressingFaultMessage(wSBinding, null, qName);
    }

    public static Message createAddressingFaultMessage(WSBinding wSBinding, Packet packet, QName qName) {
        AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
        if (addressingVersion == null) {
            throw new WebServiceException(AddressingMessages.ADDRESSING_SHOULD_BE_ENABLED());
        }
        WsaTubeHelper wsaTubeHelper = addressingVersion.getWsaHelper(null, null, wSBinding);
        return Messages.create(wsaTubeHelper.newMapRequiredFault(new MissingAddressingHeaderException(qName, packet)));
    }

    public static Message create(@NotNull String string, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        Message message;
        QName qName = addressingVersion.actionNotSupportedTag;
        String string2 = String.format(addressingVersion.actionNotSupportedText, string);
        try {
            SOAPFault sOAPFault;
            if (sOAPVersion == SOAPVersion.SOAP_12) {
                sOAPFault = SOAPVersion.SOAP_12.saajSoapFactory.createFault();
                sOAPFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                sOAPFault.appendFaultSubcode(qName);
                Detail detail = sOAPFault.addDetail();
                SOAPElement sOAPElement = detail.addChildElement(addressingVersion.problemActionTag);
                sOAPElement = sOAPElement.addChildElement(addressingVersion.actionTag);
                sOAPElement.addTextNode(string);
            } else {
                sOAPFault = SOAPVersion.SOAP_11.saajSoapFactory.createFault();
                sOAPFault.setFaultCode(qName);
            }
            sOAPFault.setFaultString(string2);
            message = SOAPFaultBuilder.createSOAPFaultMessage(sOAPVersion, sOAPFault);
            if (sOAPVersion == SOAPVersion.SOAP_11) {
                message.getHeaders().add(new ProblemActionHeader(string, addressingVersion));
            }
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
        return message;
    }

    @NotNull
    public static Message create(@NotNull SOAPVersion sOAPVersion, @NotNull ProtocolException protocolException, @Nullable QName qName) {
        return SOAPFaultBuilder.createSOAPFaultMessage(sOAPVersion, protocolException, qName);
    }
}

