/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.ServiceDefinition;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.MetadataUtil;
import com.sun.xml.internal.ws.util.pipe.AbstractSchemaValidationTube;
import com.sun.xml.internal.ws.util.xml.MetadataDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ServerSchemaValidationTube
extends AbstractSchemaValidationTube {
    private static final Logger LOGGER = Logger.getLogger(ServerSchemaValidationTube.class.getName());
    private final Schema schema;
    private final Validator validator;
    private final boolean noValidation;

    public ServerSchemaValidationTube(WSEndpoint wSEndpoint, WSBinding wSBinding, Tube tube) {
        super(wSBinding, tube);
        Source[] sourceArray;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        for (Source source : sourceArray = this.getSchemaSources(wSEndpoint.getServiceDefinition())) {
            LOGGER.fine("Constructing validation Schema from = " + source.getSystemId());
        }
        if (sourceArray.length != 0) {
            this.noValidation = false;
            schemaFactory.setResourceResolver(new MetadataResolverImpl(wSEndpoint.getServiceDefinition()));
            try {
                this.schema = schemaFactory.newSchema(sourceArray);
            }
            catch (SAXException sAXException) {
                throw new WebServiceException(sAXException);
            }
            this.validator = this.schema.newValidator();
        } else {
            this.noValidation = true;
            this.schema = null;
            this.validator = null;
        }
    }

    private Source[] getSchemaSources(ServiceDefinition serviceDefinition) {
        String string = serviceDefinition.getPrimary().getURL().toExternalForm();
        MetadataResolverImpl metadataResolverImpl = new MetadataResolverImpl(serviceDefinition);
        Map<String, SDDocument> map = MetadataUtil.getMetadataClosure(string, metadataResolverImpl, true);
        ArrayList<Source> arrayList = new ArrayList<Source>();
        for (Map.Entry<String, SDDocument> entry : map.entrySet()) {
            Document document;
            SDDocument sDDocument = entry.getValue();
            if (sDDocument.isWSDL()) {
                document = this.createDOM(sDDocument);
                this.addSchemaFragmentSource(document, sDDocument.getURL().toExternalForm(), arrayList);
                continue;
            }
            if (!sDDocument.isSchema()) continue;
            document = this.createDOM(sDDocument);
            arrayList.add(new DOMSource(document, sDDocument.getURL().toExternalForm()));
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    protected Validator getValidator() {
        return this.validator;
    }

    protected boolean isNoValidation() {
        return this.noValidation;
    }

    private void buildNamespaceSupport(NamespaceSupport namespaceSupport, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(namespaceSupport, node.getParentNode());
        namespaceSupport.pushContext();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if ("xmlns".equals(attr.getPrefix())) {
                namespaceSupport.declarePrefix(attr.getLocalName(), attr.getValue());
                continue;
            }
            if (!"xmlns".equals(attr.getName())) continue;
            namespaceSupport.declarePrefix("", attr.getValue());
        }
    }

    @Nullable
    private void patchDOMFragment(NamespaceSupport namespaceSupport, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Enumeration enumeration = namespaceSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if ("xmlns".equals(attr.getPrefix()) && attr.getLocalName().equals("prefix")) continue;
                LOGGER.fine("Patching with xmlns:" + string + "=" + namespaceSupport.getURI(string));
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, namespaceSupport.getURI(string));
            }
        }
    }

    protected ServerSchemaValidationTube(ServerSchemaValidationTube serverSchemaValidationTube, TubeCloner tubeCloner) {
        super(serverSchemaValidationTube, tubeCloner);
        this.schema = serverSchemaValidationTube.schema;
        this.validator = this.schema.newValidator();
        this.noValidation = serverSchemaValidationTube.noValidation;
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new ServerSchemaValidationTube(this, tubeCloner);
    }

    private class MetadataResolverImpl
    implements MetadataUtil.MetadataResolver,
    LSResourceResolver {
        Map<String, SDDocument> docs = new HashMap<String, SDDocument>();

        MetadataResolverImpl(ServiceDefinition serviceDefinition) {
            Iterator iterator = serviceDefinition.iterator();
            while (iterator.hasNext()) {
                SDDocument sDDocument;
                SDDocument sDDocument2 = sDDocument = (SDDocument)iterator.next();
                this.docs.put(sDDocument2.getURL().toExternalForm(), sDDocument2);
            }
        }

        public SDDocument resolveEntity(String string) {
            SDDocument sDDocument = this.docs.get(string);
            if (sDDocument == null) {
                SDDocumentSource sDDocumentSource;
                try {
                    sDDocumentSource = SDDocumentSource.create(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WebServiceException(malformedURLException);
                }
                sDDocument = MetadataDocument.create(sDDocumentSource, new QName(""), new QName(""));
                this.docs.put(string, sDDocument);
            }
            return sDDocument;
        }

        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            LOGGER.fine("type=" + string + " namespaceURI=" + string2 + " publicId=" + string3 + " systemId=" + string4 + " baseURI=" + string5);
            try {
                URL uRL = string5 == null ? null : new URL(string5);
                final URL uRL2 = new URL(uRL, string4);
                final SDDocument sDDocument = this.docs.get(uRL2.toExternalForm());
                if (sDDocument != null) {
                    return new LSInput(){

                        public Reader getCharacterStream() {
                            return null;
                        }

                        public void setCharacterStream(Reader reader) {
                            throw new UnsupportedOperationException();
                        }

                        public InputStream getByteStream() {
                            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                            try {
                                sDDocument.writeTo(null, ServerSchemaValidationTube.this.resolver, byteArrayBuffer);
                            }
                            catch (IOException iOException) {
                                throw new WebServiceException(iOException);
                            }
                            return byteArrayBuffer.newInputStream();
                        }

                        public void setByteStream(InputStream inputStream) {
                            throw new UnsupportedOperationException();
                        }

                        public String getStringData() {
                            return null;
                        }

                        public void setStringData(String string) {
                            throw new UnsupportedOperationException();
                        }

                        public String getSystemId() {
                            return uRL2.toExternalForm();
                        }

                        public void setSystemId(String string) {
                            throw new UnsupportedOperationException();
                        }

                        public String getPublicId() {
                            return null;
                        }

                        public void setPublicId(String string) {
                            throw new UnsupportedOperationException();
                        }

                        public String getBaseURI() {
                            return uRL2.toExternalForm();
                        }

                        public void setBaseURI(String string) {
                            throw new UnsupportedOperationException();
                        }

                        public String getEncoding() {
                            return null;
                        }

                        public void setEncoding(String string) {
                            throw new UnsupportedOperationException();
                        }

                        public boolean getCertifiedText() {
                            return false;
                        }

                        public void setCertifiedText(boolean bl) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception in LSResourceResolver impl", exception);
            }
            LOGGER.fine("Don't know about systemId=" + string4 + " baseURI=" + string5);
            return null;
        }
    }
}

