/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageReader {
    protected ImageReaderSpi originatingProvider;
    protected Object input = null;
    protected boolean seekForwardOnly = false;
    protected boolean ignoreMetadata = false;
    protected int minIndex = 0;
    protected Locale[] availableLocales = null;
    protected Locale locale = null;
    protected List<IIOReadWarningListener> warningListeners = null;
    protected List<Locale> warningLocales = null;
    protected List<IIOReadProgressListener> progressListeners = null;
    protected List<IIOReadUpdateListener> updateListeners = null;
    private boolean abortFlag = false;

    protected ImageReader(ImageReaderSpi imageReaderSpi) {
        this.originatingProvider = imageReaderSpi;
    }

    public String getFormatName() throws IOException {
        return this.originatingProvider.getFormatNames()[0];
    }

    public ImageReaderSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        if (object != null) {
            boolean bl3 = false;
            if (this.originatingProvider != null) {
                Class[] classArray = this.originatingProvider.getInputTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!classArray[i].isInstance(object)) continue;
                    bl3 = true;
                    break;
                }
            } else if (object instanceof ImageInputStream) {
                bl3 = true;
            }
            if (!bl3) {
                throw new IllegalArgumentException("Incorrect input type!");
            }
            this.seekForwardOnly = bl;
            this.ignoreMetadata = bl2;
            this.minIndex = 0;
        }
        this.input = object;
    }

    public void setInput(Object object, boolean bl) {
        this.setInput(object, bl, false);
    }

    public void setInput(Object object) {
        this.setInput(object, false, false);
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isSeekForwardOnly() {
        return this.seekForwardOnly;
    }

    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            return null;
        }
        return (Locale[])this.availableLocales.clone();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            Locale[] localeArray = this.getAvailableLocales();
            boolean bl = false;
            if (localeArray != null) {
                for (int i = 0; i < localeArray.length; ++i) {
                    if (!locale.equals(localeArray[i])) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid locale!");
            }
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract int getNumImages(boolean var1) throws IOException;

    public abstract int getWidth(int var1) throws IOException;

    public abstract int getHeight(int var1) throws IOException;

    public boolean isRandomAccessEasy(int n) throws IOException {
        return false;
    }

    public float getAspectRatio(int n) throws IOException {
        return (float)this.getWidth(n) / (float)this.getHeight(n);
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        return this.getImageTypes(n).next();
    }

    public abstract Iterator<ImageTypeSpecifier> getImageTypes(int var1) throws IOException;

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public abstract IIOMetadata getStreamMetadata() throws IOException;

    public IIOMetadata getStreamMetadata(String string, Set<String> set) throws IOException {
        return this.getMetadata(string, set, true, 0);
    }

    private IIOMetadata getMetadata(String string, Set set, boolean bl, int n) throws IOException {
        IIOMetadata iIOMetadata;
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (set == null) {
            throw new IllegalArgumentException("nodeNames == null!");
        }
        IIOMetadata iIOMetadata2 = iIOMetadata = bl ? this.getStreamMetadata() : this.getImageMetadata(n);
        if (iIOMetadata != null) {
            if (iIOMetadata.isStandardMetadataFormatSupported() && string.equals("javax_imageio_1.0")) {
                return iIOMetadata;
            }
            String string2 = iIOMetadata.getNativeMetadataFormatName();
            if (string2 != null && string.equals(string2)) {
                return iIOMetadata;
            }
            String[] stringArray = iIOMetadata.getExtraMetadataFormatNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    return iIOMetadata;
                }
            }
        }
        return null;
    }

    public abstract IIOMetadata getImageMetadata(int var1) throws IOException;

    public IIOMetadata getImageMetadata(int n, String string, Set<String> set) throws IOException {
        return this.getMetadata(string, set, false, n);
    }

    public BufferedImage read(int n) throws IOException {
        return this.read(n, null);
    }

    public abstract BufferedImage read(int var1, ImageReadParam var2) throws IOException;

    public IIOImage readAll(int n, ImageReadParam imageReadParam) throws IOException {
        if (n < this.getMinIndex()) {
            throw new IndexOutOfBoundsException("imageIndex < getMinIndex()!");
        }
        BufferedImage bufferedImage = this.read(n, imageReadParam);
        ArrayList<BufferedImage> arrayList = null;
        int n2 = this.getNumThumbnails(n);
        if (n2 > 0) {
            arrayList = new ArrayList<BufferedImage>();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(this.readThumbnail(n, i));
            }
        }
        IIOMetadata iIOMetadata = this.getImageMetadata(n);
        return new IIOImage(bufferedImage, arrayList, iIOMetadata);
    }

    public Iterator<IIOImage> readAll(Iterator<? extends ImageReadParam> iterator) throws IOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        int n = this.getMinIndex();
        this.processSequenceStarted(n);
        while (true) {
            Object object;
            ImageReadParam imageReadParam = null;
            if (iterator != null && iterator.hasNext() && (object = iterator.next()) != null) {
                if (object instanceof ImageReadParam) {
                    imageReadParam = (ImageReadParam)object;
                } else {
                    throw new IllegalArgumentException("Non-ImageReadParam supplied as part of params!");
                }
            }
            object = null;
            try {
                object = this.read(n, imageReadParam);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            ArrayList<BufferedImage> arrayList2 = null;
            int n2 = this.getNumThumbnails(n);
            if (n2 > 0) {
                arrayList2 = new ArrayList<BufferedImage>();
                for (int i = 0; i < n2; ++i) {
                    arrayList2.add(this.readThumbnail(n, i));
                }
            }
            IIOMetadata iIOMetadata = this.getImageMetadata(n);
            IIOImage iIOImage = new IIOImage((RenderedImage)object, arrayList2, iIOMetadata);
            arrayList.add(iIOImage);
            ++n;
        }
        this.processSequenceComplete();
        return arrayList.iterator();
    }

    public boolean canReadRaster() {
        return false;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        throw new UnsupportedOperationException("readRaster not supported!");
    }

    public boolean isImageTiled(int n) throws IOException {
        return false;
    }

    public int getTileWidth(int n) throws IOException {
        return this.getWidth(n);
    }

    public int getTileHeight(int n) throws IOException {
        return this.getHeight(n);
    }

    public int getTileGridXOffset(int n) throws IOException {
        return 0;
    }

    public int getTileGridYOffset(int n) throws IOException {
        return 0;
    }

    public BufferedImage readTile(int n, int n2, int n3) throws IOException {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException("Invalid tile indices");
        }
        return this.read(n);
    }

    public Raster readTileRaster(int n, int n2, int n3) throws IOException {
        if (!this.canReadRaster()) {
            throw new UnsupportedOperationException("readTileRaster not supported!");
        }
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException("Invalid tile indices");
        }
        return this.readRaster(n, null);
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        return this.read(n, imageReadParam);
    }

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public boolean hasThumbnails(int n) throws IOException {
        return this.getNumThumbnails(n) > 0;
    }

    public int getNumThumbnails(int n) throws IOException {
        return 0;
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        return this.readThumbnail(n, n2).getWidth();
    }

    public int getThumbnailHeight(int n, int n2) throws IOException {
        return this.readThumbnail(n, n2).getHeight();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        throw new UnsupportedOperationException("Thumbnails not supported!");
    }

    public synchronized void abort() {
        this.abortFlag = true;
    }

    protected synchronized boolean abortRequested() {
        return this.abortFlag;
    }

    protected synchronized void clearAbortRequest() {
        this.abortFlag = false;
    }

    static List addToList(List arrayList, Object object) {
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        arrayList.add(object);
        return arrayList;
    }

    static List removeFromList(List list, Object object) {
        if (list == null) {
            return list;
        }
        list.remove(object);
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null) {
            return;
        }
        this.warningListeners = ImageReader.addToList(this.warningListeners, iIOReadWarningListener);
        this.warningLocales = ImageReader.addToList(this.warningLocales, this.getLocale());
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null || this.warningListeners == null) {
            return;
        }
        int n = this.warningListeners.indexOf(iIOReadWarningListener);
        if (n != -1) {
            this.warningListeners.remove(n);
            this.warningLocales.remove(n);
            if (this.warningListeners.size() == 0) {
                this.warningListeners = null;
                this.warningLocales = null;
            }
        }
    }

    public void removeAllIIOReadWarningListeners() {
        this.warningListeners = null;
        this.warningLocales = null;
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null) {
            return;
        }
        this.progressListeners = ImageReader.addToList(this.progressListeners, iIOReadProgressListener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null || this.progressListeners == null) {
            return;
        }
        this.progressListeners = ImageReader.removeFromList(this.progressListeners, iIOReadProgressListener);
    }

    public void removeAllIIOReadProgressListeners() {
        this.progressListeners = null;
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null) {
            return;
        }
        this.updateListeners = ImageReader.addToList(this.updateListeners, iIOReadUpdateListener);
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null || this.updateListeners == null) {
            return;
        }
        this.updateListeners = ImageReader.removeFromList(this.updateListeners, iIOReadUpdateListener);
    }

    public void removeAllIIOReadUpdateListeners() {
        this.updateListeners = null;
    }

    protected void processSequenceStarted(int n) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        for (int i = 0; i < n2; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.sequenceStarted(this, n);
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.sequenceComplete(this);
        }
    }

    protected void processImageStarted(int n) {
        if (this.progressListeners == null) {
            return;
        }
        int n2 = this.progressListeners.size();
        for (int i = 0; i < n2; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.imageStarted(this, n);
        }
    }

    protected void processImageProgress(float f) {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.imageProgress(this, f);
        }
    }

    protected void processImageComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.imageComplete(this);
        }
    }

    protected void processThumbnailStarted(int n, int n2) {
        if (this.progressListeners == null) {
            return;
        }
        int n3 = this.progressListeners.size();
        for (int i = 0; i < n3; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.thumbnailStarted(this, n, n2);
        }
    }

    protected void processThumbnailProgress(float f) {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.thumbnailProgress(this, f);
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.thumbnailComplete(this);
        }
    }

    protected void processReadAborted() {
        if (this.progressListeners == null) {
            return;
        }
        int n = this.progressListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadProgressListener iIOReadProgressListener = this.progressListeners.get(i);
            iIOReadProgressListener.readAborted(this);
        }
    }

    protected void processPassStarted(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n8 = this.updateListeners.size();
        for (int i = 0; i < n8; ++i) {
            IIOReadUpdateListener iIOReadUpdateListener = this.updateListeners.get(i);
            iIOReadUpdateListener.passStarted(this, bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
        }
    }

    protected void processImageUpdate(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n7 = this.updateListeners.size();
        for (int i = 0; i < n7; ++i) {
            IIOReadUpdateListener iIOReadUpdateListener = this.updateListeners.get(i);
            iIOReadUpdateListener.imageUpdate(this, bufferedImage, n, n2, n3, n4, n5, n6, nArray);
        }
    }

    protected void processPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners == null) {
            return;
        }
        int n = this.updateListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadUpdateListener iIOReadUpdateListener = this.updateListeners.get(i);
            iIOReadUpdateListener.passComplete(this, bufferedImage);
        }
    }

    protected void processThumbnailPassStarted(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n8 = this.updateListeners.size();
        for (int i = 0; i < n8; ++i) {
            IIOReadUpdateListener iIOReadUpdateListener = this.updateListeners.get(i);
            iIOReadUpdateListener.thumbnailPassStarted(this, bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
        }
    }

    protected void processThumbnailUpdate(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (this.updateListeners == null) {
            return;
        }
        int n7 = this.updateListeners.size();
        for (int i = 0; i < n7; ++i) {
            IIOReadUpdateListener iIOReadUpdateListener = this.updateListeners.get(i);
            iIOReadUpdateListener.thumbnailUpdate(this, bufferedImage, n, n2, n3, n4, n5, n6, nArray);
        }
    }

    protected void processThumbnailPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners == null) {
            return;
        }
        int n = this.updateListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadUpdateListener iIOReadUpdateListener = this.updateListeners.get(i);
            iIOReadUpdateListener.thumbnailPassComplete(this, bufferedImage);
        }
    }

    protected void processWarningOccurred(String string) {
        if (this.warningListeners == null) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("warning == null!");
        }
        int n = this.warningListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadWarningListener iIOReadWarningListener = this.warningListeners.get(i);
            iIOReadWarningListener.warningOccurred(this, string);
        }
    }

    protected void processWarningOccurred(String string, String string2) {
        if (this.warningListeners == null) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("baseName == null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyword == null!");
        }
        int n = this.warningListeners.size();
        for (int i = 0; i < n; ++i) {
            IIOReadWarningListener iIOReadWarningListener = this.warningListeners.get(i);
            Locale locale = this.warningLocales.get(i);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException2) {
                    throw new IllegalArgumentException("Bundle not found!");
                }
            }
            String string3 = null;
            try {
                string3 = resourceBundle.getString(string2);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Resource is not a String!");
            }
            catch (MissingResourceException missingResourceException) {
                throw new IllegalArgumentException("Resource is missing!");
            }
            iIOReadWarningListener.warningOccurred(this, string3);
        }
    }

    public void reset() {
        this.setInput(null, false, false);
        this.setLocale(null);
        this.removeAllIIOReadUpdateListeners();
        this.removeAllIIOReadProgressListeners();
        this.removeAllIIOReadWarningListeners();
        this.clearAbortRequest();
    }

    public void dispose() {
    }

    protected static Rectangle getSourceRegion(ImageReadParam imageReadParam, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        if (imageReadParam != null) {
            Rectangle rectangle2 = imageReadParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n3 = imageReadParam.getSubsamplingXOffset();
            int n4 = imageReadParam.getSubsamplingYOffset();
            rectangle.x += n3;
            rectangle.y += n4;
            rectangle.width -= n3;
            rectangle.height -= n4;
        }
        return rectangle;
    }

    protected static void computeRegions(ImageReadParam imageReadParam, int n, int n2, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            throw new IllegalArgumentException("srcRegion == null!");
        }
        if (rectangle2 == null) {
            throw new IllegalArgumentException("destRegion == null!");
        }
        rectangle.setBounds(0, 0, n, n2);
        rectangle2.setBounds(0, 0, n, n2);
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        if (imageReadParam != null) {
            Rectangle rectangle3 = imageReadParam.getSourceRegion();
            if (rectangle3 != null) {
                rectangle.setBounds(rectangle.intersection(rectangle3));
            }
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            n5 = imageReadParam.getSubsamplingXOffset();
            n6 = imageReadParam.getSubsamplingYOffset();
            rectangle.translate(n5, n6);
            rectangle.width -= n5;
            rectangle.height -= n6;
            rectangle2.setLocation(imageReadParam.getDestinationOffset());
        }
        if (rectangle2.x < 0) {
            int n7 = -rectangle2.x * n3;
            rectangle.x += n7;
            rectangle.width -= n7;
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            int n8 = -rectangle2.y * n4;
            rectangle.y += n8;
            rectangle.height -= n8;
            rectangle2.y = 0;
        }
        int n9 = (rectangle.width + n3 - 1) / n3;
        int n10 = (rectangle.height + n4 - 1) / n4;
        rectangle2.width = n9;
        rectangle2.height = n10;
        if (bufferedImage != null) {
            int n11;
            Rectangle rectangle4 = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            rectangle2.setBounds(rectangle2.intersection(rectangle4));
            if (rectangle2.isEmpty()) {
                throw new IllegalArgumentException("Empty destination region!");
            }
            int n12 = rectangle2.x + n9 - bufferedImage.getWidth();
            if (n12 > 0) {
                rectangle.width -= n12 * n3;
            }
            if ((n11 = rectangle2.y + n10 - bufferedImage.getHeight()) > 0) {
                rectangle.height -= n11 * n4;
            }
        }
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            throw new IllegalArgumentException("Empty region!");
        }
    }

    protected static void checkReadParamBandSettings(ImageReadParam imageReadParam, int n, int n2) {
        int n3;
        int n4;
        int[] nArray = null;
        int[] nArray2 = null;
        if (imageReadParam != null) {
            nArray = imageReadParam.getSourceBands();
            nArray2 = imageReadParam.getDestinationBands();
        }
        int n5 = nArray == null ? n : nArray.length;
        int n6 = n4 = nArray2 == null ? n2 : nArray2.length;
        if (n5 != n4) {
            throw new IllegalArgumentException("ImageReadParam num source & dest bands differ!");
        }
        if (nArray != null) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] < n) continue;
                throw new IllegalArgumentException("ImageReadParam source bands contains a value >= the number of source bands!");
            }
        }
        if (nArray2 != null) {
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                if (nArray2[n3] < n2) continue;
                throw new IllegalArgumentException("ImageReadParam dest bands contains a value >= the number of dest bands!");
            }
        }
    }

    protected static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator<ImageTypeSpecifier> iterator, int n, int n2) throws IIOException {
        Object object;
        Object object2;
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        if ((long)n * (long)n2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height > Integer.MAX_VALUE!");
        }
        BufferedImage bufferedImage = null;
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null) {
            bufferedImage = imageReadParam.getDestination();
            if (bufferedImage != null) {
                return bufferedImage;
            }
            imageTypeSpecifier = imageReadParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            object2 = iterator.next();
            if (!(object2 instanceof ImageTypeSpecifier)) {
                throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
            }
            imageTypeSpecifier = object2;
        } else {
            boolean bl = false;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!((ImageTypeSpecifier)object).equals(imageTypeSpecifier)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        object2 = new Rectangle(0, 0, 0, 0);
        object = new Rectangle(0, 0, 0, 0);
        ImageReader.computeRegions(imageReadParam, n, n2, null, (Rectangle)object2, (Rectangle)object);
        int n3 = ((Rectangle)object).x + ((Rectangle)object).width;
        int n4 = ((Rectangle)object).y + ((Rectangle)object).height;
        return imageTypeSpecifier.createBufferedImage(n3, n4);
    }
}

