/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class EnumControl
extends Control {
    private Object[] values;
    private Object value;

    protected EnumControl(Type type, Object[] objectArray, Object object) {
        super(type);
        this.values = objectArray;
        this.value = object;
    }

    public void setValue(Object object) {
        if (!this.isValueSupported(object)) {
            throw new IllegalArgumentException("Requested value " + object + " is not supported.");
        }
        this.value = object;
    }

    public Object getValue() {
        return this.value;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            objectArray[i] = this.values[i];
        }
        return objectArray;
    }

    private boolean isValueSupported(Object object) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!object.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this.getType() + " with current value: " + this.getValue());
    }

    public static class Type
    extends Control.Type {
        public static final Type REVERB = new Type("Reverb");

        protected Type(String string) {
            super(string);
        }
    }
}

