/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;

class LazyActionMap
extends ActionMapUIResource {
    private transient Object _loader;

    static void installLazyActionMap(JComponent jComponent, Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        SwingUtilities.replaceUIActionMap(jComponent, actionMap);
    }

    static ActionMap getActionMap(Class clazz, String string) {
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null) {
            actionMap = new LazyActionMap(clazz);
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        return actionMap;
    }

    private LazyActionMap(Class clazz) {
        this._loader = clazz;
    }

    public void put(Action action) {
        this.put(action.getValue("Name"), action);
    }

    public void put(Object object, Action action) {
        this.loadIfNecessary();
        super.put(object, action);
    }

    public Action get(Object object) {
        this.loadIfNecessary();
        return super.get(object);
    }

    public void remove(Object object) {
        this.loadIfNecessary();
        super.remove(object);
    }

    public void clear() {
        this.loadIfNecessary();
        super.clear();
    }

    public Object[] keys() {
        this.loadIfNecessary();
        return super.keys();
    }

    public int size() {
        this.loadIfNecessary();
        return super.size();
    }

    public Object[] allKeys() {
        this.loadIfNecessary();
        return super.allKeys();
    }

    public void setParent(ActionMap actionMap) {
        this.loadIfNecessary();
        super.setParent(actionMap);
    }

    private void loadIfNecessary() {
        block9: {
            if (this._loader != null) {
                Object object = this._loader;
                this._loader = null;
                Class clazz = (Class)object;
                try {
                    Method method = clazz.getDeclaredMethod("loadActionMap", LazyActionMap.class);
                    method.invoke(clazz, this);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    assert (false) : "LazyActionMap unable to load actions " + clazz;
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false) : "LazyActionMap unable to load actions " + illegalAccessException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    assert (false) : "LazyActionMap unable to load actions " + invocationTargetException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)("LazyActionMap unable to load actions " + illegalArgumentException));
                }
            }
        }
    }
}

