/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class SSLContextRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private SSLContext context;

    public SSLContextRMIServerSocketFactory(SSLContext sSLContext) {
        this(sSLContext, null, null, false);
    }

    public SSLContextRMIServerSocketFactory(SSLContext sSLContext, String[] stringArray, String[] stringArray2, boolean bl) throws IllegalArgumentException {
        super(stringArray, stringArray2, bl);
        this.context = sSLContext;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (this.context == null) {
            return super.createServerSocket(n);
        }
        final SSLSocketFactory sSLSocketFactory = this.context.getSocketFactory();
        return new ServerSocket(n){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sSLSocket.setUseClientMode(false);
                if (SSLContextRMIServerSocketFactory.this.getEnabledCipherSuites() != null) {
                    sSLSocket.setEnabledCipherSuites(SSLContextRMIServerSocketFactory.this.getEnabledCipherSuites());
                }
                if (SSLContextRMIServerSocketFactory.this.getEnabledProtocols() != null) {
                    sSLSocket.setEnabledProtocols(SSLContextRMIServerSocketFactory.this.getEnabledProtocols());
                }
                sSLSocket.setNeedClientAuth(SSLContextRMIServerSocketFactory.this.getNeedClientAuth());
                return sSLSocket;
            }
        };
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SSLContextRMIServerSocketFactory sSLContextRMIServerSocketFactory = (SSLContextRMIServerSocketFactory)object;
        return this.context == null ? sSLContextRMIServerSocketFactory.context == null : this.context.equals(sSLContextRMIServerSocketFactory.context);
    }

    public int hashCode() {
        return super.hashCode() + (this.context == null ? 0 : this.context.hashCode());
    }
}

