/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.repository;

import java.lang.reflect.Type;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.tree.MethodTypeSignature;
import sun.reflect.generics.tree.TypeSignature;
import sun.reflect.generics.visitor.Reifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorRepository
extends GenericDeclRepository<MethodTypeSignature> {
    private Type[] paramTypes;
    private Type[] exceptionTypes;

    protected ConstructorRepository(String string, GenericsFactory genericsFactory) {
        super(string, genericsFactory);
    }

    @Override
    protected MethodTypeSignature parse(String string) {
        return SignatureParser.make().parseMethodSig(string);
    }

    public static ConstructorRepository make(String string, GenericsFactory genericsFactory) {
        return new ConstructorRepository(string, genericsFactory);
    }

    public Type[] getParameterTypes() {
        if (this.paramTypes == null) {
            TypeSignature[] typeSignatureArray = ((MethodTypeSignature)this.getTree()).getParameterTypes();
            Type[] typeArray = new Type[typeSignatureArray.length];
            for (int i = 0; i < typeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                typeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.paramTypes = typeArray;
        }
        return (Type[])this.paramTypes.clone();
    }

    public Type[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = ((MethodTypeSignature)this.getTree()).getExceptionTypes();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i = 0; i < fieldTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.exceptionTypes = typeArray;
        }
        return (Type[])this.exceptionTypes.clone();
    }
}

