/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String[] split(String string, char c) {
        if (string == null) {
            throw new NullPointerException("str can't be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c));
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final String formatForPrint(String string) {
        if (string.length() > 60) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 60));
            stringBuffer.append("&");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String[] toStringArray(Object[] objectArray) {
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public static byte[] getAsciiBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)(cArray[i] & 0x7F);
        }
        return byArray;
    }

    public static String trimTrailing(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return string.substring(0, n);
    }

    public static String truncate(String string, int n) {
        if (string != null && string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String slice(String string, int n, int n2, boolean bl) {
        String string2 = string.substring(n, n2 + 1);
        if (bl) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = (byArray[i] & 0xF0) >>> 4;
            int n5 = byArray[i] & 0xF;
            stringBuffer.append(hex_table[n4]);
            stringBuffer.append(hex_table[n5]);
        }
        return stringBuffer.toString();
    }

    public static byte[] toHexByte(String string, int n, int n2) {
        byte[] byArray = new byte[(n2 - n) * 2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            int n4 = (c & 0xF0) >>> 4;
            int n5 = c & 0xF;
            byArray[i] = (byte)n4;
            byArray[i + 1] = (byte)n5;
        }
        return byArray;
    }

    public static byte[] fromHexString(String string, int n, int n2) {
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; i += 2) {
            int n5 = Character.digit(string.charAt(i), 16);
            int n6 = Character.digit(string.charAt(i + 1), 16);
            if (n5 == -1 || n6 == -1) {
                return null;
            }
            byArray[n3++] = (byte)(n5 << 4 & 0xF0 | n6 & 0xF);
        }
        return byArray;
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        for (int i = 0; i < byArray.length; i += 16) {
            char c;
            int n;
            String string = Integer.toHexString(i);
            for (n = string.length(); n < 8; ++n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            for (n = 0; n < 16 && i + n < byArray.length; ++n) {
                byte by = byArray[i + n];
                if (n % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c = (char)((by & 0xF0) >>> 4);
                byte by2 = (byte)(by & 0xF);
                stringBuffer.append(hex_table[c]);
                stringBuffer.append(hex_table[by2]);
            }
            stringBuffer.append("  ");
            for (n = 0; n < 16 && i + n < byArray.length; ++n) {
                c = (char)byArray[i + n];
                if (Character.isLetterOrDigit(c)) {
                    stringBuffer.append(String.valueOf(c));
                    continue;
                }
                stringBuffer.append(".");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String SQLToUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(string).equals(StringUtil.SQLToUpperCase(string2));
    }

    public static String normalizeSQLIdentifier(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.length() >= 3 && string.charAt(string.length() - 1) == '\"') {
            return StringUtil.compressQuotes(string.substring(1, string.length() - 1), "\"\"");
        }
        return StringUtil.SQLToUpperCase(string);
    }

    public static String compressQuotes(String string, String string2) {
        String string3 = string;
        int n = string3.indexOf(string2);
        while (n != -1) {
            string3 = string3.substring(0, n + 1) + string3.substring(n + 2);
            n = string3.indexOf(string2, n + 1);
        }
        return string3;
    }

    static String quoteString(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append(c);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public static String quoteStringLiteral(String string) {
        return StringUtil.quoteString(string, '\'');
    }

    public static String stringify(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        stringBuffer.append("[ ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

