/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.coredump.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.coredump.impl.OverviewViewSupport;
import com.sun.tools.visualvm.tools.sa.SaModel;
import com.sun.tools.visualvm.tools.sa.SaModelFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class CoreDumpOverviewView
extends DataSourceView {
    private static final String IMAGE_PATH = "com/sun/tools/visualvm/coredump/resources/overview.png";

    public CoreDumpOverviewView(CoreDump coreDump) {
        super((DataSource)coreDump, NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Overview"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 0, false);
    }

    protected DataViewComponent createComponent() {
        CoreDump coreDump = (CoreDump)this.getDataSource();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(coreDump).getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        SaModel saAgent = SaModelFactory.getSAAgentFor((DataSource)coreDump);
        Properties jvmProperties = saAgent.getSystemProperties();
        String jvmargs = saAgent.getJvmArgs();
        dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(0.25, 0.0, -1.0, -1.0, -1.0, -1.0));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Saved_data"), true), 1);
        dvc.addDetailsView(new OverviewViewSupport.SnapshotsViewSupport((DataSource)coreDump).getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Details"), true), 2);
        dvc.addDetailsView(new OverviewViewSupport.JVMArgumentsViewSupport(jvmargs).getDetailsView(), 2);
        dvc.addDetailsView(new OverviewViewSupport.SystemPropertiesViewSupport(jvmProperties).getDetailsView(), 2);
        return dvc;
    }

    private static class MasterViewSupport
    extends JPanel {
        public MasterViewSupport(CoreDump coreDump) {
            this.initComponents(coreDump);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(CoreDump coreDump) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralProperties(coreDump) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)area, "Center");
        }

        private String getGeneralProperties(CoreDump coreDump) {
            SaModel saAgent = SaModelFactory.getSAAgentFor((DataSource)coreDump);
            StringBuilder data = new StringBuilder();
            String commandLine = saAgent.getJavaCommand();
            if (commandLine != null) {
                String mainClass;
                int firstSpace = commandLine.indexOf(32);
                String mainArgs = null;
                if (firstSpace == -1) {
                    mainClass = commandLine;
                } else {
                    mainClass = commandLine.substring(0, firstSpace);
                    mainArgs = commandLine.substring(firstSpace + 1);
                }
                String mainClassLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Main_class");
                String argsLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Arguments");
                data.append("<b>" + mainClassLbl + ":</b> " + mainClass + "<br>");
                data.append("<b>" + argsLbl + ":</b> " + (mainArgs == null ? NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_none") : mainArgs) + "<br>");
            }
            String jvmFlags = saAgent.getJvmFlags();
            String jvmLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_JVM");
            String jhLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_Java_Home");
            String flagsLbl = NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_JVM_Flags");
            data.append("<br>");
            data.append("<b>" + jvmLbl + ":</b> " + saAgent.getVmName() + " (" + saAgent.getVmVersion() + ", " + saAgent.getVmInfo() + ")<br>");
            data.append("<b>" + jhLbl + ":</b> " + saAgent.getJavaHome() + "<br>");
            data.append("<b>" + flagsLbl + ":</b> " + (jvmFlags == null || jvmFlags.length() == 0 ? NbBundle.getMessage(CoreDumpOverviewView.class, (String)"LBL_none") : jvmFlags) + "<br><br>");
            return data.toString();
        }
    }
}

