/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.coredump.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.NotSupportedDisplayer;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.util.NbBundle;

public final class OverviewViewSupport {

    static class SystemPropertiesViewSupport
    extends JPanel {
        public SystemPropertiesViewSupport(Properties properties) {
            this.initComponents(properties);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_System_properties"), null, 20, (JComponent)this, null);
        }

        private void initComponents(Properties properties) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (properties != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + this.formatSystemProperties(properties) + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }

        private String formatSystemProperties(Properties properties) {
            StringBuffer text = new StringBuffer(200);
            ArrayList keys = new ArrayList();
            Enumeration<?> en = properties.propertyNames();
            while (en.hasMoreElements()) {
                keys.add(en.nextElement());
            }
            Collections.sort(keys);
            for (String key : keys) {
                String val = properties.getProperty(key);
                if ("line.separator".equals(key) && val != null) {
                    val = val.replace("\n", "\\n");
                    val = val.replace("\r", "\\r");
                }
                text.append("<b>");
                text.append(key);
                text.append("</b>=");
                text.append(val);
                text.append("<br>");
            }
            return text.toString();
        }
    }

    static class JVMArgumentsViewSupport
    extends JPanel {
        public JVMArgumentsViewSupport(String jvmargs) {
            this.initComponents(jvmargs);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_arguments"), null, 10, (JComponent)this, null);
        }

        private void initComponents(String jvmargs) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (jvmargs != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + this.formatJVMArgs(jvmargs) + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }

        private String formatJVMArgs(String jvmargs) {
            String mangledString = " ".concat(jvmargs).replace(" -", "\n");
            StringTokenizer tok = new StringTokenizer(mangledString, "\n");
            StringBuffer text = new StringBuffer(100);
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken().replace(" ", "&nbsp;");
                int equalsSign = arg.indexOf(61);
                text.append("<b>");
                text.append("-");
                if (equalsSign != -1) {
                    text.append(arg.substring(0, equalsSign));
                    text.append("</b>");
                    text.append(arg.substring(equalsSign));
                } else {
                    text.append(arg);
                    text.append("</b>");
                }
                text.append("<br>");
            }
            return text.toString();
        }
    }

    static class SnapshotsViewSupport
    extends JPanel {
        public SnapshotsViewSupport(DataSource ds) {
            this.initComponents(ds);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Saved_data"), null, 10, (JComponent)this, null);
        }

        private void initComponents(final DataSource ds) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            final HTMLTextArea area = new HTMLTextArea();
            area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            ds.getRepository().addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    area.setText("<nobr>" + SnapshotsViewSupport.this.getSavedData(ds) + "</nobr>");
                }
            }, Snapshot.class);
            this.add((Component)new ScrollableContainer((JComponent)area), "Center");
        }

        private String getSavedData(DataSource ds) {
            StringBuilder data = new StringBuilder();
            List snapshotCategories = RegisteredSnapshotCategories.sharedInstance().getVisibleCategories();
            for (SnapshotCategory category : snapshotCategories) {
                data.append("<b>" + category.getName() + ":</b> " + ds.getRepository().getDataSources(category.getType()).size() + "<br>");
            }
            return data.toString();
        }
    }
}

