/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.ValidationWarningPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private OperationPanel panel;
    private PanelBodyContainer component;
    private InstallUnitWizardModel model = null;
    private boolean clearLazyUnits = false;
    private WizardDescriptor wd = null;
    private OperationSupport.Restarter restarter = null;
    private ProgressHandle systemHandle = null;
    private ProgressHandle spareHandle = null;
    private boolean spareHandleStarted = false;
    private boolean indeterminateProgress = false;
    private int processedUnits = 0;
    private int totalUnits = 0;
    private static Notification restartNotification = null;
    private static final Logger log = Logger.getLogger(InstallStep.class.getName());
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String TEXT_PROPERTY = "text";
    private static final String HEAD_DOWNLOAD = "InstallStep_Header_Download_Head";
    private static final String CONTENT_DOWNLOAD = "InstallStep_Header_Download_Content";
    private static final String HEAD_VERIFY = "InstallStep_Header_Verify_Head";
    private static final String CONTENT_VERIFY = "InstallStep_Header_Verify_Content";
    private static final String HEAD_INSTALL = "InstallStep_Header_Install_Head";
    private static final String CONTENT_INSTALL = "InstallStep_Header_Install_Content";
    private static final String HEAD_INSTALL_DONE = "InstallStep_Header_InstallDone_Head";
    private static final String CONTENT_INSTALL_DONE = "InstallStep_Header_InstallDone_Content";
    private static final String HEAD_INSTALL_UNSUCCESSFUL = "InstallStep_Header_InstallUnsuccessful_Head";
    private static final String CONTENT_INSTALL_UNSUCCESSFUL = "InstallStep_Header_InstallUnsuccessful_Content";
    private static final String HEAD_RESTART = "InstallStep_Header_Restart_Head";
    private static final String CONTENT_RESTART = "InstallStep_Header_Restart_Content";
    private boolean wasStored = false;
    private boolean runInBg = false;
    private OperationException installException;
    private InstallSupport.Validator validator;

    public InstallStep(InstallUnitWizardModel installUnitWizardModel) {
        this(installUnitWizardModel, false);
    }

    public InstallStep(InstallUnitWizardModel installUnitWizardModel, boolean bl) {
        this.model = installUnitWizardModel;
        this.clearLazyUnits = bl;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(true);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("run-action".equals(propertyChangeEvent.getPropertyName())) {
                        RequestProcessor.Task task = InstallStep.this.createInstallTask();
                        PluginManagerUI.registerRunningTask(task);
                        task.waitFinished();
                        PluginManagerUI.unregisterRunningTask();
                    } else if ("run-in-background".equals(propertyChangeEvent.getPropertyName())) {
                        InstallStep.this.setRunInBackground(true);
                    }
                }
            });
            this.component = new PanelBodyContainer(InstallStep.getBundle(HEAD_DOWNLOAD, new Object[0]), InstallStep.getBundle(CONTENT_DOWNLOAD, new Object[0]), this.panel);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private RequestProcessor.Task createInstallTask() {
        return RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                InstallStep.this.doDownloadAndVerificationAndInstall();
            }
        });
    }

    private void doDownloadAndVerificationAndInstall() {
        InstallSupport.Validator validator = null;
        validator = this.handleDownload();
        if (validator != null) {
            InstallSupport.Installer installer = null;
            installer = this.handleValidation(validator);
            if (installer != null) {
                OperationSupport.Restarter restarter = null;
                restarter = this.handleInstall(installer);
                if (restarter != null) {
                    this.presentInstallNeedsRestart(restarter);
                } else {
                    this.presentInstallDone();
                }
            }
        }
        this.fireChange();
    }

    private InstallSupport.Validator handleDownload() {
        this.validator = null;
        OperationContainer operationContainer = this.model.getBaseContainer();
        InstallSupport installSupport = this.model.getInstallSupport();
        assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + operationContainer.listAll() + " and invalid elements " + operationContainer.listInvalid();
        boolean bl = false;
        while (!bl) {
            bl = this.tryPerformDownload();
        }
        return this.validator;
    }

    private boolean runInBackground() {
        return this.runInBg;
    }

    private void setRunInBackground(boolean bl) {
        if (bl == this.runInBg) {
            return;
        }
        this.runInBg = bl;
        if (bl) {
            assert (SwingUtilities.isEventDispatchThread()) : "In AWT queue only.";
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (window != null) {
                window.setVisible(false);
            }
            if (this.model.getPluginManager() != null) {
                this.model.getPluginManager().close();
            }
            if (this.spareHandle != null && !this.spareHandleStarted) {
                this.indeterminateProgress = true;
                this.spareHandle.start();
                this.spareHandleStarted = true;
            }
        } else assert (false) : "Cannot set runInBackground to false";
    }

    private boolean handleCancel() {
        if (this.spareHandle != null && this.spareHandleStarted) {
            this.spareHandle.finish();
            this.spareHandleStarted = false;
        }
        if (this.systemHandle != null) {
            this.systemHandle.finish();
        }
        try {
            this.model.doCleanup(true);
        }
        catch (OperationException operationException) {
            Logger.getLogger(InstallStep.class.getName()).log(Level.INFO, operationException.getMessage(), operationException);
        }
        return true;
    }

    private boolean tryPerformDownload() {
        this.validator = null;
        InstallSupport installSupport = this.model.getInstallSupport();
        JLabel jLabel = null;
        try {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]));
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            JLabel jLabel2 = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
            jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
            if (this.runInBackground()) {
                progressHandle = this.systemHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        return InstallStep.this.handleCancel();
                    }
                });
            } else {
                this.spareHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        return InstallStep.this.handleCancel();
                    }
                });
                this.totalUnits = this.model.getBaseContainer().listAll().size();
                this.processedUnits = 0;
                jLabel.addPropertyChangeListener(TEXT_PROPERTY, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        assert (InstallStep.TEXT_PROPERTY.equals(propertyChangeEvent.getPropertyName())) : "Listens onlo on text but was " + propertyChangeEvent;
                        if (propertyChangeEvent.getOldValue() != propertyChangeEvent.getNewValue()) {
                            InstallStep.this.processedUnits++;
                            if (InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted && InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1) {
                                InstallStep.this.totalUnits = InstallStep.this.totalUnits - InstallStep.this.processedUnits;
                                InstallStep.this.spareHandle.switchToDeterminate(InstallStep.this.totalUnits);
                                InstallStep.this.indeterminateProgress = false;
                            }
                            if (!InstallStep.this.indeterminateProgress) {
                                InstallStep.this.spareHandle.progress(((JLabel)propertyChangeEvent.getSource()).getText(), InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1 ? InstallStep.this.processedUnits : InstallStep.this.totalUnits - 1);
                            }
                        }
                    }
                });
            }
            progressHandle.setInitialDelay(0);
            this.panel.waitAndSetProgressComponents(jLabel2, jComponent, jLabel);
            this.validator = installSupport.doDownload(progressHandle, Utilities.isGlobalInstallation());
            if (this.validator == null) {
                return true;
            }
            if (this.validator == null) {
                return true;
            }
            this.panel.waitAndSetProgressComponents(jLabel2, jComponent, new JLabel(InstallStep.getBundle("InstallStep_Done", new Object[0])));
            if (this.spareHandle != null && this.spareHandleStarted) {
                this.spareHandle.finish();
                this.spareHandleStarted = false;
            }
        }
        catch (OperationException operationException) {
            log.log(Level.INFO, operationException.getMessage(), operationException);
            if (OperationException.ERROR_TYPE.PROXY == operationException.getErrorType()) {
                if (this.runInBackground()) {
                    this.handleCancel();
                    this.notifyNetworkProblem(operationException);
                } else {
                    JButton jButton = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)jButton, (String)InstallStep.getBundle("InstallStep_NetworkProblem_Continue", new Object[0]));
                    NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(InstallStep.getBundle("InstallStep_NetworkProblem_Text", operationException.getLocalizedMessage()), jButton, this.model.getCancelButton(this.wd));
                    Object object = networkProblemPanel.showNetworkProblemDialog();
                    if (jButton.equals(object)) {
                        return false;
                    }
                    if (DialogDescriptor.CLOSED_OPTION.equals(object)) {
                        this.model.getCancelButton(this.wd).doClick();
                    }
                }
            }
            String string = jLabel == null || jLabel.getText().length() == 0 ? InstallStep.getBundle("InstallStep_DownloadProblem_SomePlugins", new Object[0]) : jLabel.getText();
            String string2 = InstallStep.getBundle("InstallStep_DownloadProblem", string, operationException.getLocalizedMessage());
            Exceptions.attachLocalizedMessage((Throwable)operationException, (String)string2);
            log.log(Level.SEVERE, null, operationException);
            this.handleCancel();
        }
        return true;
    }

    private InstallSupport.Installer handleValidation(InstallSupport.Validator validator) {
        this.component.setHeadAndContent(InstallStep.getBundle(HEAD_VERIFY, new Object[0]), InstallStep.getBundle(CONTENT_VERIFY, new Object[0]));
        InstallSupport installSupport = this.model.getInstallSupport();
        assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        if (this.runInBackground()) {
            progressHandle = this.systemHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    InstallStep.this.handleCancel();
                    return true;
                }
            });
        } else {
            this.spareHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    InstallStep.this.handleCancel();
                    return true;
                }
            });
            this.totalUnits = this.model.getBaseContainer().listAll().size();
            this.processedUnits = 0;
            if (this.indeterminateProgress) {
                jLabel2.addPropertyChangeListener(TEXT_PROPERTY, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        assert (InstallStep.TEXT_PROPERTY.equals(propertyChangeEvent.getPropertyName())) : "Listens onlo on text but was " + propertyChangeEvent;
                        if (propertyChangeEvent.getOldValue() != propertyChangeEvent.getNewValue()) {
                            InstallStep.this.processedUnits++;
                            if (InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted && InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1) {
                                InstallStep.this.totalUnits = InstallStep.this.totalUnits - InstallStep.this.processedUnits;
                                InstallStep.this.spareHandle.switchToDeterminate(InstallStep.this.totalUnits);
                                InstallStep.this.indeterminateProgress = false;
                            }
                            if (!InstallStep.this.indeterminateProgress) {
                                InstallStep.this.spareHandle.progress(((JLabel)propertyChangeEvent.getSource()).getText(), InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1 ? InstallStep.this.processedUnits : InstallStep.this.totalUnits - 1);
                            }
                        }
                    }
                });
            }
        }
        progressHandle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
        if (this.spareHandle != null && this.spareHandleStarted) {
            this.spareHandle.finish();
        }
        InstallSupport.Installer installer = null;
        try {
            installer = installSupport.doValidate(validator, progressHandle);
            if (installer == null) {
                return null;
            }
            if (installer == null) {
                return null;
            }
        }
        catch (OperationException operationException) {
            log.log(Level.INFO, operationException.getMessage(), operationException);
            NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(operationException.getLocalizedMessage());
            networkProblemPanel.showNetworkProblemDialog();
            this.handleCancel();
            return null;
        }
        InstallSupport.Installer installer2 = installer;
        ArrayList<UpdateElement> arrayList = new ArrayList<UpdateElement>();
        ArrayList<UpdateElement> arrayList2 = new ArrayList<UpdateElement>();
        String string = "";
        for (UpdateElement object : this.model.getAllUpdateElements()) {
            if (!installSupport.isSigned(installer2, object)) {
                arrayList.add(object);
                continue;
            }
            if (installSupport.isTrusted(installer2, object)) continue;
            arrayList2.add(object);
            String bl = installSupport.getCertificate(installer2, object);
            if (bl == null || bl.length() <= 0) continue;
            string = string + InstallStep.getBundle("ValidationWarningPanel_ShowCertificateFormat", object.getDisplayName(), bl);
        }
        if (arrayList2.size() > 0 || arrayList.size() > 0 && !this.runInBackground()) {
            ValidationWarningPanel validationWarningPanel = new ValidationWarningPanel(arrayList, arrayList2);
            final JButton jButton = new JButton();
            boolean bl = !arrayList2.isEmpty() && string.length() > 0;
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)InstallStep.getBundle("ValidationWarningPanel_ShowCertificateButton", new Object[0]));
            final String string2 = string;
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jButton.equals(actionEvent.getSource())) {
                        JTextArea jTextArea = new JTextArea(string2);
                        jTextArea.setEditable(false);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)jTextArea));
                    }
                }
            });
            JButton jButton2 = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)InstallStep.getBundle("ValidationWarningPanel_ContinueButton", new Object[0]));
            JButton jButton3 = this.model.getCancelButton(this.wd);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)validationWarningPanel, bl ? InstallStep.getBundle("ValidationWarningPanel_VerifyCertificate_Title", new Object[0]) : InstallStep.getBundle("ValidationWarningPanel_Title", new Object[0]));
            dialogDescriptor.setOptions((Object[])new JButton[]{jButton2, jButton3});
            dialogDescriptor.setClosingOptions((Object[])new JButton[]{jButton2, jButton3});
            dialogDescriptor.setMessageType(2);
            if (bl) {
                dialogDescriptor.setAdditionalOptions((Object[])new JButton[]{jButton});
            }
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        dialog.setVisible(true);
                    }
                });
            }
            catch (InterruptedException invocationTargetException) {
                log.log(Level.INFO, invocationTargetException.getLocalizedMessage(), invocationTargetException);
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                log.log(Level.INFO, invocationTargetException.getLocalizedMessage(), invocationTargetException);
                return null;
            }
            if (!jButton2.equals(dialogDescriptor.getValue())) {
                if (!jButton3.equals(dialogDescriptor.getValue())) {
                    jButton3.doClick();
                }
                return null;
            }
            assert (jButton2.equals(dialogDescriptor.getValue()));
        }
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(InstallStep.getBundle("InstallStep_Done", new Object[0])));
        return installer2;
    }

    private OperationSupport.Restarter handleInstall(InstallSupport.Installer installer) {
        this.installException = null;
        this.component.setHeadAndContent(InstallStep.getBundle(HEAD_INSTALL, new Object[0]), InstallStep.getBundle(CONTENT_INSTALL, new Object[0]));
        InstallSupport installSupport = this.model.getInstallSupport();
        assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        this.model.modifyOptionsForDisabledCancel(this.wd);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        if (this.runInBackground()) {
            progressHandle = this.systemHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
        } else {
            this.spareHandle = ProgressHandleFactory.createHandle((String)InstallStep.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
            this.totalUnits = this.model.getBaseContainer().listAll().size();
            this.processedUnits = 0;
            if (this.indeterminateProgress) {
                jLabel2.addPropertyChangeListener(TEXT_PROPERTY, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        assert (InstallStep.TEXT_PROPERTY.equals(propertyChangeEvent.getPropertyName())) : "Listens onlo on text but was " + propertyChangeEvent;
                        if (propertyChangeEvent.getOldValue() != propertyChangeEvent.getNewValue()) {
                            InstallStep.this.processedUnits++;
                            if (InstallStep.this.indeterminateProgress && InstallStep.this.spareHandleStarted && InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1) {
                                InstallStep.this.totalUnits = InstallStep.this.totalUnits - InstallStep.this.processedUnits;
                                InstallStep.this.spareHandle.switchToDeterminate(InstallStep.this.totalUnits);
                                InstallStep.this.indeterminateProgress = false;
                            }
                            if (!InstallStep.this.indeterminateProgress) {
                                InstallStep.this.spareHandle.progress(((JLabel)propertyChangeEvent.getSource()).getText(), InstallStep.this.processedUnits < InstallStep.this.totalUnits - 1 ? InstallStep.this.processedUnits : InstallStep.this.totalUnits - 1);
                            }
                        }
                    }
                });
            }
        }
        progressHandle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
        OperationSupport.Restarter restarter = null;
        boolean bl = false;
        try {
            restarter = installSupport.doInstall(installer, progressHandle);
            bl = true;
        }
        catch (OperationException operationException) {
            log.log(Level.INFO, operationException.getMessage(), operationException);
            this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(InstallStep.getBundle("InstallStep_Unsuccessful", operationException.getLocalizedMessage())));
            this.installException = operationException;
        }
        if (bl) {
            this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(InstallStep.getBundle("InstallStep_Done", new Object[0])));
        }
        if (this.spareHandle != null && this.spareHandleStarted) {
            this.spareHandle.finish();
        }
        return restarter;
    }

    private void presentInstallDone() {
        this.model.modifyOptionsForDoClose(this.wd);
        if (this.installException == null) {
            this.component.setHeadAndContent(InstallStep.getBundle(HEAD_INSTALL_DONE, new Object[0]), InstallStep.getBundle(CONTENT_INSTALL_DONE, new Object[0]));
            this.panel.setBody(InstallStep.getBundle("InstallStep_InstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
        } else {
            this.component.setHeadAndContent(InstallStep.getBundle(HEAD_INSTALL_UNSUCCESSFUL, new Object[0]), InstallStep.getBundle(CONTENT_INSTALL_UNSUCCESSFUL, new Object[0]));
            this.panel.setBody(InstallStep.getBundle("InstallStep_InstallUnsuccessful_Text", this.installException.getLocalizedMessage()), this.model.getAllVisibleUpdateElements());
        }
        this.panel.hideRunInBackground();
    }

    private void presentInstallNeedsRestart(OperationSupport.Restarter restarter) {
        this.component.setHeadAndContent(InstallStep.getBundle(HEAD_RESTART, new Object[0]), InstallStep.getBundle(CONTENT_RESTART, new Object[0]));
        this.model.modifyOptionsForDoClose(this.wd, true);
        this.restarter = restarter;
        this.panel.setRestartButtonsVisible(true);
        this.panel.setBody(InstallStep.getBundle("InstallStep_InstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
        this.panel.hideRunInBackground();
        if (this.runInBackground()) {
            InstallSupport installSupport = this.model.getInstallSupport();
            InstallStep.resetLastCheckWhenUpdatingFirstClassModules(this.model.getAllUpdateElements());
            installSupport.doRestartLater(this.restarter);
            try {
                this.model.doCleanup(false);
            }
            catch (OperationException operationException) {
                log.log(Level.INFO, operationException.getMessage(), operationException);
            }
            if (this.clearLazyUnits) {
                LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.model.getOperation(), null);
                AutoupdateCheckScheduler.notifyAvailable(null, OperationWizardModel.OperationType.UPDATE);
            }
            InstallStep.notifyInstallRestartNeeded(installSupport, restarter);
        }
    }

    private static void notifyInstallRestartNeeded(final InstallSupport installSupport, final OperationSupport.Restarter restarter) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    installSupport.doRestart(restarter, null);
                }
                catch (OperationException operationException) {
                    log.log(Level.INFO, operationException.getMessage(), operationException);
                }
            }
        };
        InstallStep.notifyRestartNeeded(runnable, InstallStep.getBundle("InstallSupport_RestartNeeded", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyRestartNeeded(final Runnable runnable, String string) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        Class<InstallStep> clazz = InstallStep.class;
        synchronized (InstallStep.class) {
            if (restartNotification != null) {
                restartNotification.clear();
                restartNotification = null;
            }
            restartNotification = NotificationDisplayer.getDefault().notify(string, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/restart.png", (boolean)false), InstallStep.getBundle("RestartNeeded_Details", new Object[0]), actionListener, NotificationDisplayer.Priority.HIGH);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void notifyNetworkProblem(final OperationException operationException) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(operationException.getLocalizedMessage());
                networkProblemPanel.showNetworkProblemDialog();
            }
        };
        String string = InstallStep.getBundle("InstallSupport_InBackground_NetworkError", new Object[0]);
        String string2 = InstallStep.getBundle("InstallSupport_InBackground_NetworkError_Details", new Object[0]);
        NotificationDisplayer.getDefault().notify(string, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/error.png", (boolean)false), string2, actionListener, NotificationDisplayer.Priority.HIGH);
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
        this.wasStored = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wizardDescriptor.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wizardDescriptor.getValue())) {
            try {
                this.model.doCleanup(true);
                return;
            }
            catch (OperationException operationException) {
                Logger.getLogger(InstallStep.class.getName()).log(Level.INFO, operationException.getMessage(), operationException);
            }
            return;
        }
        if (this.restarter != null) {
            InstallSupport installSupport = this.model.getInstallSupport();
            assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
            if (this.panel.restartNow()) {
                InstallStep.resetLastCheckWhenUpdatingFirstClassModules(this.model.getAllUpdateElements());
                this.handleLazyUnits(this.clearLazyUnits, false);
                try {
                    installSupport.doRestart(this.restarter, null);
                    return;
                }
                catch (OperationException operationException) {
                    log.log(Level.INFO, operationException.getMessage(), operationException);
                }
                return;
            }
            InstallStep.resetLastCheckWhenUpdatingFirstClassModules(this.model.getAllUpdateElements());
            installSupport.doRestartLater(this.restarter);
            this.handleLazyUnits(this.clearLazyUnits, true);
            try {
                this.model.doCleanup(false);
            }
            catch (OperationException operationException) {
                log.log(Level.INFO, operationException.getMessage(), operationException);
            }
            InstallStep.notifyInstallRestartNeeded(installSupport, this.restarter);
            return;
        }
        try {
            this.model.doCleanup(!WizardDescriptor.FINISH_OPTION.equals(wizardDescriptor.getValue()));
            return;
        }
        catch (OperationException operationException) {
            log.log(Level.INFO, operationException.getMessage(), operationException);
        }
    }

    public boolean isValid() {
        return true;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void handleLazyUnits(boolean bl, boolean bl2) {
        if (bl) {
            LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.model.getOperation(), null);
            if (bl2) {
                AutoupdateCheckScheduler.notifyAvailable(null, OperationWizardModel.OperationType.UPDATE);
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (UpdateElement object : this.model.getAllUpdateElements()) {
                hashSet.add(LazyInstallUnitWizardIterator.LazyUnit.toString(object));
            }
            HashSet hashSet2 = new HashSet();
            for (LazyInstallUnitWizardIterator.LazyUnit lazyUnit : LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(this.model.getOperation())) {
                if (hashSet.contains(lazyUnit.toString())) continue;
                hashSet2.add(lazyUnit);
            }
            LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.model.getOperation(), hashSet2);
            if (bl2) {
                AutoupdateCheckScheduler.notifyAvailable(hashSet2, OperationWizardModel.OperationType.UPDATE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        InstallStep installStep = this;
        synchronized (installStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(InstallStep.class, (String)string, (Object[])objectArray);
    }

    private static void resetLastCheckWhenUpdatingFirstClassModules(Collection<UpdateElement> collection) {
        boolean bl = false;
        for (UpdateElement updateElement : collection) {
            if (!Utilities.getFirstClassModules().contains(updateElement.getCodeName())) continue;
            bl = true;
            break;
        }
        if (bl) {
            AutoupdateSettings.setLastCheck(null);
        }
    }
}

