/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.axis;

import java.util.Iterator;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.charts.axis.TimeMark;
import org.netbeans.lib.profiler.charts.swing.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineMarksComputer
extends AxisMarksComputer.Abstract {
    private final Timeline timeline;
    private double scale;
    private long step;
    private long firstTimestamp;
    private long lastTimestamp;

    public TimelineMarksComputer(Timeline timeline, ChartContext chartContext, int n) {
        super(chartContext, n);
        this.timeline = timeline;
        this.scale = -1.0;
        this.step = -1L;
    }

    @Override
    protected int getMinMarksDistance() {
        return 120;
    }

    @Override
    protected boolean refreshConfiguration() {
        double d = this.scale;
        long l = this.firstTimestamp;
        long l2 = this.lastTimestamp;
        this.scale = this.horizontal && this.context.getViewWidth() == 0L || !this.horizontal && this.context.getViewHeight() == 0L ? -1.0 : (this.horizontal ? this.context.getViewWidth(1.0) : this.context.getViewHeight(1.0));
        int n = this.timeline.getTimestampsCount();
        if (this.horizontal) {
            this.firstTimestamp = n == 0 ? (long)this.context.getDataX(0.0) : this.timeline.getTimestamp(0);
            this.lastTimestamp = n == 0 ? (long)this.context.getDataX(this.context.getViewportWidth()) : Math.max(this.timeline.getTimestamp(n - 1), (long)this.context.getDataX(this.context.getViewportWidth()));
        } else {
            this.firstTimestamp = n == 0 ? (long)this.context.getDataY(0.0) : this.timeline.getTimestamp(0);
            long l3 = this.lastTimestamp = n == 0 ? (long)this.context.getDataY(this.context.getViewportWidth()) : Math.max(this.timeline.getTimestamp(n - 1), (long)this.context.getDataY(this.context.getViewportWidth()));
        }
        if (d != this.scale) {
            this.step = this.scale == -1.0 ? -1L : TimeAxisUtils.getTimeUnits(this.scale, this.getMinMarksDistance());
            d = this.scale;
            return true;
        }
        return l != this.firstTimestamp || l2 != this.lastTimestamp;
    }

    @Override
    public Iterator<AxisMark> marksIterator(int n, int n2) {
        if (this.step == -1L) {
            return EMPTY_ITERATOR;
        }
        final long l = this.horizontal ? (long)this.context.getDataX(n) / this.step * this.step : (long)this.context.getDataY(n) / this.step * this.step;
        long l2 = this.horizontal ? (long)this.context.getDataX(n2) / this.step * this.step : (long)this.context.getDataY(n2) / this.step * this.step;
        final long l3 = Math.abs(l2 - l) / this.step + 2L;
        final long[] lArray = new long[]{0L};
        final String string = TimeAxisUtils.getFormatString(this.step, this.firstTimestamp, this.lastTimestamp);
        return new AxisMarksComputer.AbstractIterator(){

            public boolean hasNext() {
                return lArray[0] < l3;
            }

            public AxisMark next() {
                long l2 = TimelineMarksComputer.this.reverse ? l - lArray[0] * TimelineMarksComputer.this.step : l + lArray[0] * TimelineMarksComputer.this.step;
                lArray[0] = lArray[0] + 1L;
                int n = TimelineMarksComputer.this.horizontal ? Utils.checkedInt(TimelineMarksComputer.this.context.getViewX(l2)) : Utils.checkedInt(TimelineMarksComputer.this.context.getViewY(l2));
                return new TimeMark(l2, n, string);
            }
        };
    }
}

