/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class FileSelector
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    static final long serialVersionUID = 6524404012203099065L;
    private final ExplorerManager manager = new ExplorerManager();
    private BeanTreeView tree;
    private JButton okButton;
    private JButton cancelButton;
    private JButton[] buttons;
    private NodeAcceptor acceptor;

    public FileSelector(String string, Node node, NodeAcceptor nodeAcceptor, Component component) {
        this.acceptor = nodeAcceptor;
        ResourceBundle resourceBundle = NbBundle.getBundle(FileSelector.class);
        this.okButton = new JButton(resourceBundle.getString("CTL_FileSelectorOkButton"));
        this.cancelButton = new JButton(resourceBundle.getString("CTL_FileSelectorCancelButton"));
        this.okButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FileSelectorOkButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FileSelectorCancelButton"));
        this.buttons = new JButton[]{this.okButton, this.cancelButton};
        this.manager.setRootContext(node);
        this.tree = new BeanTreeView();
        this.tree.setPopupAllowed(false);
        this.tree.setDefaultActionAllowed(false);
        this.tree.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle(FileSelector.class).getString("ACSN_FileSelectorTreeView"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FileSelector.class).getString("ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FileSelector.class).getString("ACSD_FileSelectorDialog"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
        try {
            this.manager.setSelectedNodes(new Node[]{node});
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            jLabel.setLabelFor(this.tree.getViewport().getView());
            this.add((Component)jLabel, "North");
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalStateException(propertyVetoException.getMessage());
        }
        if (component != null) {
            this.add(component, "South");
        }
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        if (nodeAcceptor.acceptNodes(this.manager.getSelectedNodes())) {
            this.enableButton();
        } else {
            this.disableButton();
        }
    }

    Object[] getOptions() {
        return this.buttons;
    }

    Object getSelectOption() {
        return this.okButton;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            if (this.acceptor.acceptNodes(this.manager.getSelectedNodes())) {
                this.enableButton();
            } else {
                this.disableButton();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(dimension.height, Utilities.getUsableScreenBounds().height / 2);
        return dimension;
    }

    public Node[] getNodes() {
        return this.manager.getSelectedNodes();
    }

    void enableButton() {
        this.okButton.setEnabled(true);
    }

    void disableButton() {
        this.okButton.setEnabled(false);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

