/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.openide.util.ActionsBridge;
import org.openide.awt.AlwaysEnabledAction;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.awt.GlobalManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GeneralAction {
    static final Logger LOG = Logger.getLogger(GeneralAction.class.getName());

    private GeneralAction() {
    }

    public static ContextAwareAction callback(String string, Action action, Lookup lookup, boolean bl, boolean bl2) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new DelegateAction(null, string, lookup, action, bl, bl2);
    }

    public static Action alwaysEnabled(Map map) {
        return new AlwaysEnabledAction(map);
    }

    public static ContextAwareAction callback(Map map) {
        Action action = (Action)map.get("fallback");
        DelegateAction delegateAction = new DelegateAction(map, action);
        Parameters.notNull((CharSequence)"key", (Object)delegateAction.key);
        return delegateAction;
    }

    public static <T> ContextAwareAction context(ContextAction.Performer<? super T> performer, ContextSelection contextSelection, Lookup lookup, Class<T> clazz) {
        return new ContextAction<T>(performer, contextSelection, lookup, clazz, false);
    }

    public static ContextAwareAction context(Map map) {
        Class<?> clazz = GeneralAction.readClass(map.get("type"));
        return GeneralAction._context(map, clazz);
    }

    private static <T> ContextAwareAction _context(Map map, Class<T> clazz) {
        ContextSelection contextSelection = GeneralAction.readSelection(map.get("selectionType"));
        ContextAction.Performer performer = new ContextAction.Performer(map);
        boolean bl = Boolean.TRUE.equals(map.get("surviveFocusChange"));
        ContextAction contextAction = new ContextAction(performer, contextSelection, Utilities.actionsGlobalContext(), clazz, bl);
        return new DelegateAction(map, contextAction);
    }

    private static ContextSelection readSelection(Object object) {
        if (object instanceof ContextSelection) {
            return (ContextSelection)((Object)object);
        }
        if (object instanceof String) {
            return ContextSelection.valueOf((String)object);
        }
        throw new IllegalStateException("Cannot parse selectionType value: " + object);
    }

    private static Class<?> readClass(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String) {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = GeneralAction.class.getClassLoader();
            }
            try {
                return Class.forName((String)object, false, classLoader);
            }
            catch (Exception exception) {
                throw (IllegalStateException)new IllegalStateException(exception.getMessage()).initCause(exception);
            }
        }
        throw new IllegalStateException("Cannot parse selectionType value: " + object);
    }

    static final Object extractCommonAttribute(Map map, Action action, String string) {
        return AlwaysEnabledAction.extractCommonAttribute(map, string);
    }

    public Logger getLOG() {
        return LOG;
    }

    static final class DelegateAction
    implements Action,
    ContextAwareAction,
    PropertyChangeListener {
        private Map map;
        private Action fallback;
        private Object key;
        private final boolean async;
        private GlobalManager global;
        private PropertyChangeSupport support;
        private PropertyChangeListener weakL;
        private Map<String, Object> attrs;

        public DelegateAction(Map map, Object object, Lookup lookup, Action action, boolean bl, boolean bl2) {
            this.map = map;
            this.key = object;
            this.fallback = action;
            this.global = GlobalManager.findManager(lookup, bl);
            this.weakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action);
            this.async = bl2;
            if (action != null) {
                action.addPropertyChangeListener(this.weakL);
            }
        }

        public DelegateAction(Map map, Action action) {
            this(map, map.get("key"), Utilities.actionsGlobalContext(), action, Boolean.TRUE.equals(map.get("surviveFocusChange")), Boolean.TRUE.equals(map.get("asynchronous")));
        }

        public String toString() {
            return super.toString() + "[key=" + this.key + "]";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (EventQueue.isDispatchThread());
            Action action = this.findAction();
            if (action != null) {
                ActionsBridge.ActionRunnable actionRunnable = ActionsBridge.ActionRunnable.create((ActionEvent)actionEvent, (Action)action, (boolean)this.async);
                ActionsBridge.doPerformAction((Action)action, (ActionsBridge.ActionRunnable)actionRunnable);
            }
        }

        public boolean isEnabled() {
            assert (EventQueue.isDispatchThread());
            Action action = this.findAction();
            return action == null ? false : action.isEnabled();
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            boolean bl = false;
            if (this.support == null) {
                this.support = new PropertyChangeSupport(this);
                bl = true;
            }
            this.support.addPropertyChangeListener(propertyChangeListener);
            if (bl) {
                this.global.registerListener(this.key, this);
            }
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
            if (!this.support.hasListeners(null)) {
                this.global.unregisterListener(this.key, this);
                this.support = null;
            }
        }

        public void putValue(String string, Object object) {
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Object>();
            }
            this.attrs.put(string, object);
        }

        public Object getValue(String string) {
            if (this.attrs != null && this.attrs.containsKey(string)) {
                return this.attrs.get(string);
            }
            Object object = GeneralAction.extractCommonAttribute(this.map, this, string);
            if (object != null) {
                return object;
            }
            Action action = this.findAction();
            return action == null ? null : action.getValue(string);
        }

        public void setEnabled(boolean bl) {
        }

        void updateState(ActionMap actionMap, ActionMap actionMap2, boolean bl) {
            Action action;
            if (this.key == null) {
                return;
            }
            boolean bl2 = false;
            if (actionMap != null && (action = actionMap.get(this.key)) != null) {
                bl2 = bl && action.isEnabled();
                action.removePropertyChangeListener(this.weakL);
            }
            if (actionMap2 != null && (action = actionMap2.get(this.key)) != null) {
                PropertyChangeSupport propertyChangeSupport;
                action.addPropertyChangeListener(this.weakL);
                PropertyChangeSupport propertyChangeSupport2 = propertyChangeSupport = bl ? this.support : null;
                if (propertyChangeSupport != null && action.isEnabled() != bl2) {
                    propertyChangeSupport.firePropertyChange("enabled", bl2, !bl2);
                }
            }
        }

        private Action findAction() {
            Action action = this.global.findGlobalAction(this.key);
            return action == null ? this.fallback : action;
        }

        public Action createContextAwareInstance(Lookup lookup) {
            Action action = this.fallback;
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(lookup);
            }
            return new DelegateAction(this.map, this.key, lookup, action, this.global.isSurvive(), this.async);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                PropertyChangeSupport propertyChangeSupport;
                DelegateAction delegateAction = this;
                synchronized (delegateAction) {
                    propertyChangeSupport = this.support;
                }
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.firePropertyChange("enabled", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            }
        }

        public int hashCode() {
            int n = this.key == null ? 37 : this.key.hashCode();
            int n2 = this.map == null ? 17 : ((Object)this.map).hashCode();
            int n3 = this.fallback == null ? 7 : this.fallback.hashCode();
            return (n << 2) + (n2 << 1) + n3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DelegateAction) {
                DelegateAction delegateAction = (DelegateAction)object;
                if (this.key != null && !this.key.equals(delegateAction.key)) {
                    return false;
                }
                if (this.map != null && !((Object)this.map).equals(delegateAction.map)) {
                    return false;
                }
                return this.fallback == null || this.fallback.equals(delegateAction.fallback);
            }
            return false;
        }
    }
}

