/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.catalina.Session;
import org.apache.catalina.manager.util.SessionUtils;

public class JspHelper {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final int HIGHEST_SPECIAL = 62;
    private static char[][] specialCharactersRepresentation = new char[63][];

    private JspHelper() {
    }

    public static String guessDisplayLocaleFromSession(Session in_session) {
        return JspHelper.localeToString(SessionUtils.guessLocaleFromSession(in_session));
    }

    private static String localeToString(Locale locale) {
        if (locale != null) {
            return locale.toString();
        }
        return "";
    }

    public static String guessDisplayUserFromSession(Session in_session) {
        Object user = SessionUtils.guessUserFromSession(in_session);
        return JspHelper.escapeXml(user);
    }

    public static String getDisplayCreationTimeForSession(Session in_session) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT);
            return formatter.format(new Date(in_session.getCreationTime()));
        }
        catch (IllegalStateException ise) {
            return "";
        }
    }

    public static String getDisplayLastAccessedTimeForSession(Session in_session) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT);
            return formatter.format(new Date(in_session.getLastAccessedTime()));
        }
        catch (IllegalStateException ise) {
            return "";
        }
    }

    public static String getDisplayUsedTimeForSession(Session in_session) {
        return JspHelper.secondsToTimeString(SessionUtils.getUsedTimeForSession(in_session) / 1000L);
    }

    public static String getDisplayTTLForSession(Session in_session) {
        return JspHelper.secondsToTimeString(SessionUtils.getTTLForSession(in_session) / 1000L);
    }

    public static String getDisplayInactiveTimeForSession(Session in_session) {
        return JspHelper.secondsToTimeString(SessionUtils.getInactiveTimeForSession(in_session) / 1000L);
    }

    public static String secondsToTimeString(long in_seconds) {
        StringBuffer buff = new StringBuffer(9);
        long rest = in_seconds;
        long hour = rest / 3600L;
        long minute = (rest %= 3600L) / 60L;
        long second = rest %= 60L;
        if (hour < 10L) {
            buff.append('0');
        }
        buff.append(hour);
        buff.append(':');
        if (minute < 10L) {
            buff.append('0');
        }
        buff.append(minute);
        buff.append(':');
        if (second < 10L) {
            buff.append('0');
        }
        buff.append(second);
        return buff.toString();
    }

    private static void writeEscapedXml(char[] buffer, int length, Writer w) throws IOException {
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = buffer[i];
            if (c > '>' || (escaped = specialCharactersRepresentation[c]) == null) continue;
            if (start < i) {
                w.write(buffer, start, i - start);
            }
            w.write(escaped);
            start = i + 1;
        }
        if (start < length) {
            w.write(buffer, start, length - start);
        }
    }

    public static String escapeXml(Object obj) {
        String value = null;
        try {
            value = obj == null ? null : String.valueOf(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JspHelper.escapeXml(value);
    }

    public static String escapeXml(String buffer) {
        if (buffer == null) {
            return "";
        }
        int start = 0;
        int length = buffer.length();
        char[] arrayBuffer = buffer.toCharArray();
        StringBuffer escapedBuffer = null;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = arrayBuffer[i];
            if (c > '>' || (escaped = specialCharactersRepresentation[c]) == null) continue;
            if (start == 0) {
                escapedBuffer = new StringBuffer(length + 5);
            }
            if (start < i) {
                escapedBuffer.append(arrayBuffer, start, i - start);
            }
            start = i + 1;
            escapedBuffer.append(escaped);
        }
        if (start == 0) {
            return buffer;
        }
        if (start < length) {
            escapedBuffer.append(arrayBuffer, start, length - start);
        }
        return escapedBuffer.toString();
    }

    public static String formatNumber(long number) {
        return NumberFormat.getNumberInstance().format(number);
    }

    static {
        JspHelper.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        JspHelper.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        JspHelper.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        JspHelper.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        JspHelper.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }
}

