/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.cache.CachedManifest;
import com.sun.deploy.cache.IndexFileObjectInputStream;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.TrustedLibraries;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;

public class CacheEntry {
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = 1;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int noHref = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    private long entryCreationTime = 0L;
    private long validationTimestampt = 0L;
    private long certExpirationDate = 0L;
    private boolean knownToBeSigned = false;
    private long blacklistValidationTime = 0L;
    private long trustedLibrariesValidationTime = 0L;
    public static final byte PREVERIFY_FAILED = 2;
    public static final byte PREVERIFY_SUCCEEDED = 1;
    public static final byte PREVERIFY_NOTDONE = 0;
    private byte classVerificationStatus = 0;
    Map checkedJars = null;
    private boolean hasOnlySignedEntries = false;
    private boolean hasSingleCodeSource = false;
    private boolean hasMissingSignedEntries = false;
    private static final int section1Length = 128;
    private int section2Length = 0;
    private int section3Length = 0;
    private int section4Length = 0;
    private int section4CertsLength = 0;
    private int section4SignersLength = 0;
    private int section4Pre15Length = 0;
    private int section5Length = 0;
    private int reducedManifestLength = 0;
    private int reducedManifest2Length = 0;
    private static final String META_FILE_DIR = "META-INF/";
    private static final String JAR_INDEX_NAME = "META-INF/INDEX.LIST";
    private SoftReference manifestRef = null;
    private boolean doneReadManifest = false;
    private boolean doneReadCerts = false;
    private boolean doneReadSigners = false;
    private Map signerMapHardRef = null;
    private SoftReference signerMapRef = null;
    private CodeSigner[] signersHardRef = null;
    private SoftReference signersRef = null;
    private Map codeSourceCacheHardRef = null;
    private SoftReference codeSourceCacheRef = null;
    private Map signerMapCertHardRef = null;
    private SoftReference signerMapCertRef;
    private Certificate[] certificatesHardRef = null;
    private SoftReference certificatesRef = null;
    private Map codeSourceCertCacheHardRef = null;
    private SoftReference codeSourceCertCacheRef = null;
    private static boolean enhancedJarAccess;

    public static boolean hasEnhancedJarAccess() {
        return enhancedJarAccess;
    }

    public void verifyJAR(URLClassLoader uRLClassLoader) {
        JarFile jarFile = this.getJarFile();
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (string == null || !string.endsWith(".class")) continue;
            try {
                String string2 = string.substring(0, string.lastIndexOf(".class"));
                Class<?> clazz = Class.forName(string2.replace('/', '.'), false, uRLClassLoader);
                bl = true;
            }
            catch (Throwable throwable) {
                boolean bl3 = false;
                String string3 = throwable.getMessage().replace('/', '.');
                if (string3 != null && (string3.indexOf("com.sun.media.jmcimpl.JMFPlayerPeer") != -1 || string3.indexOf("javafx.fxunit.FXTestCase") != -1 || string3.indexOf("javax.media.ControllerListener") != -1 || string3.indexOf("junit.framework.TestCase") != -1)) {
                    try {
                        URL uRL = new URL(this.getURL());
                        String string4 = uRL.getHost();
                        if (string4.equals("dl.javafx.com")) {
                            Trace.println("CacheEntry:  Skipped verification for class " + string3 + " in " + this.getURL(), TraceLevel.CACHE);
                            bl3 = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Environment.allowAltJavaFxRuntimeURL()) {
                    bl3 = true;
                    if (Trace.isTraceLevelEnabled(TraceLevel.CACHE)) {
                        throwable.printStackTrace();
                    }
                }
                if (bl3) continue;
                Trace.println("Class verification failed: " + throwable.getMessage() + " for " + this.getURL(), TraceLevel.CACHE);
                bl2 = true;
                break;
            }
        }
        if (bl && !bl2) {
            this.updateClassVerificationStatus((byte)1);
            Trace.println("CacheEntry:  Pre-verify done for all classes in " + this.getURL(), TraceLevel.CACHE);
            return;
        }
        this.updateClassVerificationStatus((byte)2);
        Trace.println("CacheEntry:  Cannot pre-verify all classes in " + this.getURL(), TraceLevel.CACHE);
    }

    public long getCreationTimespampt() {
        return this.entryCreationTime;
    }

    private boolean isOKToUseCachedSecurityValidation() {
        if (System.currentTimeMillis() > this.certExpirationDate) {
            return false;
        }
        if (Config.getBooleanProperty("deployment.security.validation.crl") || Config.getBooleanProperty("deployment.security.validation.ocsp")) {
            Trace.println("Certificate revocation enabled. Disable security validation optimizations.", TraceLevel.SECURITY);
            return false;
        }
        return true;
    }

    public long getValidationTimestampt() {
        if (!this.isOKToUseCachedSecurityValidation()) {
            this.knownToBeSigned = false;
            this.validationTimestampt = 0L;
        }
        return this.validationTimestampt;
    }

    private void updateBlacklistValidation() {
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            this.blacklistValidationTime = System.currentTimeMillis();
        }
    }

    private void updateTrustedLibrariesValidation() {
        this.trustedLibrariesValidationTime = System.currentTimeMillis();
    }

    public boolean isKnownToBeSigned() {
        if (!this.isOKToUseCachedSecurityValidation()) {
            this.knownToBeSigned = false;
            this.validationTimestampt = 0L;
        }
        return this.knownToBeSigned;
    }

    public byte getClassesVerificationStatus() {
        return this.classVerificationStatus;
    }

    private void updateClassVerificationStatus(byte by) {
        this.classVerificationStatus = by;
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.println("Failed to update Class Verification result in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    public boolean hasSigningInfo() {
        return this.section4Length != 0;
    }

    public void updateValidationResultsForApplet(boolean bl, Map map, long l, long l2) {
        Map map2 = null;
        map2 = Config.isJavaVersionAtLeast15() ? this.getSignerMap() : this.getCertificateMap();
        if (map2 != null && this.hasStrictSingleSigning()) {
            Trace.println("updateValidationResultsForApplet update", TraceLevel.BASIC);
            this.updateValidationResults(bl, map, l, l2);
        }
    }

    public void updateValidationResults(boolean bl, Map map, long l, long l2) {
        this.knownToBeSigned = bl;
        this.validationTimestampt = l;
        this.certExpirationDate = l2;
        this.checkedJars = map;
        Trace.println("Mark prevalidated: " + this.url + " " + bl + " tm=" + l + " cert=" + l2, TraceLevel.CACHE);
        try {
            this.updateSecurityValidationCache();
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.println("Failed to update list of trusted cached entries in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    private void updateSecurityValidationCache() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.section5Length = 0;
                            if (CacheEntry.this.checkedJars != null && !CacheEntry.this.checkedJars.isEmpty()) {
                                Object object;
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
                                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                Set set = CacheEntry.this.checkedJars.entrySet();
                                dataOutputStream.writeInt(set.size());
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    dataOutputStream.writeUTF((String)object.getKey());
                                    dataOutputStream.writeLong((Long)object.getValue());
                                }
                                dataOutputStream.close();
                                byteArrayOutputStream.close();
                                object = byteArrayOutputStream.toByteArray();
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                                randomAccessFile.write((byte[])object);
                                CacheEntry.this.section5Length = ((Object)object).length;
                            }
                            Object var8_7 = null;
                            if (randomAccessFile == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (randomAccessFile == null) throw throwable;
                            CacheEntry.this.doUpdateHeader(randomAccessFile);
                            randomAccessFile.close();
                            throw throwable;
                        }
                        CacheEntry.this.doUpdateHeader(randomAccessFile);
                        randomAccessFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSecurityValidationCache() throws IOException {
        if (this.section5Length != 0) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        DataInputStream dataInputStream;
                        byte[] byArray = new byte[CacheEntry.this.section5Length];
                        RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                        try {
                            randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                            randomAccessFile.readFully(byArray);
                            dataInputStream = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            randomAccessFile.close();
                            throw throwable;
                        }
                        randomAccessFile.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        dataInputStream = new DataInputStream(byteArrayInputStream);
                        HashMap<String, Long> hashMap = new HashMap<String, Long>();
                        for (int i = dataInputStream.readInt(); i > 0; --i) {
                            String string = dataInputStream.readUTF();
                            Long l = new Long(dataInputStream.readLong());
                            hashMap.put(string, l);
                        }
                        CacheEntry.this.checkedJars = hashMap;
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) return;
                throw (IOException)privilegedActionException.getException();
            }
        } else {
            this.checkedJars = null;
        }
    }

    public Map getCachedTrustedEntries() {
        if (this.section5Length == 0 && this.checkedJars == null) {
            return null;
        }
        if (this.checkedJars == null) {
            try {
                this.readSecurityValidationCache();
            }
            catch (IOException iOException) {
                Trace.println("Failed to read list of trusted cached entries from index", TraceLevel.CACHE);
                Trace.ignoredException(iOException);
            }
        }
        return this.checkedJars;
    }

    private void invalidateEntryDueToException(Throwable throwable) {
        Trace.println("Invalidating entry url=" + this.url + " file=" + this.indexFile.getAbsolutePath());
        Trace.ignored(throwable);
        this.invalidateEntry();
    }

    private void invalidateEntry() {
        this.setIncomplete(1);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public CacheEntry(File file) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CacheEntry.this.readIndexFile();
                }
                catch (Throwable throwable) {
                    CacheEntry.this.invalidateEntryDueToException(throwable);
                }
                return null;
            }
        });
    }

    public void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.updateIndexHeaderOnDisk();
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String string, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile;
        block2: {
            SyncFileAccess.RandomAccessFileLock randomAccessFileLock = null;
            RandomAccessFile randomAccessFile2 = null;
            try {
                randomAccessFileLock = this.indexFileSyncAccess.openLockRandomAccessFile(string, 10000, bl);
                randomAccessFile = randomAccessFile2 = randomAccessFileLock != null ? randomAccessFileLock.getRandomAccessFile() : new RandomAccessFile(this.indexFile, string);
                Object var7_6 = null;
                if (randomAccessFileLock == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (randomAccessFileLock == null) break block3;
                    randomAccessFileLock.release();
                }
                throw throwable;
            }
            randomAccessFileLock.release();
        }
        return randomAccessFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIndexFileOld() {
        var2_1 = null;
        try {
            block17: {
                if (!this.indexFile.exists()) ** GOTO lbl74
                var2_1 = this.openLockIndexFile("r", false);
                this.setBusy(var2_1.read());
                this.setIncomplete(var2_1.read());
                this.setCacheVersion(var2_1.readInt());
                if (this.getCacheVersion() != Cache.getCacheVersion() || !this.isValidEntry()) break block17;
                var2_1.close();
                var2_1 = null;
                this.readIndexFile();
                var6_2 = null;
                ** GOTO lbl67
            }
            if (this.getCacheVersion() == 602 && this.isValidEntry()) {
                this.setForceUpdate(var2_1.read());
                this.setNoHref(var2_1.read());
                this.setIsShortcutImage(var2_1.read());
                this.setContentLength(var2_1.readInt());
                this.setLastModified(var2_1.readLong());
                this.setExpirationDate(var2_1.readLong());
                this.setVersion(var2_1.readUTF());
                this.setURL(var2_1.readUTF());
                this.setNamespaceID(var2_1.readUTF());
                var3_10 = new File(this.getResourceFilename());
                if (!var3_10.exists()) {
                    var2_1.close();
                    var2_1 = null;
                    this.invalidateEntry();
                }
            } else {
                var2_1.close();
                var2_1 = null;
                this.invalidateEntry();
            }
            if (this.getIncomplete() == 0) {
                this.readHeadersOld(var2_1);
            }
            ** GOTO lbl74
        }
        catch (IOException var3_11) {
            if (var2_1 != null) {
                try {
                    var2_1.close();
                    var2_1 = null;
                }
                catch (IOException var4_12) {
                    Trace.ignoredException(var4_12);
                }
            }
            this.invalidateEntryDueToException(var3_11);
            var6_4 = null;
            try {
                if (var2_1 == null) return;
                var2_1.close();
                return;
            }
            catch (IOException var7_8) {
                Trace.ignoredException(var7_8);
                return;
            }
        }
        {
            catch (Throwable var5_13) {
                var6_5 = null;
                ** try [egrp 3[TRYBLOCK] [7 : 266->277)] { 
lbl61:
                // 1 sources

                if (var2_1 == null) throw var5_13;
                var2_1.close();
                throw var5_13;
lbl64:
                // 1 sources

                catch (IOException var7_9) {
                    Trace.ignoredException(var7_9);
                }
                throw var5_13;
            }
lbl67:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 266->277)] { 
lbl68:
            // 1 sources

            if (var2_1 == null) return;
            var2_1.close();
            return;
lbl71:
            // 1 sources

            catch (IOException var7_6) {
                Trace.ignoredException(var7_6);
            }
            return;
lbl74:
            // 2 sources

            var6_3 = null;
            try {}
            catch (IOException var7_7) {}
            Trace.ignoredException(var7_7);
            return;
            if (var2_1 == null) return;
            var2_1.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIndexFile() {
        var1_1 = null;
        try {
            block25: {
                block24: {
                    if (!this.indexFile.exists()) ** GOTO lbl147
                    var1_1 = this.openLockIndexFile("r", false);
                    var2_2 = new byte[128];
                    var3_4 = var1_1.read(var2_2);
                    var4_5 = new DataInputStream(new ByteArrayInputStream(var2_2, 0, var3_4));
                    this.setBusy(var4_5.readByte());
                    this.setIncomplete(var4_5.readByte());
                    this.setCacheVersion(var4_5.readInt());
                    if (this.getCacheVersion() == Cache.getCacheVersion()) break block24;
                    var1_1.close();
                    var1_1 = null;
                    Trace.println("Trying to upgrade in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
                    this.readIndexFileOld();
                    this.cacheVersion = Cache.getCacheVersion();
                    var5_6 = this.isValidEntry();
                    try {
                        this.setBusy(1);
                        this.updateIndexHeaderOnDisk();
                        if (var5_6) {
                            this.writeFileToDisk();
                            Trace.println("Upgrade of entry done", TraceLevel.CACHE);
                        } else {
                            Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
                        }
                    }
                    catch (IOException var6_8) {
                        this.setBusy(0);
                        this.invalidateEntryDueToException(var6_8);
                    }
                    var9_10 = null;
                    ** GOTO lbl124
                }
                this.setForceUpdate(var4_5.readByte());
                this.setNoHref(var4_5.readByte());
                this.setIsShortcutImage(var4_5.readByte());
                this.setContentLength(var4_5.readInt());
                this.setLastModified(var4_5.readLong());
                this.setExpirationDate(var4_5.readLong());
                var5_7 = new File(this.getResourceFilename());
                if (!var5_7.exists()) {
                    this.setIncomplete(1);
                }
                if (this.getIncomplete() != 1) break block25;
                var1_1.close();
                ** GOTO lbl131
            }
            this.validationTimestampt = var4_5.readLong();
            this.knownToBeSigned = var4_5.readByte() == 1;
            this.section2Length = var4_5.readInt();
            this.section3Length = var4_5.readInt();
            this.section4Length = var4_5.readInt();
            this.section5Length = var4_5.readInt();
            this.blacklistValidationTime = var4_5.readLong();
            this.certExpirationDate = var4_5.readLong();
            this.classVerificationStatus = var4_5.readByte();
            this.reducedManifestLength = var4_5.readInt();
            this.section4Pre15Length = var4_5.readInt();
            this.hasOnlySignedEntries = var4_5.readByte() == 1;
            this.hasSingleCodeSource = var4_5.readByte() == 1;
            this.section4CertsLength = var4_5.readInt();
            this.section4SignersLength = var4_5.readInt();
            this.hasMissingSignedEntries = var4_5.readByte() == 1;
            this.trustedLibrariesValidationTime = var4_5.readLong();
            this.reducedManifest2Length = var4_5.readInt();
            var4_5.close();
            if (this.section2Length > 0) {
                var2_2 = new byte[this.section2Length];
                var1_1.read(var2_2);
                var4_5 = new DataInputStream(new ByteArrayInputStream(var2_2));
                this.setVersion(var4_5.readUTF());
                this.setURL(var4_5.readUTF());
                this.setNamespaceID(var4_5.readUTF());
                this.setCodebaseIP(var4_5.readUTF());
                this.readHeaders(var4_5);
            }
            if (!this.hasSigningInfo() || (this.section4Pre15Length != 0 || !CacheEntry.enhancedJarAccess) && !BlackList.hasBeenModifiedSince(this.blacklistValidationTime) && !TrustedLibraries.hasBeenModifiedSince(this.trustedLibrariesValidationTime) || Cache.isSystemCacheEntry(this) && !Environment.isSystemCacheMode()) ** GOTO lbl147
            var1_1.close();
            var1_1 = null;
            Trace.println("Trying to update in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
            this.cacheVersion = Cache.getCacheVersion();
            var6_9 = this.isValidEntry();
            try {
                this.setBusy(1);
                this.updateIndexHeaderOnDisk();
                if (var6_9) {
                    Trace.println("Upgrade writing to disk for " + var5_7, TraceLevel.CACHE);
                    this.writeFileToDisk();
                    Trace.println("Upgrade of entry done", TraceLevel.CACHE);
                } else {
                    Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
                }
            }
            catch (IOException var7_22) {
                this.setBusy(0);
                this.invalidateEntryDueToException(var7_22);
            }
            Trace.println("readIndexFile returning success", TraceLevel.CACHE);
            ** GOTO lbl139
        }
        catch (IOException var2_3) {
            this.setIncomplete(1);
            Trace.ignoredException(var2_3);
            var9_14 = null;
            try {
                if (var1_1 == null) return;
                var1_1.close();
                return;
            }
            catch (IOException var10_20) {
                Trace.ignoredException(var10_20);
                return;
            }
        }
        {
            catch (Throwable var8_23) {
                var9_15 = null;
                ** try [egrp 4[TRYBLOCK] [11 : 803->814)] { 
lbl118:
                // 1 sources

                if (var1_1 == null) throw var8_23;
                var1_1.close();
                throw var8_23;
lbl121:
                // 1 sources

                catch (IOException var10_21) {
                    Trace.ignoredException(var10_21);
                }
                throw var8_23;
            }
lbl124:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [11 : 803->814)] { 
lbl125:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl128:
            // 1 sources

            catch (IOException var10_16) {
                Trace.ignoredException(var10_16);
            }
            return;
lbl131:
            // 1 sources

            var9_11 = null;
            ** try [egrp 4[TRYBLOCK] [11 : 803->814)] { 
lbl133:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl136:
            // 1 sources

            catch (IOException var10_17) {
                Trace.ignoredException(var10_17);
            }
            return;
lbl139:
            // 1 sources

            var9_12 = null;
            ** try [egrp 4[TRYBLOCK] [11 : 803->814)] { 
lbl141:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl144:
            // 1 sources

            catch (IOException var10_18) {
                Trace.ignoredException(var10_18);
            }
            return;
lbl147:
            // 2 sources

            var9_13 = null;
            try {}
            catch (IOException var10_19) {}
            Trace.ignoredException(var10_19);
            return;
            if (var1_1 == null) return;
            var1_1.close();
            return;
        }
    }

    public void setBusy(int n) {
        this.busy = n;
    }

    int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public void setIncomplete(int n) {
        this.incomplete = n;
    }

    int getIncomplete() {
        return this.incomplete;
    }

    public boolean isValidEntry() {
        return this.busy == 0 && this.incomplete == 0;
    }

    public void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    private void setForceUpdate(int n) {
        this.forceUpdate = n;
    }

    private int getForceUpdate() {
        return this.forceUpdate;
    }

    void setNoHref(int n) {
        this.noHref = n;
    }

    private int getNoHref() {
        return this.noHref;
    }

    boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.getIncomplete() == 1) {
            return true;
        }
        if (cacheEntry.getIncomplete() == 1) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Map getCertificateMap() {
        Map map;
        Map map2 = map = this.signerMapCertRef != null ? (Map)this.signerMapCertRef.get() : null;
        if (!this.doneReadCerts || this.signerMapCertRef != null && map == null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            map = this.signerMapCertHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return map;
    }

    public Map getSignerMap() {
        Map map;
        Map map2 = map = this.signerMapRef != null ? (Map)this.signerMapRef.get() : null;
        if (!this.doneReadSigners || this.signerMapRef != null && map == null) {
            try {
                this.readSigners();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readSigners();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            map = this.signerMapHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return map;
    }

    boolean hasSingleCodeSource() {
        return this.hasSingleCodeSource;
    }

    boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    boolean hasOnlySignedEntries() {
        return this.hasOnlySignedEntries;
    }

    boolean hasMissingSignedEntries() {
        return this.hasMissingSignedEntries;
    }

    Map getCodeSourceCertCache() {
        Map map;
        Map map2 = map = this.codeSourceCertCacheRef != null ? (Map)this.codeSourceCertCacheRef.get() : null;
        if (!this.doneReadCerts || this.codeSourceCertCacheRef != null && map == null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            map = this.codeSourceCertCacheHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return map;
    }

    Map getCodeSourceCache() {
        if (Config.isJavaVersionAtLeast15()) {
            Map map;
            Map map2 = map = this.codeSourceCacheRef != null ? (Map)this.codeSourceCacheRef.get() : null;
            if (!this.doneReadSigners || this.codeSourceCacheRef != null && map == null) {
                try {
                    this.readSigners();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    this.recover();
                    try {
                        this.readSigners();
                    }
                    catch (IOException iOException2) {
                        this.invalidateEntryDueToException(iOException2);
                    }
                }
                map = this.codeSourceCacheHardRef;
                this.clearHardRefs();
            }
            this.touchRefs();
            return map;
        }
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        CodeSigner[] codeSignerArray;
        CodeSigner[] codeSignerArray2 = codeSignerArray = this.signersRef != null ? (CodeSigner[])this.signersRef.get() : null;
        if (!this.doneReadSigners || codeSignerArray == null && this.signersRef != null) {
            try {
                this.readSigners();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readSigners();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            codeSignerArray = this.signersHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return codeSignerArray;
    }

    public Certificate[] getCertificates() {
        Certificate[] certificateArray;
        Certificate[] certificateArray2 = certificateArray = this.certificatesRef != null ? (Certificate[])this.certificatesRef.get() : null;
        if (!this.doneReadCerts || this.certificatesRef != null && certificateArray == null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            certificateArray = this.certificatesHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return certificateArray;
    }

    CodeSource[] getCodeSources(URL uRL) {
        Map map;
        Collection collection = null;
        CodeSource[] codeSourceArray = null;
        if (Config.isJavaVersionAtLeast15()) {
            map = this.getCodeSourceCache();
            if (map != null) {
                collection = map.values();
            }
        } else {
            map = this.getCodeSourceCertCache();
            if (map != null) {
                collection = map.values();
            }
        }
        if (collection != null) {
            int n = collection.size();
            if (this.hasOnlySignedEntries) {
                codeSourceArray = collection.toArray(new CodeSource[n]);
            } else {
                codeSourceArray = collection.toArray(new CodeSource[n + 1]);
                codeSourceArray[n] = CacheEntry.getUnsignedCS(uRL);
            }
        } else {
            codeSourceArray = new CodeSource[]{CacheEntry.getUnsignedCS(uRL)};
        }
        return codeSourceArray;
    }

    private void touchRefs() {
        Object t;
        if (this.signerMapRef != null) {
            t = this.signerMapRef.get();
        }
        if (this.signersRef != null) {
            t = this.signersRef.get();
        }
        if (this.certificatesRef != null) {
            t = this.certificatesRef.get();
        }
        if (this.signerMapCertRef != null) {
            t = this.signerMapCertRef.get();
        }
        if (this.manifestRef != null) {
            t = this.manifestRef.get();
        }
        if (this.codeSourceCacheRef != null) {
            t = this.codeSourceCacheRef.get();
        }
        if (this.codeSourceCertCacheRef != null) {
            t = this.codeSourceCertCacheRef.get();
        }
    }

    private void clearHardRefs() {
        this.signerMapHardRef = null;
        this.signersHardRef = null;
        this.signerMapCertHardRef = null;
        this.certificatesHardRef = null;
        this.codeSourceCacheHardRef = null;
        this.codeSourceCertCacheHardRef = null;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    public void updateExpirationInIndexFile(long l) {
        if (this.getExpirationDate() == l) {
            return;
        }
        this.setExpirationDate(l);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    public JarFile getJarFile() {
        JarFile jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Config.isJavaVersionAtLeast15()) {
                    CachedJarFile cachedJarFile = null;
                    try {
                        cachedJarFile = new CachedJarFile(CacheEntry.this);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return cachedJarFile;
                }
                CachedJarFile14 cachedJarFile14 = null;
                try {
                    cachedJarFile14 = new CachedJarFile14(CacheEntry.this);
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                return cachedJarFile14;
            }
        });
        return jarFile;
    }

    public String getResourceFilename() {
        return this.filename;
    }

    public File getDataFile() {
        File file = null;
        if (this.filename != null && !this.url.equals("")) {
            file = new File(this.filename);
            MemoryCache.addResourceReference(file, this.url);
        }
        return file;
    }

    File getTempDataFile() {
        return this.tempDataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public long getSize() {
        return this.getDataFile().length() + this.getIndexFile().length();
    }

    void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    public Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    boolean processTempDataFile(boolean bl, DownloadEngine.DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        Object object;
        boolean bl2 = false;
        if (bl) {
            object = null;
            String string2 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (!string3.startsWith("current-version-id")) continue;
                object = string3.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, null, (String)object);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                if (Trace.isTraceLevelEnabled(TraceLevel.NETWORK)) {
                    Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), (String)object, string), TraceLevel.NETWORK);
                }
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CacheEntry.this.tempDataFile.delete();
                    return null;
                }
            });
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (((Boolean)(object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(CacheEntry.this.tempDataFile.renameTo(new File(CacheEntry.this.filename)));
            }
        }))).booleanValue()) {
            bl2 = true;
        }
        return bl2;
    }

    private void initFrom(CacheEntry cacheEntry) {
        Trace.println("Recovering CacheEntry for " + cacheEntry.getURL(), TraceLevel.CACHE);
        this.filename = cacheEntry.filename;
        this.indexFile = cacheEntry.indexFile;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CacheEntry.this.readIndexFile();
                return null;
            }
        });
    }

    private void recover() {
        Trace.println("Trying to recover cache entry for " + this.url, TraceLevel.CACHE);
        try {
            URL uRL = new URL(this.url);
            String string = this.getVersion();
            String string2 = this.getNamespaceID();
            MemoryCache.removeLoadedResource(this.url);
            Cache.removeCacheEntry(this, false);
            DownloadEngine.getCachedFile(uRL);
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string2, string);
            if (cacheEntry == null) {
                throw new RuntimeException("ERROR: Recovery got null entry");
            }
            this.initFrom(cacheEntry);
        }
        catch (Exception exception) {
            throw new RuntimeException("ERROR: Failed to recover corrupt cache entry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        Manifest manifest;
        Manifest manifest2 = manifest = this.manifestRef != null ? (Manifest)this.manifestRef.get() : null;
        if (!this.doneReadManifest || this.manifestRef != null && manifest == null) {
            try {
                try {
                    manifest = this.readManifest();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    this.recover();
                    try {
                        manifest = this.readManifest();
                    }
                    catch (IOException iOException2) {
                        this.invalidateEntryDueToException(iOException2);
                    }
                    Object var5_3 = null;
                    this.clearHardRefs();
                }
                Object var5_2 = null;
                this.clearHardRefs();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.clearHardRefs();
                throw throwable;
            }
        }
        this.touchRefs();
        return manifest;
    }

    private void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public String getCodebaseIP() {
        return this.codebaseIP;
    }

    public void writeFileToDisk() throws IOException {
        this.writeFileToDisk(1, null);
    }

    private boolean hasMimeType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean hasRequestType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("deploy-request-content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    public boolean isJarFile(String string) {
        if (this.hasRequestType("application/x-java-archive")) {
            return true;
        }
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || this.hasMimeType("application/x-java-archive") || this.hasMimeType("application/java-archive") || this.hasMimeType("application/x-java-archive-diff");
    }

    public boolean isJNLPFile() {
        if (this.hasRequestType("application/x-java-jnlp-file")) {
            return true;
        }
        String string = this.url;
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jnlp") || string.toLowerCase().endsWith(".jarjnlp");
    }

    public void updateIndexHeaderOnDisk() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.doUpdateHeader(randomAccessFile);
                            Object var3_2 = null;
                            if (randomAccessFile == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (randomAccessFile == null) throw throwable;
                            randomAccessFile.close();
                            throw throwable;
                        }
                        randomAccessFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void doUpdateHeader(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile != null) {
            randomAccessFile.seek(0L);
            randomAccessFile.write(this.prepareHeader());
        }
    }

    private byte[] prepareHeader() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.busy);
        dataOutputStream.writeByte(this.incomplete);
        dataOutputStream.writeInt(this.cacheVersion);
        dataOutputStream.writeByte(this.forceUpdate);
        dataOutputStream.writeByte(this.noHref);
        dataOutputStream.writeByte(this.isShortcutImage);
        dataOutputStream.writeInt(this.contentLength);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeLong(this.expirationDate);
        dataOutputStream.writeLong(this.validationTimestampt);
        dataOutputStream.writeByte(this.knownToBeSigned ? 1 : 0);
        dataOutputStream.writeInt(this.section2Length);
        dataOutputStream.writeInt(this.section3Length);
        dataOutputStream.writeInt(this.section4Length);
        dataOutputStream.writeInt(this.section5Length);
        dataOutputStream.writeLong(this.blacklistValidationTime);
        dataOutputStream.writeLong(this.certExpirationDate);
        dataOutputStream.writeByte(this.classVerificationStatus);
        dataOutputStream.writeInt(this.reducedManifestLength);
        dataOutputStream.writeInt(this.section4Pre15Length);
        dataOutputStream.writeByte(this.hasOnlySignedEntries ? 1 : 0);
        dataOutputStream.writeByte(this.hasSingleCodeSource ? 1 : 0);
        dataOutputStream.writeInt(this.section4CertsLength);
        dataOutputStream.writeInt(this.section4SignersLength);
        dataOutputStream.writeByte(this.hasMissingSignedEntries ? 1 : 0);
        dataOutputStream.writeLong(this.trustedLibrariesValidationTime);
        dataOutputStream.writeInt(this.reducedManifest2Length);
        dataOutputStream.flush();
        if (byteArrayOutputStream.size() < 128) {
            byte[] byArray = new byte[128 - byteArrayOutputStream.size()];
            dataOutputStream.write(byArray);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    void writeFileToDisk(final int n, final DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() throws IOException {
                        ZipFile zipFile;
                        block14: {
                            zipFile = null;
                            RandomAccessFile randomAccessFile = null;
                            CacheEntry.this.section2Length = 0;
                            CacheEntry.this.section3Length = 0;
                            CacheEntry.this.section4Length = 0;
                            CacheEntry.this.section4Pre15Length = 0;
                            CacheEntry.this.section4CertsLength = 0;
                            CacheEntry.this.section4SignersLength = 0;
                            CacheEntry.this.section5Length = 0;
                            CacheEntry.this.reducedManifestLength = 0;
                            CacheEntry.this.reducedManifest2Length = 0;
                            try {
                                try {
                                    Object object;
                                    String string;
                                    randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                                    byte[] byArray = CacheEntry.this.prepareHeader();
                                    randomAccessFile.write(byArray);
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                    dataOutputStream.writeUTF(CacheEntry.this.getVersion() != null ? CacheEntry.this.getVersion() : "");
                                    dataOutputStream.writeUTF(CacheEntry.this.getURL());
                                    dataOutputStream.writeUTF(CacheEntry.this.getNamespaceID());
                                    InetAddress inetAddress = null;
                                    String string2 = "";
                                    if (CacheEntry.this.url != null && !CacheEntry.this.url.equals("") && (inetAddress = Cache.getHostIP(string = ((URL)(object = new URL(CacheEntry.this.url))).getHost())) != null) {
                                        string2 = inetAddress.getHostAddress();
                                    }
                                    dataOutputStream.writeUTF(string2);
                                    CacheEntry.this.writeHeaders(dataOutputStream);
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    CacheEntry.this.section2Length = byteArrayOutputStream.size();
                                    randomAccessFile.write(byteArrayOutputStream.toByteArray());
                                    if (CacheEntry.this.incomplete == 0) {
                                        if (CacheEntry.this.isJarFile(CacheEntry.this.url)) {
                                            zipFile = new JarFile(new File(CacheEntry.this.filename));
                                            object = new CachedManifest((JarFile)zipFile);
                                            CacheEntry.this.writeManifest(randomAccessFile, (JarFile)zipFile, (CachedManifest)object, n, downloadDelegate);
                                            ((CachedManifest)object).postprocess();
                                            CacheEntry.this.updateManifestRefs((Manifest)object);
                                            zipFile.close();
                                        }
                                        DownloadEngine.addToUpdateCheckDoneList(CacheEntry.this.url);
                                        Cache.addToCleanupThreadLoadedResourceList(CacheEntry.this.url);
                                        CacheEntry.this.setBusy(0);
                                        CacheEntry.this.setIncomplete(0);
                                        CacheEntry.this.updateBlacklistValidation();
                                        CacheEntry.this.updateTrustedLibrariesValidation();
                                        CacheEntry.this.doUpdateHeader(randomAccessFile);
                                        CacheEntry.this.doneReadManifest = true;
                                        CacheEntry.this.doneReadCerts = true;
                                        CacheEntry.this.doneReadSigners = true;
                                    }
                                }
                                catch (Exception exception) {
                                    Trace.ignoredException(exception);
                                    if (randomAccessFile != null) {
                                        randomAccessFile.close();
                                        randomAccessFile = null;
                                    }
                                    if (zipFile != null) {
                                        zipFile.close();
                                        zipFile = null;
                                    }
                                    Cache.removeCacheEntry(CacheEntry.this);
                                    if (exception instanceof JARSigningException) {
                                        throw (JARSigningException)exception;
                                    }
                                    if (!(exception instanceof ZipException)) throw new IOException(exception.getMessage());
                                    throw new JARSigningException(new URL(CacheEntry.this.url), CacheEntry.this.version, 2, exception);
                                }
                                Object var11_11 = null;
                                if (randomAccessFile == null) break block14;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                                Cache.cleanup();
                                throw throwable;
                            }
                            randomAccessFile.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        Cache.cleanup();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void updateManifestRefs(Manifest manifest) {
        this.manifestRef = manifest != null ? new SoftReference<Manifest>(manifest) : null;
    }

    private byte[] readBlock(final int n, final int n2) throws IOException {
        try {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    byte[] byArray;
                    block2: {
                        RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                        try {
                            randomAccessFile.seek(n);
                            Object var2_2 = null;
                            byte[] byArray2 = new byte[n2];
                            randomAccessFile.readFully(byArray2);
                            byArray = byArray2;
                            Object var6_5 = null;
                            if (randomAccessFile == null) break block2;
                        }
                        catch (Throwable throwable) {
                            block3: {
                                Object var6_6 = null;
                                if (randomAccessFile == null) break block3;
                                randomAccessFile.close();
                            }
                            throw throwable;
                        }
                        randomAccessFile.close();
                    }
                    return byArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            return null;
        }
    }

    byte[] getFullManifestBytes() throws IOException {
        if (this.reducedManifest2Length > 0) {
            int n = 128 + this.section2Length;
            int n2 = this.section3Length - this.reducedManifest2Length;
            return this.readBlock(n, n2);
        }
        if (this.reducedManifestLength > 0) {
            int n = 128 + this.section2Length + this.reducedManifestLength;
            int n3 = this.section3Length - this.reducedManifestLength;
            return this.readBlock(n, n3);
        }
        return null;
    }

    Manifest readManifest() throws IOException {
        CachedManifest cachedManifest = null;
        if (this.section3Length != 0) {
            int n;
            int n2 = 128 + this.section2Length;
            if (this.reducedManifest2Length > 0) {
                n2 += this.section3Length - this.reducedManifest2Length;
                n = this.reducedManifest2Length;
            } else {
                n = this.reducedManifestLength > 0 ? this.reducedManifestLength : this.section3Length;
            }
            byte[] byArray = this.readBlock(n2, n);
            Trace.println(" Read manifest for " + this.url + ": read=" + n + " full=" + this.section3Length, TraceLevel.CACHE);
            cachedManifest = new CachedManifest(this.getURL(), byArray, this.reducedManifest2Length > 0 || this.reducedManifestLength > 0);
            this.updateManifestRefs(cachedManifest);
        }
        this.doneReadManifest = true;
        return cachedManifest;
    }

    private void readCertificates() throws IOException {
        block3: {
            int n = this.section4Pre15Length != 0 ? this.section4Pre15Length : this.section4Length;
            final int n2 = this.hasStrictSingleSigning() ? this.section4CertsLength : n;
            Trace.println("Reading certificates from " + n2 + " " + this.url + " | " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
            if (this.section4Length != 0) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public Object run() throws IOException {
                            RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                            try {
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length);
                                byte[] byArray = new byte[n2];
                                randomAccessFile.readFully(byArray);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                                IndexFileObjectInputStream indexFileObjectInputStream = new IndexFileObjectInputStream(bufferedInputStream);
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(indexFileObjectInputStream));
                                CacheEntry.this.readCertificates(indexFileObjectInputStream, bufferedReader);
                                CacheEntry.this.doneReadCerts = true;
                                Object var8_7 = null;
                                if (randomAccessFile == null) return null;
                            }
                            catch (Throwable throwable) {
                                Object var8_8 = null;
                                if (randomAccessFile == null) throw throwable;
                                randomAccessFile.close();
                                throw throwable;
                            }
                            randomAccessFile.close();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!(privilegedActionException.getException() instanceof IOException)) break block3;
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }
    }

    private void readSigners() throws IOException {
        block3: {
            final boolean bl = this.section4Pre15Length != 0 && this.section4SignersLength < 5;
            final int n = this.section4Pre15Length != 0 && (!bl || this.hasStrictSingleSigning()) ? this.section4CertsLength : this.section4Length - (this.section4Length - this.section4Pre15Length);
            final int n2 = this.hasStrictSingleSigning() || bl ? this.section4SignersLength : this.section4Length - this.section4Pre15Length;
            Trace.println("Reading Signers from " + n2 + " " + this.url + " | " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
            if (this.section4Length != 0) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public Object run() throws IOException {
                            RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                            try {
                                byte[] byArray = new byte[n + n2];
                                if (n != 0) {
                                    randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length);
                                    randomAccessFile.readFully(byArray, 0, n);
                                }
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Pre15Length);
                                randomAccessFile.readFully(byArray, n, n2);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                                IndexFileObjectInputStream indexFileObjectInputStream = new IndexFileObjectInputStream(bufferedInputStream);
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(indexFileObjectInputStream));
                                if (n2 == CacheEntry.this.section4Length || bl) {
                                    CacheEntry.this.readCertificates(indexFileObjectInputStream, bufferedReader);
                                    CacheEntry.this.doneReadCerts = true;
                                } else {
                                    int n3 = indexFileObjectInputStream.readInt();
                                    try {
                                        for (int i = 0; i < n3; ++i) {
                                            indexFileObjectInputStream.readObject();
                                        }
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new IOException("Error reading signer certificates");
                                    }
                                }
                                CacheEntry.this.readSigners(indexFileObjectInputStream, bufferedReader);
                                CacheEntry.this.doneReadSigners = true;
                                Object var10_10 = null;
                                if (randomAccessFile == null) return null;
                            }
                            catch (Throwable throwable) {
                                Object var10_11 = null;
                                if (randomAccessFile == null) throw throwable;
                                randomAccessFile.close();
                                throw throwable;
                            }
                            randomAccessFile.close();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!(privilegedActionException.getException() instanceof IOException)) break block3;
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }
    }

    private void readCertificates(ObjectInputStream objectInputStream, BufferedReader bufferedReader) throws IOException {
        int n = objectInputStream.readInt();
        if (n > 0) {
            HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
            HashMap<int[], CodeSource> hashMap2 = new HashMap<int[], CodeSource>();
            Certificate[] certificateArray = new Certificate[n];
            this.signerMapCertHardRef = hashMap;
            this.signerMapCertRef = new SoftReference<Map>(this.signerMapCertHardRef);
            this.codeSourceCertCacheHardRef = hashMap2;
            this.codeSourceCertCacheRef = new SoftReference<Map>(this.codeSourceCertCacheHardRef);
            this.certificatesHardRef = certificateArray;
            this.certificatesRef = new SoftReference<Certificate[]>(this.certificatesHardRef);
            try {
                for (int i = 0; i < n; ++i) {
                    certificateArray[i] = (Certificate)objectInputStream.readObject();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading signer certificates");
            }
            int[] nArray = null;
            URL uRL = new URL(this.url);
            if (this.hasStrictSingleSigning()) {
                nArray = new int[certificateArray.length];
                for (int i = 0; i < certificateArray.length; ++i) {
                    nArray[i] = i;
                }
                CodeSource codeSource = new CodeSource(uRL, certificateArray);
                hashMap.put(null, nArray);
                hashMap2.put(nArray, codeSource);
                return;
            }
            String string = bufferedReader.readLine();
            String string2 = null;
            HashMap<String, int[]> hashMap3 = new HashMap<String, int[]>();
            int[] nArray2 = null;
            while (string != null && !string.equals("")) {
                String string3 = string;
                if (string3.startsWith("/")) {
                    string3 = string2 + string3;
                } else {
                    int n2 = string3.lastIndexOf("/");
                    if (n2 != -1) {
                        string2 = string3.substring(0, n2);
                    }
                }
                string = bufferedReader.readLine();
                if (nArray2 != null) {
                    hashMap.put(string3, nArray2);
                } else {
                    nArray = (int[])hashMap3.get(string);
                    if (nArray == null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
                        int n3 = Integer.parseInt(stringTokenizer.nextToken());
                        nArray = new int[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        hashMap3.put(string, nArray);
                        Certificate[] certificateArray2 = new Certificate[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            certificateArray2[i] = certificateArray[nArray[i]];
                        }
                        CodeSource codeSource = new CodeSource(uRL, certificateArray2);
                        hashMap2.put(nArray, codeSource);
                    }
                    hashMap.put(string3, nArray);
                    if (this.hasSingleCodeSource) {
                        nArray2 = nArray;
                    }
                }
                string = bufferedReader.readLine();
            }
        } else {
            Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
        }
    }

    private void readSigners(ObjectInputStream objectInputStream, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        int n = 0;
        if (!Config.isJavaVersionAtLeast15()) {
            Trace.println("readSigners called pre-1.5 ", TraceLevel.CACHE);
            return;
        }
        if (string != null) {
            n = Integer.parseInt(string);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<int[], Object> hashMap2 = new HashMap<int[], Object>();
        if (n == 0) {
            CodeSigner[] codeSignerArray;
            Object object;
            int[] nArray;
            if (this.signerMapCertHardRef == null || this.codeSourceCertCacheHardRef == null) {
                Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
                return;
            }
            this.signerMapHardRef = hashMap;
            this.signerMapRef = new SoftReference<Map>(this.signerMapHardRef);
            this.codeSourceCacheHardRef = hashMap2;
            this.codeSourceCacheRef = new SoftReference<Map>(this.codeSourceCacheHardRef);
            Map map = this.signerMapCertHardRef;
            Map map2 = this.codeSourceCertCacheHardRef;
            ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
            HashMap<int[], int[]> hashMap3 = new HashMap<int[], int[]>();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                nArray = (int[])entry.getKey();
                object = (CodeSource)entry.getValue();
                codeSignerArray = ((CodeSource)object).getCodeSigners();
                codeSignerArray = this.convertCertArrayToSignerArray(((CodeSource)object).getCertificates());
                object = new CodeSource(((CodeSource)object).getLocation(), codeSignerArray);
                if (codeSignerArray == null || codeSignerArray.length <= 0) continue;
                int[] nArray2 = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    int n2 = arrayList.indexOf(codeSignerArray[i]);
                    if (n2 == -1) {
                        n2 = arrayList.size();
                        arrayList.add(codeSignerArray[i]);
                    }
                    nArray2[i] = n2;
                }
                hashMap3.put(nArray, nArray2);
                hashMap2.put(nArray2, object);
            }
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                codeSignerArray = (CodeSigner[])object.getKey();
                nArray = (int[])object.getValue();
                hashMap.put(codeSignerArray, hashMap3.get(nArray));
            }
            this.signersHardRef = arrayList.toArray(new CodeSigner[arrayList.size()]);
            this.signersRef = new SoftReference<CodeSigner[]>(this.signersHardRef);
        } else if (n > 0) {
            this.signerMapHardRef = hashMap;
            this.signerMapRef = new SoftReference<Map>(this.signerMapHardRef);
            this.codeSourceCacheHardRef = hashMap2;
            this.codeSourceCacheRef = new SoftReference<Map>(this.codeSourceCacheHardRef);
            CodeSigner[] codeSignerArray = new CodeSigner[n];
            this.signersHardRef = codeSignerArray;
            this.signersRef = new SoftReference<CodeSigner[]>(this.signersHardRef);
            try {
                for (int i = 0; i < n; ++i) {
                    codeSignerArray[i] = this.newCodeSigner((CodeSigner)objectInputStream.readObject());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading code signer");
            }
            int[] nArray = null;
            URL uRL = new URL(this.url);
            if (this.hasStrictSingleSigning()) {
                nArray = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    nArray[i] = i;
                }
                CodeSource codeSource = new CodeSource(uRL, codeSignerArray);
                hashMap.put(null, nArray);
                hashMap2.put(nArray, codeSource);
                return;
            }
            String string2 = bufferedReader.readLine();
            String string3 = null;
            HashMap<String, int[]> hashMap4 = new HashMap<String, int[]>();
            while (string2 != null && !string2.equals("")) {
                String string4 = string2;
                if (string4.startsWith("/")) {
                    string4 = string3 + string4;
                } else {
                    int n3 = string4.lastIndexOf("/");
                    if (n3 != -1) {
                        string3 = string4.substring(0, n3);
                    }
                }
                string2 = bufferedReader.readLine();
                nArray = (int[])hashMap4.get(string2);
                if (nArray == null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    nArray = new int[n4];
                    for (int i = 0; i < n4; ++i) {
                        nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    hashMap4.put(string2, nArray);
                    CodeSigner[] codeSignerArray2 = new CodeSigner[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        codeSignerArray2[i] = codeSignerArray[nArray[i]];
                    }
                    CodeSource codeSource = new CodeSource(uRL, codeSignerArray2);
                    hashMap2.put(nArray, codeSource);
                }
                hashMap.put(string4, nArray);
                string2 = bufferedReader.readLine();
            }
        }
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certificateArray) throws IOException {
        try {
            int n;
            CodeSigner[] codeSignerArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<CertPath> arrayList = new ArrayList<CertPath>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < certificateArray.length) {
                Serializable serializable;
                codeSignerArray = new ArrayList();
                n = n3;
                for (n = n3; n < certificateArray.length; ++n) {
                    serializable = null;
                    Serializable serializable2 = null;
                    if (certificateArray[n] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n];
                    }
                    serializable2 = n + 1 < certificateArray.length && certificateArray[n + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n + 1] : serializable;
                    codeSignerArray.add(serializable);
                    if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                }
                n4 = n < certificateArray.length ? n + 1 : n;
                serializable = certificateFactory.generateCertPath((List<? extends Certificate>)codeSignerArray);
                codeSignerArray.clear();
                arrayList.add((CertPath)serializable);
                n3 = n4;
                ++n2;
            }
            codeSignerArray = new CodeSigner[n2];
            this.signersHardRef = codeSignerArray;
            for (n = 0; n < n2; ++n) {
                codeSignerArray[n] = new CodeSigner((CertPath)arrayList.get(n), null);
            }
            return codeSignerArray;
        }
        catch (CertificateException certificateException) {
            throw new IOException("Error process signer certificates");
        }
    }

    private CodeSigner newCodeSigner(CodeSigner codeSigner) {
        CertPath certPath = codeSigner.getSignerCertPath();
        Timestamp timestamp = codeSigner.getTimestamp();
        CodeSigner codeSigner2 = new CodeSigner(certPath, this.newTimestamp(timestamp));
        return codeSigner2;
    }

    private Timestamp newTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = timestamp.getTimestamp();
        CertPath certPath = timestamp.getSignerCertPath();
        return new Timestamp(date, certPath);
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest(RandomAccessFile randomAccessFile, JarFile jarFile, CachedManifest cachedManifest, int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        Object object5;
        JavaUtilJarAccess javaUtilJarAccess;
        URL uRL = new URL(this.url);
        CodeSource[] codeSourceArray = null;
        JavaUtilJarAccess javaUtilJarAccess2 = null;
        if (enhancedJarAccess) {
            javaUtilJarAccess = javaUtilJarAccess2 = SharedSecrets.javaUtilJarAccess();
            codeSourceArray = javaUtilJarAccess.getCodeSources(jarFile, uRL);
        }
        javaUtilJarAccess = new ArrayList();
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        Certificate[] certificateArray = null;
        CodeSigner[] codeSignerArray = null;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap4 = new HashMap<Object, Object>();
        HashMap<Object, JavaUtilJarAccess> hashMap5 = new HashMap<Object, JavaUtilJarAccess>();
        HashMap<Object, Object> hashMap6 = new HashMap<Object, Object>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[2048];
        int n2 = jarFile.size();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = null;
        int[] nArray2 = null;
        Enumeration enumeration = null;
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, n2);
        }
        if (!enhancedJarAccess) {
            enumeration = jarFile.entries();
        } else {
            Cloneable cloneable;
            object5 = javaUtilJarAccess2;
            if (BlackList.checkJarFile(jarFile)) {
                throw new JARSigningException(uRL, this.version, 5);
            }
            if (TrustedLibraries.checkJarFile(jarFile)) {
                cloneable = cachedManifest.getMainAttributes();
                ((Attributes)cloneable).putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            if (codeSourceArray != null) {
                cloneable = new ArrayList();
                for (int i = 0; i < codeSourceArray.length; ++i) {
                    if (codeSourceArray[i].getCertificates() == null) continue;
                    cloneable.add(codeSourceArray[i]);
                }
                if (cloneable.size() != codeSourceArray.length) {
                    codeSourceArray = cloneable.toArray(new CodeSource[cloneable.size()]);
                } else {
                    this.hasOnlySignedEntries = true;
                }
            }
            enumeration = object5.entryNames(jarFile, codeSourceArray);
            if (codeSourceArray != null && codeSourceArray.length == 1) {
                int n4;
                certificateArray = codeSourceArray[0].getCertificates();
                nArray = new int[certificateArray.length];
                for (n4 = 0; n4 < certificateArray.length; ++n4) {
                    javaUtilJarAccess.add(certificateArray[n4]);
                    nArray[n4] = n4;
                }
                hashMap4.put(nArray, codeSourceArray[0]);
                if (Config.isJavaVersionAtLeast15()) {
                    codeSignerArray = codeSourceArray[0].getCodeSigners();
                    nArray2 = new int[codeSignerArray.length];
                    for (n4 = 0; n4 < codeSignerArray.length; ++n4) {
                        arrayList.add(codeSignerArray[n4]);
                        nArray2[n4] = n4;
                    }
                    hashMap3.put(nArray2, codeSourceArray[0]);
                }
                this.hasSingleCodeSource = true;
            }
        }
        while (enumeration.hasMoreElements()) {
            InputStream inputStream;
            JarEntry jarEntry;
            block77: {
                ++n3;
                object5 = null;
                jarEntry = null;
                if (!enhancedJarAccess) {
                    jarEntry = enumeration.nextElement();
                    object5 = jarEntry.getName();
                    if (!bl) {
                        try {
                            bl = BlackList.checkJarEntry(jarFile, jarEntry);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new JARSigningException(new URL(this.url), this.version, 5, generalSecurityException);
                        }
                    }
                    if (!bl2) {
                        try {
                            bl2 = TrustedLibraries.checkJarEntry(jarFile, jarEntry);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            iterator = cachedManifest.getMainAttributes();
                            ((Attributes)((Object)iterator)).putValue("Trusted-Library", Boolean.TRUE.toString());
                        }
                    }
                    if (CacheEntry.isSigningRelated((String)object5) || ((String)object5).endsWith("/")) {
                        continue;
                    }
                } else {
                    object5 = (String)((Object)enumeration.nextElement());
                    jarEntry = jarFile.getJarEntry((String)object5);
                    if (jarEntry == null) {
                        this.hasMissingSignedEntries = true;
                        Trace.println("signed entry \"" + (String)object5 + "\" missing from jar " + this.url, TraceLevel.CACHE);
                    }
                }
                inputStream = null;
                int n5 = 0;
                try {
                    try {
                        if (jarEntry != null) {
                            inputStream = jarFile.getInputStream(jarEntry);
                        }
                        if (inputStream != null && DownloadEngine.isNativeContentType(n) && ((String)object5).indexOf("/") == -1 && ((String)object5).indexOf("\\") == -1 && ((File)(object4 = new File((File)(object3 = new File(this.getNativeLibPath()).getCanonicalFile()), (String)object5).getCanonicalFile())).getParentFile().equals(object3)) {
                            ((File)object4).getParentFile().mkdirs();
                            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object4));
                        }
                        if (inputStream != null) {
                            while ((n5 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                                if (filterOutputStream == null) continue;
                                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n5);
                            }
                        }
                        object2 = null;
                        if (filterOutputStream == null) break block77;
                    }
                    catch (SecurityException securityException) {
                        throw new JARSigningException(uRL, this.version, 2, securityException);
                    }
                }
                catch (Throwable throwable) {
                    object2 = null;
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                        filterOutputStream = null;
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (this.hasSingleCodeSource) {
                hashMap.put(object5, nArray);
            } else {
                if (jarEntry != null) {
                    certificateArray = jarEntry.getCertificates();
                } else {
                    object3 = javaUtilJarAccess2;
                    object4 = object3.getCodeSource(jarFile, uRL, (String)object5);
                    Certificate[] certificateArray2 = certificateArray = object4 != null ? ((CodeSource)object4).getCertificates() : null;
                }
                if (certificateArray != null && certificateArray.length > 0) {
                    object3 = new int[certificateArray.length];
                    for (int i = 0; i < certificateArray.length; ++i) {
                        int n6 = javaUtilJarAccess.indexOf(certificateArray[i]);
                        if (n6 == -1) {
                            n6 = javaUtilJarAccess.size();
                            javaUtilJarAccess.add(certificateArray[i]);
                        }
                        object3[i] = (JavaUtilJarAccess)n6;
                    }
                    object4 = String.valueOf(((JavaUtilJarAccess)object3).length);
                    for (int i = 0; i < ((JavaUtilJarAccess)object3).length; ++i) {
                        object4 = (String)object4 + " " + (int)object3[i];
                    }
                    object = (int[])hashMap6.get(object4);
                    if (object == null) {
                        hashMap6.put(object4, object3);
                        object2 = new CodeSource(uRL, certificateArray);
                        hashMap4.put(object3, object2);
                    } else {
                        object3 = object;
                    }
                    hashMap.put(object5, object3);
                }
            }
            if (Config.isJavaVersionAtLeast15()) {
                if (this.hasSingleCodeSource) {
                    hashMap2.put(object5, nArray2);
                } else {
                    if (jarEntry != null) {
                        codeSignerArray = jarEntry.getCodeSigners();
                    } else {
                        object3 = javaUtilJarAccess2;
                        object4 = object3.getCodeSource(jarFile, uRL, (String)object5);
                        CodeSigner[] codeSignerArray2 = codeSignerArray = object4 != null ? ((CodeSource)object4).getCodeSigners() : null;
                    }
                    if (codeSignerArray != null && codeSignerArray.length > 0) {
                        object3 = new int[codeSignerArray.length];
                        for (int i = 0; i < codeSignerArray.length; ++i) {
                            int n7 = arrayList.indexOf(codeSignerArray[i]);
                            if (n7 == -1) {
                                n7 = arrayList.size();
                                arrayList.add(codeSignerArray[i]);
                            }
                            object3[i] = n7;
                        }
                        object4 = String.valueOf(((JavaUtilJarAccess)object3).length);
                        for (int i = 0; i < ((Object)object3).length; ++i) {
                            object4 = (String)object4 + " " + (int)object3[i];
                        }
                        object = (int[])hashMap5.get(object4);
                        if (object == null) {
                            hashMap5.put(object4, (JavaUtilJarAccess)object3);
                            object2 = new CodeSource(uRL, codeSignerArray);
                            hashMap3.put(object3, object2);
                        } else {
                            object3 = object;
                        }
                        hashMap2.put(object5, object3);
                    }
                }
            }
            if (downloadDelegate == null || n3 % 10 != 0 && n3 < n2) continue;
            downloadDelegate.validating(uRL, n3, n2);
        }
        if (cachedManifest != null) {
            this.section3Length = cachedManifest.writeFull(byteArrayOutputStream);
            this.reducedManifest2Length = cachedManifest.writeReduced(byteArrayOutputStream);
            this.section3Length += this.reducedManifest2Length;
        } else {
            this.section3Length = 0;
            this.reducedManifest2Length = 0;
        }
        object5 = new ObjectOutputStream(byteArrayOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object5));
        if (!javaUtilJarAccess.isEmpty()) {
            ((ObjectOutputStream)object5).writeInt(javaUtilJarAccess.size());
            Iterator iterator2 = javaUtilJarAccess.iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)object5).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)object5).flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
            iterator = hashMap.keySet().iterator();
            object3 = null;
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                object = (int[])hashMap.get(object4);
                if (((String)object4).indexOf("/") != -1) {
                    object2 = ((String)object4).substring(0, ((String)object4).lastIndexOf("/"));
                    if (object3 != null && ((String)object2).equals(object3)) {
                        object4 = ((String)object4).substring(((String)object2).length());
                    }
                    object3 = object2;
                }
                bufferedWriter.write((String)object4);
                bufferedWriter.newLine();
                object2 = String.valueOf(((int[])object).length);
                for (int i = 0; i < ((int[])object).length; ++i) {
                    object2 = (String)object2 + " " + object[i];
                }
                bufferedWriter.write((String)object2, 0, ((String)object2).length());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (this.hasStrictSingleSigning()) {
                hashMap.clear();
                hashMap.put(null, nArray);
            }
        } else {
            ((ObjectOutputStream)object5).writeInt(0);
            ((ObjectOutputStream)object5).flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
        }
        this.section4Pre15Length = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
        if (!arrayList.isEmpty()) {
            Integer n8 = new Integer(arrayList.size());
            bufferedWriter.write(n8.toString());
            bufferedWriter.newLine();
            bufferedWriter.flush();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((ObjectOutputStream)object5).writeObject(iterator.next());
            }
            ((ObjectOutputStream)object5).flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
            object3 = hashMap2.keySet().iterator();
            object4 = null;
            while (object3.hasNext()) {
                String string;
                object = (String)object3.next();
                object2 = (int[])hashMap2.get(object);
                if (object.indexOf("/") != -1) {
                    string = object.substring(0, object.lastIndexOf("/"));
                    if (object4 != null && string.equals(object4)) {
                        object = object.substring(string.length());
                    }
                    object4 = string;
                }
                bufferedWriter.write((String)object);
                bufferedWriter.newLine();
                string = String.valueOf(((Object)object2).length);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    string = string + " " + (int)object2[i];
                }
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            if (this.hasStrictSingleSigning()) {
                hashMap2.clear();
                hashMap2.put(null, nArray2);
            }
        } else {
            bufferedWriter.write("0");
            bufferedWriter.newLine();
            ((ObjectOutputStream)object5).flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
        }
        bufferedWriter.flush();
        ((ObjectOutputStream)object5).flush();
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        this.section4Length = byteArrayOutputStream.size() - this.section3Length;
        if (Config.isJavaVersionAtLeast15()) {
            if (!arrayList.isEmpty()) {
                CodeSigner[] codeSignerArray3 = new CodeSigner[arrayList.size()];
                this.signersHardRef = arrayList.toArray(codeSignerArray3);
                this.signersRef = new SoftReference<CodeSigner[]>(this.signersHardRef);
                this.signerMapHardRef = hashMap2;
                this.signerMapRef = new SoftReference<Map>(this.signerMapHardRef);
                this.codeSourceCacheHardRef = hashMap3;
                this.codeSourceCacheRef = new SoftReference<Map>(this.codeSourceCacheHardRef);
                return;
            }
            this.signersHardRef = null;
            this.signersRef = null;
            this.signerMapHardRef = null;
            this.signerMapRef = null;
            this.codeSourceCacheHardRef = null;
            this.codeSourceCacheRef = null;
            return;
        }
        if (!javaUtilJarAccess.isEmpty()) {
            Certificate[] certificateArray3 = new Certificate[javaUtilJarAccess.size()];
            this.certificatesHardRef = javaUtilJarAccess.toArray(certificateArray3);
            this.certificatesRef = new SoftReference<Certificate[]>(this.certificatesHardRef);
            this.signerMapCertHardRef = hashMap;
            this.signerMapCertRef = new SoftReference<Map>(this.signerMapCertHardRef);
            this.codeSourceCertCacheHardRef = hashMap4;
            this.codeSourceCertCacheRef = new SoftReference<Map>(this.codeSourceCertCacheHardRef);
            return;
        }
        this.certificatesHardRef = null;
        this.certificatesRef = null;
        this.signerMapCertHardRef = null;
        this.signerMapCertRef = null;
        this.codeSourceCertCacheHardRef = null;
        this.codeSourceCertCacheRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeadersOld(RandomAccessFile randomAccessFile) throws IOException {
        try {
            for (int i = randomAccessFile.readInt(); i > 0; --i) {
                String string = randomAccessFile.readUTF();
                if (string.equals("deploy_resource_codebase_ip")) {
                    this.setCodebaseIP(randomAccessFile.readUTF());
                    continue;
                }
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, randomAccessFile.readUTF());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(DataInputStream dataInputStream) throws IOException {
        try {
            for (int i = dataInputStream.readInt(); i > 0; --i) {
                String string = dataInputStream.readUTF();
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, dataInputStream.readUTF());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaders(DataOutputStream dataOutputStream) throws IOException {
        try {
            if (this.headerFields == null) {
                dataOutputStream.writeInt(0);
                Object var6_2 = null;
                return;
            }
            Map map = this.headerFields.getHeaders();
            if (!map.isEmpty()) {
                dataOutputStream.writeInt(map.size());
                for (int i = 0; i < map.size(); ++i) {
                    String string = this.headerFields.getKey(i);
                    if (null == string) {
                        string = "<null>";
                    }
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF(this.headerFields.getValue(i));
                }
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
        Object var6_3 = null;
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("forceUpdate: " + this.getForceUpdate() + "\n");
        stringBuffer.append("noHref: " + this.getNoHref() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }

    static CodeSource getUnsignedCS(URL uRL) {
        return new CodeSource(uRL, (Certificate[])null);
    }

    public static boolean isSigningRelated(String string) {
        if (!(string = string.toUpperCase(Locale.ENGLISH)).startsWith(META_FILE_DIR)) {
            return false;
        }
        if ((string = string.substring(9)).indexOf(47) != -1) {
            return false;
        }
        return string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF") || string.endsWith(".EC") || string.startsWith("SIG-") || string.equals("MANIFEST.MF");
    }

    static {
        try {
            JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            javaUtilJarAccess.setEagerValidation((JarFile)null, false);
            enhancedJarAccess = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NullPointerException nullPointerException) {
            enhancedJarAccess = true;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

