/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;

public class ExtendedTableModel
extends SortableTableModel {
    private SortableTableModel realModel;
    private int[] columnsMapping;
    private boolean[] columnsVisibility;
    private int realColumnsCount;
    private int virtualColumnsCount;

    public ExtendedTableModel(SortableTableModel sortableTableModel) {
        this.virtualColumnsCount = this.realColumnsCount = sortableTableModel.getColumnCount();
        this.realModel = sortableTableModel;
        this.columnsMapping = new int[this.realColumnsCount];
        boolean[] blArray = new boolean[this.realColumnsCount];
        for (int i = 0; i < this.realColumnsCount; ++i) {
            blArray[i] = true;
        }
        this.setColumnsVisibility(blArray);
    }

    public Class getColumnClass(int n) {
        return this.realModel.getColumnClass(this.getRealColumn(n));
    }

    public int getColumnCount() {
        return this.virtualColumnsCount;
    }

    public String getColumnName(int n) {
        return this.realModel.getColumnName(this.getRealColumn(n));
    }

    public String getColumnToolTipText(int n) {
        return this.realModel.getColumnToolTipText(this.getRealColumn(n));
    }

    public void setColumnsVisibility(boolean[] blArray) {
        this.columnsVisibility = blArray;
        this.recomputeColumnsMapping();
    }

    public boolean[] getColumnsVisibility() {
        return this.columnsVisibility;
    }

    public boolean getInitialSorting(int n) {
        return this.realModel.getInitialSorting(this.getRealColumn(n));
    }

    public int getRealColumn(int n) {
        return this.columnsMapping[n];
    }

    public void setRealColumnVisibility(int n, boolean bl) {
        if (bl) {
            this.showRealColumn(n);
        } else {
            this.hideRealColumn(n);
        }
    }

    public boolean isRealColumnVisible(int n) {
        return this.columnsVisibility[n];
    }

    public int getRowCount() {
        return this.realModel.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        return this.realModel.getValueAt(n, this.getRealColumn(n2));
    }

    public int getVirtualColumn(int n) {
        for (int i = 0; i < this.virtualColumnsCount; ++i) {
            if (this.getRealColumn(i) != n) continue;
            return i;
        }
        return -1;
    }

    public void hideRealColumn(int n) {
        if (this.isRealColumnVisible(n)) {
            this.columnsVisibility[n] = false;
            this.recomputeColumnsMapping();
        }
    }

    public void showRealColumn(int n) {
        if (!this.isRealColumnVisible(n)) {
            this.columnsVisibility[n] = true;
            this.recomputeColumnsMapping();
        }
    }

    public void sortByColumn(int n, boolean bl) {
        this.realModel.sortByColumn(this.getRealColumn(n), bl);
    }

    private void recomputeColumnsMapping() {
        int n;
        this.virtualColumnsCount = 0;
        int n2 = 0;
        for (n = 0; n < this.realColumnsCount; ++n) {
            if (!this.columnsVisibility[n]) continue;
            this.columnsMapping[n2] = n;
            ++this.virtualColumnsCount;
            ++n2;
        }
        for (n = n2; n < this.realColumnsCount; ++n) {
            this.columnsMapping[n] = -1;
        }
    }
}

