/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.MethodNameTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public class ReverseCallGraphPanel
extends SnapshotCPUResultsPanel
implements ScreenshotProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String PANEL_TITLE = messages.getString("ReverseCallGraphPanel_PanelTitle");
    private static final String PANEL_TITLE_SHORT = messages.getString("ReverseCallGraphPanel_PanelTitleShort");
    private static final String ADD_ROOT_METHOD_POPUP_ITEM = messages.getString("ReverseCallGraphPanel_AddRootMethodPopupItem");
    private static final String METHOD_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_MethodColumnToolTip");
    private static final String CLASS_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_ClassColumnToolTip");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_PackageColumnToolTip");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_TimeRelColumnToolTip");
    private static final String TIME_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_TimeColumnName");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_TimeColumnToolTip");
    private static final String TIME_CPU_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_TimeCpuColumnName");
    private static final String TIME_CPU_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_TimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("ReverseCallGraphPanel_InvocationsColumnName");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("ReverseCallGraphPanel_InvocationsColumnToolTip");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("ReverseCallGraphPanel_TreeTableAccessName");
    protected JButton cornerButton;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected boolean sortOrder;
    protected int selectedMethodId;
    protected int sortingColumn;
    protected int threadId;
    private AbstractTreeTableModel abstractTreeTableModel;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ExtendedTreeTableModel treeTableModel;
    private ImageIcon leafIcon = new ImageIcon(ReverseCallGraphPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/reverseNode.png"));
    private ImageIcon nodeIcon = new ImageIcon(ReverseCallGraphPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/reverseNode.png"));
    private int minNamesColumnWidth;

    public ReverseCallGraphPanel(CPUResUserActionsHandler cPUResUserActionsHandler) {
        super(cPUResUserActionsHandler);
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        this.setDefaultSorting();
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        PrestimeCPUCCTNodeFree.setPercentFormat((NumberFormat)this.percentFormat);
        switch (n) {
            case 1: {
                exportDataDumper.dumpData(this.getCSVHeader(","));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportCSVData(",", n, exportDataDumper);
                exportDataDumper.close();
                break;
            }
            case 2: {
                exportDataDumper.dumpData(this.getCSVHeader(";"));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportCSVData(";", n, exportDataDumper);
                exportDataDumper.close();
                break;
            }
            case 3: {
                exportDataDumper.dumpData(this.getXMLHeader(string));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportXMLData(exportDataDumper, "  ");
                exportDataDumper.dumpDataAndClose(this.getXMLFooter());
                break;
            }
            case 4: {
                exportDataDumper.dumpData(this.getHTMLHeader(string));
                ((PrestimeCPUCCTNodeFree)this.abstractTreeTableModel.getRoot()).exportHTMLData(exportDataDumper, 0);
                exportDataDumper.dumpDataAndClose(this.getHTMLFooter());
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private StringBuffer getCSVHeader(String string) {
        String string2 = "\r\n";
        String string3 = "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.columnCount; ++i) {
            stringBuffer.append(string3 + this.columnNames[i] + string3 + string);
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private StringBuffer getHTMLHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        stringBuffer.append("<th>" + this.columnNames[0] + "</th><th>" + this.columnNames[1] + "</th><th>" + this.columnNames[2] + "</th><th>" + this.columnNames[3] + "</th></tr>");
        return stringBuffer;
    }

    private StringBuffer getHTMLFooter() {
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\" type=\"tree\">" + string2 + "<tree>" + string2);
        return stringBuffer;
    }

    private StringBuffer getXMLFooter() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("</tree>" + string + "</ExportedView>");
        return stringBuffer;
    }

    public int getCurrentThreadId() {
        return this.threadId;
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2) {
        super.setDataToDisplay(cPUResultsSnapshot, n2);
        this.threadId = n;
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public String getDefaultViewName() {
        return "cpu-backtraces";
    }

    public void setFindString(String string) {
        this.treeTable.setFindParameters(string, 0);
    }

    public String getFindString() {
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.treeTable.isFindStringDefined();
    }

    public void setSelectedMethodId(int n) {
        this.selectedMethodId = n;
    }

    public int getSelectedMethodId() {
        return this.selectedMethodId;
    }

    public String getSelectedMethodName() {
        String string = this.snapshot.getInstrMethodClasses(this.currentView)[this.selectedMethodId];
        if (this.currentView == 0) {
            string = string + "." + this.snapshot.getInstrMethodNames()[this.selectedMethodId] + this.snapshot.getInstrMethodSignatures()[this.selectedMethodId];
        }
        return string;
    }

    public String getSelectedMethodNameShort() {
        if (this.currentView == 0) {
            return this.snapshot.getInstrMethodNames()[this.selectedMethodId];
        }
        return this.snapshot.getInstrMethodClasses(this.currentView)[this.selectedMethodId];
    }

    public String getShortTitle() {
        return MessageFormat.format(PANEL_TITLE_SHORT, this.getSelectedMethodNameShort());
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = n;
            this.sortOrder = bl;
        }
    }

    public int getSortingColumn() {
        return this.sortingColumn;
    }

    public boolean getSortingOrder() {
        return this.sortOrder;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, this.getSelectedMethodName());
    }

    public boolean findFirst() {
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        return this.treeTable.findPrevious();
    }

    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    public void prepareResults() {
        this.initColumnsData();
        PrestimeCPUCCTNode prestimeCPUCCTNode = this.snapshot.getReverseCCT(this.threadId, this.selectedMethodId, this.currentView);
        this.initFirstColumnName();
        this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)prestimeCPUCCTNode, this.sortingColumn, this.sortOrder){

            public int getColumnCount() {
                return ReverseCallGraphPanel.this.columnCount;
            }

            public String getColumnName(int n) {
                return ReverseCallGraphPanel.this.columnNames[n];
            }

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return TreeTableModel.class;
                }
                return Object.class;
            }

            public Object getValueAt(Object object, int n) {
                if (!ReverseCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && n > 2) {
                    ++n;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                switch (n) {
                    case 0: {
                        return this.getNodeName(prestimeCPUCCTNode);
                    }
                    case 1: {
                        return this.getNodeTimeRel(prestimeCPUCCTNode);
                    }
                    case 2: {
                        return this.getNodeTime(prestimeCPUCCTNode);
                    }
                    case 3: {
                        return this.getNodeSecondaryTime(prestimeCPUCCTNode);
                    }
                    case 4: {
                        return this.getNodeInvocations(prestimeCPUCCTNode);
                    }
                }
                return null;
            }

            public String getColumnToolTipText(int n) {
                return ReverseCallGraphPanel.this.columnToolTips[n];
            }

            private String getNodeName(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return prestimeCPUCCTNode.toString();
            }

            private Float getNodeTimeRel(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return new Float(prestimeCPUCCTNode.getTotalTime0InPerCent());
            }

            private String getNodeTime(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return StringUtils.mcsTimeToString((long)prestimeCPUCCTNode.getTotalTime0()) + " ms (" + ReverseCallGraphPanel.this.percentFormat.format(prestimeCPUCCTNode.getTotalTime0InPerCent() / 100.0f) + ")";
            }

            private String getNodeSecondaryTime(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return StringUtils.mcsTimeToString((long)prestimeCPUCCTNode.getTotalTime1()) + " ms";
            }

            private Integer getNodeInvocations(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return new Integer(prestimeCPUCCTNode.getNCalls());
            }

            public void sortByColumn(int n, boolean bl) {
                ReverseCallGraphPanel.this.sortOrder = bl;
                if (!ReverseCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && n > 2) {
                    ++n;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.root;
                switch (n) {
                    case 0: {
                        prestimeCPUCCTNode.sortChildren(1, bl);
                        break;
                    }
                    case 1: {
                        prestimeCPUCCTNode.sortChildren(2, bl);
                        break;
                    }
                    case 2: {
                        prestimeCPUCCTNode.sortChildren(2, bl);
                        break;
                    }
                    case 3: {
                        prestimeCPUCCTNode.sortChildren(3, bl);
                        break;
                    }
                    case 4: {
                        prestimeCPUCCTNode.sortChildren(4, bl);
                    }
                }
            }

            public boolean getInitialSorting(int n) {
                return n == 0;
            }
        };
        this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
        if (this.columnsVisibility != null) {
            this.treeTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.treeTable = new JTreeTable(this.treeTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < ReverseCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                    int n3 = ReverseCallGraphPanel.this.treeTableModel.getRealColumn(i);
                    if (n3 == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, ReverseCallGraphPanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReverseCallGraphPanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        UIUtils.autoExpandRoot(this.treeTable.getTree(), 2);
        UIUtils.makeTreeAutoExpandable(this.treeTable.getTree(), 2);
        this.treeTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ReverseCallGraphPanel.this.treeTable.getSelectedRow()) != -1) {
                    ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(n);
                    Rectangle rectangle = ReverseCallGraphPanel.this.treeTable.getCellRect(n, 0, false);
                    ReverseCallGraphPanel.this.callGraphPopupMenu.show(keyEvent.getComponent(), rectangle.x + ReverseCallGraphPanel.this.treeTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 4) {
                    ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(ReverseCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                    if (ReverseCallGraphPanel.this.popupPath != null) {
                        ReverseCallGraphPanel.this.treeTable.getTree().setSelectionPath(ReverseCallGraphPanel.this.popupPath);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(ReverseCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                if (ReverseCallGraphPanel.this.popupPath == null) {
                    if (mouseEvent.getModifiers() == 4) {
                        ReverseCallGraphPanel.this.treeTable.getTree().clearSelection();
                    }
                } else if (mouseEvent.getModifiers() == 4) {
                    ReverseCallGraphPanel.this.callGraphPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && ReverseCallGraphPanel.this.treeTableModel.isLeaf(ReverseCallGraphPanel.this.popupPath.getPath()[ReverseCallGraphPanel.this.popupPath.getPath().length - 1])) {
                    ReverseCallGraphPanel.this.showSourceForMethod(ReverseCallGraphPanel.this.popupPath);
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ReverseCallGraphPanel.this.treeTable.getSelectedRow();
                if (n == -1) {
                    return;
                }
                ReverseCallGraphPanel.this.popupPath = ReverseCallGraphPanel.this.treeTable.getTree().getPathForRow(n);
            }
        });
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.add((Component)this.treeTablePanel, "Center");
    }

    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReverseCallGraphPanel.this.treeTable.requestFocus();
                }
            });
        }
    }

    public void reset() {
        if (this.treeTablePanel != null) {
            this.remove(this.treeTablePanel);
            this.treeTablePanel = null;
        }
        this.treeTable = null;
        this.abstractTreeTableModel = null;
        this.treeTableModel = null;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReverseCallGraphPanel.this.menuActionPerformed(actionEvent);
            }
        };
        return jPopupMenu;
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(new Integer(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.treeTable != null) {
                jCheckBoxMenuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                boolean bl2 = ReverseCallGraphPanel.this.treeTable.getSortingOrder();
                int n2 = ReverseCallGraphPanel.this.treeTable.getSortingColumn();
                int n3 = ReverseCallGraphPanel.this.treeTableModel.getRealColumn(n2);
                boolean bl3 = ReverseCallGraphPanel.this.treeTableModel.isRealColumnVisible(n);
                if (bl3 && n == n3) {
                    n2 = n2 + 1 == ReverseCallGraphPanel.this.treeTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
                    n3 = ReverseCallGraphPanel.this.treeTableModel.getRealColumn(n2);
                    bl = true;
                }
                ReverseCallGraphPanel.this.treeTableModel.setRealColumnVisibility(n, !bl3);
                ReverseCallGraphPanel.this.treeTable.createDefaultColumnsFromModel();
                ReverseCallGraphPanel.this.treeTable.updateTreeTableHeader();
                n2 = ReverseCallGraphPanel.this.treeTableModel.getVirtualColumn(n3);
                if (bl) {
                    bl2 = ReverseCallGraphPanel.this.treeTableModel.getInitialSorting(n2);
                    ReverseCallGraphPanel.this.treeTableModel.sortByColumn(n2, bl2);
                    ReverseCallGraphPanel.this.treeTable.updateTreeTable();
                }
                ReverseCallGraphPanel.this.treeTable.setSortingColumn(n2);
                ReverseCallGraphPanel.this.treeTable.setSortingOrder(bl2);
                ReverseCallGraphPanel.this.treeTable.getTableHeader().repaint();
                ReverseCallGraphPanel.this.setColumnsData();
            }
        });
    }

    private void initColumnsData() {
        this.columnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnsVisibility = null;
        if (this.columnCount == 5) {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, TIME_CPU_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, TIME_CPU_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        } else {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        }
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = n;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
            }
        }
    }
}

