/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.LivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.StringUtils;

public class LiveLivenessResultsPanel
extends LivenessResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_LiveShowStackTracesPopupItemName");
    private static final String STOP_CLASS_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopClassPopupItemName");
    private static final String STOP_BELOW_LINE_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopBelowLinePopupItemName");
    private static final String STOP_CLASS_SPEC_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopClassSpecPopupItemName");
    private static final String STOP_BELOW_LINE_SPEC_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopBelowLineSpecPopupItemName");
    private static final String LOG_CLASS_HISTORY = messages.getString("LiveResultsPanel_LogClassHistory");
    protected TargetAppRunner runner;
    private ClassHistoryActionsHandler historyActionsHandler;
    private ClassHistoryDataManager classHistoryManager;
    private JMenuItem popupRemoveProfForClass;
    private JMenuItem popupRemoveProfForClassesBelow;
    private JMenuItem popupShowStacks;
    private JMenuItem startHisto;
    private JPopupMenu popup;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveLivenessResultsPanel(TargetAppRunner targetAppRunner, MemoryResUserActionsHandler memoryResUserActionsHandler, ClassHistoryActionsHandler classHistoryActionsHandler, ClassHistoryDataManager classHistoryDataManager) {
        super(memoryResUserActionsHandler);
        this.runner = targetAppRunner;
        this.status = targetAppRunner.getProfilerClient().getStatus();
        this.historyActionsHandler = classHistoryActionsHandler;
        this.classHistoryManager = classHistoryDataManager;
        this.initColumnsData();
    }

    public BufferedImage getViewImage(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public String getViewName() {
        return "memory-liveness-live";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.popupRemoveProfForClass) {
            MemoryCCTProvider memoryCCTProvider = this.runner.getProfilerClient().getMemoryCCTProvider();
            boolean[] blArray = new boolean[this.sortedClassIds.length];
            int n = (Integer)this.filteredToFullIndexes.get(this.clickedLine);
            if (!memoryCCTProvider.classMarkedUnprofiled(this.sortedClassIds[n])) {
                memoryCCTProvider.markClassUnprofiled(this.sortedClassIds[n]);
                blArray[this.sortedClassIds[n]] = true;
                if (n < this.nTrackedAllocObjects.length) {
                    this.nTrackedAllocObjects[n] = 0L;
                    this.nTrackedLiveObjects[n] = 0;
                    this.trackedLiveObjectsSize[n] = 0L;
                    this.avgObjectAge[n] = 0.0f;
                    this.maxSurvGen[n] = 0;
                }
                this.nTotalAllocObjects[n] = 0;
                this.deinstrumentMemoryProfiledClasses(blArray);
            }
            this.prepareResults();
        } else if (object == this.popupRemoveProfForClassesBelow) {
            int n = this.clickedLine;
            MemoryCCTProvider memoryCCTProvider = this.runner.getProfilerClient().getMemoryCCTProvider();
            boolean[] blArray = new boolean[this.sortedClassIds.length];
            int n2 = this.filteredToFullIndexes.size();
            for (int i = n + 1; i < n2; ++i) {
                int n3 = (Integer)this.filteredToFullIndexes.get(i);
                if (memoryCCTProvider.classMarkedUnprofiled(this.sortedClassIds[n3])) continue;
                memoryCCTProvider.markClassUnprofiled(this.sortedClassIds[n3]);
                blArray[this.sortedClassIds[n3]] = true;
                this.nTrackedAllocObjects[n3] = 0L;
                this.nTrackedLiveObjects[n3] = 0;
                this.trackedLiveObjectsSize[n3] = 0L;
                this.avgObjectAge[n3] = 0.0f;
                this.maxSurvGen[n3] = 0;
                this.nTotalAllocObjects[n3] = 0;
            }
            this.deinstrumentMemoryProfiledClasses(blArray);
            this.prepareResults();
        } else if (object == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (actionEvent.getSource() == this.startHisto) {
            String string = StringUtils.userFormClassName((String)this.getClassName(this.selectedClassId));
            this.historyActionsHandler.showClassHistory(this.selectedClassId, string);
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        int n;
        MemoryCCTProvider memoryCCTProvider = this.runner.getProfilerClient().getMemoryCCTProvider();
        if (memoryCCTProvider == null) {
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        MemoryCCTProvider.ObjectNumbersContainer objectNumbersContainer = memoryCCTProvider.getLivenessObjectNumbers();
        this.nTrackedAllocObjects = objectNumbersContainer.nTrackedAllocObjects;
        this.nTrackedLiveObjects = objectNumbersContainer.nTrackedLiveObjects;
        this.trackedLiveObjectsSize = objectNumbersContainer.trackedLiveObjectsSize;
        this.avgObjectAge = objectNumbersContainer.avgObjectAge;
        this.maxSurvGen = objectNumbersContainer.maxSurvGen;
        this.nInstrClasses = objectNumbersContainer.nInstrClasses;
        if (this.nTrackedLiveObjects == null && this.nTrackedAllocObjects == null || this.avgObjectAge == null || this.maxSurvGen == null) {
            return;
        }
        this.nTotalAllocObjects = this.runner.getProfilerClient().getAllocatedObjectsCountResults();
        this.nTrackedItems = Math.min(this.nTrackedAllocObjects.length, this.nTrackedLiveObjects.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.trackedLiveObjectsSize.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.avgObjectAge.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.maxSurvGen.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nInstrClasses);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nTotalAllocObjects.length);
        for (n = 0; n < this.nTrackedItems; ++n) {
            if (this.nTrackedAllocObjects[n] != -1L) continue;
            this.nTotalAllocObjects[n] = 0;
        }
        this.maxValue = 0L;
        this.nTotalTrackedBytes = 0L;
        this.nTotalTracked = 0L;
        for (n = 0; n < this.nTrackedItems; ++n) {
            if (this.maxValue < this.trackedLiveObjectsSize[n]) {
                this.maxValue = this.trackedLiveObjectsSize[n];
            }
            this.nTotalTrackedBytes += this.trackedLiveObjectsSize[n];
            this.nTotalTracked += (long)this.nTrackedLiveObjects[n];
        }
        if (this.classHistoryManager.isTrackingClass()) {
            this.classHistoryManager.processData(this.nTotalAllocObjects, this.nTrackedLiveObjects, this.trackedLiveObjectsSize);
        }
        this.initDataUponResultsFetch();
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    public void handleRemove() {
    }

    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasView() {
        return this.resTable != null;
    }

    public boolean supports(int n) {
        return n == 5;
    }

    public void updateLiveResults() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String string = null;
        if (this.resTable != null) {
            int n = this.resTable.getSelectedRow();
            if (n >= this.resTable.getRowCount()) {
                n = -1;
                this.resTable.clearSelection();
            }
            if (n != -1) {
                string = this.resTable.getValueAt(n, 0).toString();
            }
        }
        try {
            if (this.runner.getProfilingSessionStatus().targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (string != null) {
                this.resTable.selectRowByContents(string, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            targetAppOrVMTerminated.printStackTrace(System.err);
        }
        this.updateResultsInProgress = false;
    }

    protected String getClassName(int n) {
        return this.status.getClassNames()[n];
    }

    protected String[] getClassNames() {
        return this.status.getClassNames();
    }

    protected int getPercentsTracked() {
        return 100 / this.runner.getProfilerEngineSettings().getAllocTrackEvery();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            Font font = this.popup.getFont().deriveFont(1);
            this.popupRemoveProfForClass = new JMenuItem();
            this.popupRemoveProfForClassesBelow = new JMenuItem();
            this.popupRemoveProfForClass.setText(STOP_CLASS_POPUP_ITEM_NAME);
            this.popupRemoveProfForClassesBelow.setText(STOP_BELOW_LINE_POPUP_ITEM_NAME);
            if (this.runner.getProfilerEngineSettings().getAllocStackTraceLimit() != 0) {
                this.popup.addSeparator();
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.popup.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
            }
            this.popup.addSeparator();
            this.popup.add(this.popupRemoveProfForClass);
            this.popup.add(this.popupRemoveProfForClassesBelow);
            this.popupRemoveProfForClass.addActionListener(this);
            this.popupRemoveProfForClassesBelow.addActionListener(this);
            this.popup.addSeparator();
            this.startHisto = new JMenuItem();
            this.startHisto.setText(LOG_CLASS_HISTORY);
            this.popup.add(this.startHisto);
            this.startHisto.addActionListener(this);
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (LiveLivenessResultsPanel.this.updateResultsPending) {
                                LiveLivenessResultsPanel.this.updateLiveResults();
                                LiveLivenessResultsPanel.this.updateResultsPending = false;
                            }
                        }
                    });
                }
            });
        }
        boolean bl = this.status.targetAppRunning;
        if (this.popupShowStacks != null) {
            this.popupShowStacks.setEnabled(bl);
        }
        this.popupRemoveProfForClass.setEnabled(bl);
        this.popupRemoveProfForClassesBelow.setEnabled(bl);
        this.startHisto.setEnabled(bl);
        return this.popup;
    }

    protected void adjustFramePopupMenuTextIfNecessary() {
        String string = this.sortedClassNames[this.clickedLine];
        this.popupRemoveProfForClass.setText(MessageFormat.format(STOP_CLASS_SPEC_POPUP_ITEM_NAME, string));
        this.popupRemoveProfForClassesBelow.setText(MessageFormat.format(STOP_BELOW_LINE_SPEC_POPUP_ITEM_NAME, string));
    }

    protected void performDefaultAction(int n) {
    }

    private void deinstrumentMemoryProfiledClasses(boolean[] blArray) {
        try {
            this.runner.getProfilerClient().deinstrumentMemoryProfiledClasses(blArray);
        }
        catch (InstrumentationException instrumentationException) {
            this.runner.getAppStatusHandler().displayError(instrumentationException.getMessage());
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            this.runner.getAppStatusHandler().displayError(targetAppOrVMTerminated.getMessage());
        }
    }
}

