/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;

public class ThreadStateCellRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private Color unselectedBackground;
    private Color unselectedForeground;
    private ThreadData threadData;
    private ThreadsPanel viewManager;
    private long dataEnd;
    private long dataStart;
    private long viewEnd;
    private long viewStart;

    public ThreadStateCellRenderer(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.isFocusOwner() ? jTable.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            super.setBackground(jTable.isFocusOwner() ? jTable.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if ((n & 1) == 0) {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(UIUtils.getDarker(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground()));
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        if (object instanceof ThreadData) {
            this.threadData = (ThreadData)object;
        }
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.dataEnd = this.viewManager.getDataEnd();
        return this;
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        this.paintTimeMarks(graphics);
        if (this.threadData != null && (n = this.getFirstVisibleDataUnit()) != -1) {
            int n2 = this.getWidth();
            if (this.viewEnd - this.viewStart > 0L) {
                float f = (float)n2 / (float)(this.viewEnd - this.viewStart);
                while (n < this.threadData.size() && this.threadData.getTimeStampAt(n) <= this.viewEnd) {
                    if (this.threadData.getStateAt(n) != 0) {
                        this.paintThreadState(graphics, n, this.threadData.getThreadStateColorAt(n), f, n2);
                    }
                    ++n;
                }
            }
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void revalidate() {
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public void validate() {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    private boolean isFinishedDataUnit(int n) {
        return this.threadData.getStateAt(n) == 0;
    }

    private int getFirstVisibleDataUnit() {
        for (int i = 0; i < this.threadData.size(); ++i) {
            long l = this.threadData.getTimeStampAt(i);
            if (l <= this.viewEnd && i == this.threadData.size() - 1) {
                return i;
            }
            if (!(l <= this.viewStart ? this.threadData.getTimeStampAt(i + 1) > this.viewStart : l <= this.viewEnd)) continue;
            return i;
        }
        return -1;
    }

    private boolean isLastDataUnit(int n) {
        return n == this.threadData.size() - 1;
    }

    private void paintThreadState(Graphics graphics, int n, Color color, float f, int n2) {
        int n3 = Math.max((int)((float)(this.threadData.getTimeStampAt(n) - this.viewStart) * f), 0);
        int n4 = n < this.threadData.size() - 1 ? Math.min((int)((float)(this.threadData.getTimeStampAt(n + 1) - this.viewStart) * f), n2) : Math.min((int)((float)(this.dataEnd - this.viewStart) * f), n2 + 1);
        graphics.setColor(color);
        graphics.fillRect(n3, 6, n4 - n3, this.getHeight() - 12);
    }

    private void paintTimeMarks(Graphics graphics) {
        if (this.viewEnd - this.viewStart > 0L) {
            int n = (int)(this.viewStart - this.dataStart);
            int n2 = (int)(this.viewEnd - this.dataStart);
            float f = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int n3 = TimeLineUtils.getOptimalUnits(f);
            int n4 = Math.max((int)(Math.ceil((double)n / (double)n3) * (double)n3), 0);
            for (int i = n4 - n3; i <= n2 + n3; i += n3) {
                if (i < 0) continue;
                float f2 = i - n;
                int n5 = (int)(f2 * f);
                this.paintTimeTicks(graphics, (int)(f2 * f), (int)((f2 + (float)n3) * f), TimeLineUtils.getTicksCount(n3));
                graphics.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                graphics.drawLine(n5, 0, n5, this.getHeight() - 1);
            }
        }
    }

    private void paintTimeTicks(Graphics graphics, int n, int n2, int n3) {
        float f = (float)(n2 - n) / (float)n3;
        graphics.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < n3; ++i) {
            int n4 = n + (int)((float)i * f);
            graphics.drawLine(n4, 0, n4, this.getHeight() - 1);
        }
    }
}

