/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeymapModel {
    private static final Logger LOG = Logger.getLogger(KeymapModel.class.getName());
    private static final Logger UI_LOG = Logger.getLogger("org.netbeans.ui.options");
    private static ArrayList<KeymapManager> al = new ArrayList();
    private Map<String, Set<ShortcutAction>> categoryToActions = new HashMap<String, Set<ShortcutAction>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keyMaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keyMapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<ShortcutAction, CompoundAction> sharedActions = new HashMap<ShortcutAction, CompoundAction>();
    private Map<String, String> profilesMap;

    public static Collection<? extends KeymapManager> getKeymapManagerInstances() {
        if (!al.isEmpty()) {
            return al;
        }
        al.addAll(Lookup.getDefault().lookupAll(KeymapManager.class));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Dumping registered KeymapManagers: ");
            for (KeymapManager keymapManager : al) {
                LOG.fine("    KeymapManager: " + KeymapModel.s2s(keymapManager));
            }
            LOG.fine("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        return al;
    }

    public Set<String> getActionCategories() {
        HashSet<String> hashSet = new HashSet<String>();
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            hashSet.addAll(keymapManager.getActions().keySet());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<ShortcutAction> getActions(String string) {
        if (!this.categoryToActions.containsKey(string)) {
            Set<ShortcutAction> set = new HashSet<ShortcutAction>();
            for (KeymapManager object : KeymapModel.getKeymapManagerInstances()) {
                Set<ShortcutAction> set2 = object.getActions().get(string);
                if (set2 == null) continue;
                set = this.mergeActions(set, set2, object.getName());
            }
            this.categoryToActions.put(string, set);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Category '" + string + "' actions (" + set.size() + "), KeymapModel=" + this + ":");
                for (ShortcutAction shortcutAction : set) {
                    LOG.fine("    id='" + shortcutAction.getId() + "', did='" + shortcutAction.getDelegatingActionId() + ", " + KeymapModel.s2s(shortcutAction));
                }
                LOG.fine("---------------------------");
            }
        }
        return this.categoryToActions.get(string);
    }

    public void refreshActions() {
        this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
        this.sharedActions = new HashMap<ShortcutAction, CompoundAction>();
        this.keyMaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.keyMapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.refreshActions();
        }
    }

    public String getCurrentProfile() {
        String string = null;
        for (KeymapManager object : KeymapModel.getKeymapManagerInstances()) {
            String string2 = object.getCurrentProfile();
            if (string2 == null) continue;
            string = string2;
            break;
        }
        if (string == null) {
            string = "NetBeans";
        }
        Map<String, String> map = this.getProfilesMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getValue()).equals(string)) continue;
            return (String)entry.getKey();
        }
        return string;
    }

    public void setCurrentProfile(String string) {
        String string2 = this.getCurrentProfile();
        if (!string2.equals(string)) {
            LogRecord logRecord = new LogRecord(Level.CONFIG, "KEYMAP_SET_PROFILE");
            logRecord.setParameters(new Object[]{string, string2});
            logRecord.setResourceBundle(NbBundle.getBundle(KeymapModel.class));
            logRecord.setResourceBundleName(KeymapModel.class.getPackage().getName() + ".Bundle");
            logRecord.setLoggerName(UI_LOG.getName());
            UI_LOG.log(logRecord);
        }
        string = this.displayNameToName(string);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.setCurrentProfile(string);
        }
    }

    public List<String> getProfiles() {
        return new ArrayList<String>(this.getProfilesMap().keySet());
    }

    public boolean isCustomProfile(String string) {
        string = this.displayNameToName(string);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            boolean bl = keymapManager.isCustomProfile(string);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        if (!this.keyMaps.containsKey(string = this.displayNameToName(string))) {
            this.ensureActionsLoaded();
            Map<ShortcutAction, Set<String>> map = new HashMap<ShortcutAction, Set<String>>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> map2 = keymapManager.getKeymap(string);
                map = this.mergeShortcuts(map, map2);
            }
            this.keyMaps.put(string, map);
        }
        return this.keyMaps.get(string);
    }

    public Map<ShortcutAction, Set<String>> getKeymapDefaults(String string) {
        if (!this.keyMapDefaults.containsKey(string = this.displayNameToName(string))) {
            this.ensureActionsLoaded();
            Map<ShortcutAction, Set<String>> map = new HashMap<ShortcutAction, Set<String>>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> map2 = keymapManager.getDefaultKeymap(string);
                map = this.mergeShortcuts(map, map2);
            }
            this.keyMapDefaults.put(string, map);
        }
        return this.keyMapDefaults.get(string);
    }

    public void deleteProfile(String string) {
        string = this.displayNameToName(string);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.deleteProfile(string);
        }
    }

    public void changeKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        string = this.displayNameToName(string);
        this.log("changeKeymap.actionToShortcuts", map.entrySet());
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>(this.getKeymap(string));
        hashMap.putAll(map);
        this.keyMaps.put(string, hashMap);
        this.log("changeKeymap.m", hashMap.entrySet());
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.saveKeymap(string, hashMap);
        }
    }

    private void log(String string, Collection collection) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        LOG.fine(string);
        for (Object e : collection) {
            LOG.fine("  " + e);
        }
    }

    Set<ShortcutAction> mergeActions(Collection<ShortcutAction> collection, Collection<ShortcutAction> collection2, String string) {
        Object object;
        String string2;
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        HashMap<String, ShortcutAction> hashMap = new HashMap<String, ShortcutAction>();
        HashMap<String, ShortcutAction> hashMap2 = new HashMap<String, ShortcutAction>();
        for (ShortcutAction shortcutAction : collection) {
            string2 = shortcutAction.getId();
            hashMap.put(string2, shortcutAction);
            object = shortcutAction.getDelegatingActionId();
            if (object == null) continue;
            hashMap2.put((String)object, shortcutAction);
        }
        for (ShortcutAction shortcutAction : collection2) {
            Object object2;
            Object object3;
            Object object4;
            string2 = shortcutAction.getId();
            if (hashMap2.containsKey(string2)) {
                object = (ShortcutAction)hashMap2.remove(string2);
                hashMap.remove(object.getId());
                object4 = this.findOriginator((ShortcutAction)object);
                object3 = new HashMap();
                object3.put(((KeymapManager)object4).getName(), object);
                object3.put(string, shortcutAction);
                object2 = new CompoundAction((Map<String, ShortcutAction>)object3);
                hashSet.add((ShortcutAction)object2);
                this.sharedActions.put((ShortcutAction)object, (CompoundAction)object2);
                this.sharedActions.put(shortcutAction, (CompoundAction)object2);
                hashSet.add((ShortcutAction)object2);
            }
            if (hashMap.containsKey(object = shortcutAction.getDelegatingActionId())) {
                object4 = (ShortcutAction)hashMap.remove(object);
                object3 = this.findOriginator((ShortcutAction)object4);
                object2 = new HashMap<String, Object>();
                object2.put(((KeymapManager)object3).getName(), object4);
                object2.put(string, shortcutAction);
                CompoundAction compoundAction = new CompoundAction((Map<String, ShortcutAction>)object2);
                hashSet.add(compoundAction);
                this.sharedActions.put((ShortcutAction)object4, compoundAction);
                this.sharedActions.put(shortcutAction, compoundAction);
                hashSet.add(compoundAction);
            }
            if (this.sharedActions.containsKey(shortcutAction)) continue;
            hashSet.add(shortcutAction);
        }
        hashSet.addAll(hashMap.values());
        return hashSet;
    }

    private KeymapManager findOriginator(ShortcutAction shortcutAction) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            if (shortcutAction.getKeymapManagerInstance(keymapManager.getName()) == null) continue;
            return keymapManager;
        }
        return null;
    }

    private Map<ShortcutAction, Set<String>> mergeShortcuts(Map<ShortcutAction, Set<String>> map, Map<ShortcutAction, Set<String>> map2) {
        for (ShortcutAction shortcutAction : map2.keySet()) {
            Set<String> set = map2.get(shortcutAction);
            if (set.isEmpty()) continue;
            if (this.sharedActions.containsKey(shortcutAction)) {
                shortcutAction = this.sharedActions.get(shortcutAction);
            }
            map.put(shortcutAction, set);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Action='" + shortcutAction.getId() + "' (" + KeymapModel.s2s(shortcutAction) + ") shortcuts: " + set);
        }
        return map;
    }

    private void ensureActionsLoaded() {
        for (String string : this.getActionCategories()) {
            this.getActions(string);
        }
    }

    private String displayNameToName(String string) {
        String string2 = this.getProfilesMap().get(string);
        return string2 == null ? string : string2;
    }

    private Map<String, String> getProfilesMap() {
        if (this.profilesMap == null) {
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                List<String> list = keymapManager.getProfiles();
                if (list == null) continue;
                this.profilesMap = new HashMap<String, String>();
                for (String string : list) {
                    this.profilesMap.put(keymapManager.getProfileDisplayName(string), string);
                }
            }
        }
        return this.profilesMap;
    }

    public KeymapModel() {
        Iterator<String> iterator = this.getActionCategories().iterator();
        while (iterator.hasNext()) {
            this.getActions(iterator.next());
        }
    }

    private static String s2s(Object object) {
        return object == null ? "null" : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }
}

