/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActiveQueue
extends ReferenceQueue<Object>
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName().replace('$', '.'));
    private static ActiveQueue activeReferenceQueue;
    private int count;
    private boolean deprecated;

    ActiveQueue(boolean bl) {
        this.deprecated = bl;
    }

    public static synchronized ReferenceQueue<Object> queue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new ActiveQueue(false);
        }
        activeReferenceQueue.ping();
        return activeReferenceQueue;
    }

    @Override
    public Reference<Object> poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference<Object> remove(long l) throws IllegalArgumentException, InterruptedException {
        throw new InterruptedException();
    }

    @Override
    public Reference<Object> remove() throws InterruptedException {
        throw new InterruptedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            try {
                while (true) {
                    object = super.remove(0L);
                    LOGGER.finer("dequeued reference");
                    if (object instanceof Runnable) break;
                    LOGGER.warning("A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): " + object.getClass());
                }
                if (this.deprecated) {
                    LOGGER.warning("Utilities.ACTIVE_REFERENCE_QUEUE has been deprecated for " + object.getClass() + " use Utilities.activeReferenceQueue");
                }
                try {
                    ((Runnable)object).run();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, null, throwable);
                }
                finally {
                    object = null;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            object = this;
            synchronized (object) {
                assert (this.count > 0);
                --this.count;
                if (this.count == 0) {
                    LOGGER.fine("stopping thread");
                    break;
                }
            }
        }
    }

    synchronized void ping() {
        if (this.count == 0) {
            Thread thread = new Thread((Runnable)this, "Active Reference Queue Daemon");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
            LOGGER.fine("starting thread");
        } else {
            LOGGER.finer("enqueuing reference");
        }
        ++this.count;
    }
}

