/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.jnlp.DownloadService2;

public class DownloadService2Impl
implements DownloadService2 {
    private static DownloadService2Impl instance;
    private static ResourceSpecAccess resourceSpecAccess;

    public static synchronized DownloadService2 getInstance() {
        if (instance == null) {
            instance = new DownloadService2Impl();
        }
        return instance;
    }

    public static void setResourceSpecAccess(ResourceSpecAccess resourceSpecAccess) {
        DownloadService2Impl.resourceSpecAccess = resourceSpecAccess;
    }

    private DownloadService2Impl() {
    }

    public DownloadService2.ResourceSpec[] getCachedResources(final DownloadService2.ResourceSpec resourceSpec) {
        this.validateResourceSpec(resourceSpec);
        final ArrayList arrayList = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DownloadService2Impl.this.getCachedResourcesImpl(resourceSpec, arrayList);
                return null;
            }
        });
        return arrayList.toArray(new DownloadService2.ResourceSpec[arrayList.size()]);
    }

    private void getCachedResourcesImpl(DownloadService2.ResourceSpec resourceSpec, ArrayList arrayList) {
        File[] fileArray = Cache.getCacheEntries((boolean)false);
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)fileArray[i]);
            if (!this.matches(cacheEntry, resourceSpec)) continue;
            arrayList.add(this.toResourceSpec(cacheEntry));
        }
    }

    private boolean matches(CacheEntry cacheEntry, DownloadService2.ResourceSpec resourceSpec) {
        boolean bl = false;
        String string = resourceSpec.getUrl();
        if (string != null && cacheEntry != null) {
            String string2 = resourceSpec.getVersion();
            String string3 = cacheEntry.getVersion();
            int n = resourceSpec.getType();
            boolean bl2 = n == 0 || n == this.getResourceType(cacheEntry);
            boolean bl3 = string2 == null && string3 == null || string2 != null && string3 != null && this.stringMatch(string3, string2);
            bl = this.stringMatch(cacheEntry.getURL(), string) && bl3 && bl2;
        }
        return bl;
    }

    private DownloadService2.ResourceSpec toResourceSpec(CacheEntry cacheEntry) {
        DownloadService2.ResourceSpec resourceSpec = new DownloadService2.ResourceSpec(cacheEntry.getURL(), cacheEntry.getVersion(), this.getResourceType(cacheEntry));
        resourceSpecAccess.setSize(resourceSpec, cacheEntry.getSize());
        resourceSpecAccess.setLastModified(resourceSpec, cacheEntry.getLastModified());
        resourceSpecAccess.setExpirationDate(resourceSpec, cacheEntry.getExpirationDate());
        return resourceSpec;
    }

    private int getResourceType(CacheEntry cacheEntry) {
        String string = cacheEntry.getURL();
        String string2 = this.getLowerNameExtension(string);
        int n = 0;
        if (cacheEntry.isJNLPFile()) {
            try {
                URL uRL = new URL(string);
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), URLUtil.getBase((URL)uRL), null, uRL);
                if (launchDesc.isApplication()) {
                    n = 1;
                } else if (launchDesc.isApplet()) {
                    n = 2;
                } else if (launchDesc.isInstaller() || launchDesc.isLibrary()) {
                    n = 3;
                }
            }
            catch (Exception exception) {}
        } else if (cacheEntry.isJarFile(cacheEntry.getDataFile().getAbsolutePath())) {
            n = 4;
        } else if (string2.endsWith("png") || string2.endsWith("gif") || string2.endsWith("jpeg") || string2.endsWith("jpg") || string2.endsWith("ico")) {
            n = 5;
        } else if (string2.endsWith("class")) {
            n = 6;
        }
        return n;
    }

    private String getLowerNameExtension(String string) {
        if (string.indexOf(63) != -1) {
            string = string.substring(0, string.indexOf(63));
        }
        while (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        string = string.toLowerCase();
        return string;
    }

    public DownloadService2.ResourceSpec[] getUpdateAvailableResources(DownloadService2.ResourceSpec resourceSpec) {
        this.validateResourceSpec(resourceSpec);
        DownloadService2.ResourceSpec[] resourceSpecArray = this.getCachedResources(resourceSpec);
        ArrayList<DownloadService2.ResourceSpec> arrayList = new ArrayList<DownloadService2.ResourceSpec>();
        for (int i = 0; i < resourceSpecArray.length; ++i) {
            URL uRL;
            DownloadService2.ResourceSpec resourceSpec2 = resourceSpecArray[i];
            try {
                uRL = new URL(resourceSpec2.getUrl());
            }
            catch (MalformedURLException malformedURLException) {
                InternalError internalError = new InternalError();
                internalError.initCause(malformedURLException);
                throw internalError;
            }
            try {
                if (resourceSpec2.getVersion() == null) {
                    if (!DownloadEngine.isUpdateAvailable((URL)uRL, null)) continue;
                    arrayList.add(resourceSpec2);
                    continue;
                }
                String string = DownloadEngine.getAvailableVersion((URL)uRL, (String)"0+", (boolean)false, null);
                if (DownloadEngine.isResourceCached((URL)uRL, null, (String)string)) continue;
                arrayList.add(resourceSpec2);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DownloadService2.ResourceSpec[] resourceSpecArray2 = new DownloadService2.ResourceSpec[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            resourceSpecArray2[i] = (DownloadService2.ResourceSpec)arrayList.get(i);
        }
        return resourceSpecArray2;
    }

    private void validateResourceSpec(DownloadService2.ResourceSpec resourceSpec) {
        String string = resourceSpec.getUrl();
        int n = resourceSpec.getType();
        if (string == null) {
            throw new IllegalArgumentException("ResourceSpec has null url");
        }
        if (string == "") {
            throw new IllegalArgumentException("ResourceSpec has empty url");
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("ResourceSpec has invalue type");
        }
    }

    private boolean stringMatch(String string, String string2) {
        if (Config.isJavaVersionAtLeast14()) {
            return string.matches(string2);
        }
        return string.equals(string2);
    }

    public static interface ResourceSpecAccess {
        public void setSize(DownloadService2.ResourceSpec var1, long var2);

        public void setLastModified(DownloadService2.ResourceSpec var1, long var2);

        public void setExpirationDate(DownloadService2.ResourceSpec var1, long var2);
    }
}

