/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ExportAction
extends AbstractAction {
    private static final String EXPORT_ACTION_NAME = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportActionName");
    private static final String EXPORT_ACTION_DESCRIPTION = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportActionDescr");
    private static final String OVERWRITE_FILE_CAPTION = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OverwriteFileCaption");
    private static final String OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OverwriteFileMsg");
    private static final String CANNOT_OVERWRITE_FILE_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_CannotOverwriteFileMsg");
    private static final String EXPORT_DIALOG_TITLE = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogTitle");
    private static final String EXPORT_DIALOG_BUTTON = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogButton");
    private static final String EXPORT_DIALOG_CSV_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogCSVFilter");
    private static final String EXPORT_DIALOG_EXCEL_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogExcelFilter");
    private static final String EXPORT_DIALOG_XML_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogXMLFilter");
    private static final String EXPORT_DIALOG_HTML_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogHTMLFilter");
    private static final String EXPORT_DIALOG_NPS_FILTER = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportDialogNPSFilter");
    private static final String NO_VIEW_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_NoViewMsg");
    private static final String EXPORTING_VIEW_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_ExportingViewMsg");
    private static final String OOME_EXPORTING_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_OomeExportingMsg");
    private static final String IOEXCEPTION_EXPORTING_MSG = NbBundle.getMessage(ExportAction.class, (String)"ExportAction_IOException_Exporting_Msg");
    private static final String SNAPSHOT_CREATE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateFailedMsg");
    private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/export.png", (boolean)false);
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_XML = "xml";
    private static final String FILE_EXTENSION_HTML = "html";
    private static final String FILE_EXTENSION_NPS = "nps";
    public static final int MODE_CSV = 1;
    public static final int MODE_EXCEL = 2;
    public static final int MODE_XML = 3;
    public static final int MODE_HTML = 4;
    public static final int MODE_NPS = 5;
    private static File exportDir;
    private JFileChooser fileChooser;
    private ExportProvider exportProvider;
    private int exportedFileType;
    private LoadedSnapshot snapshot;

    public ExportAction(ExportProvider exportProvider, LoadedSnapshot loadedSnapshot) {
        this.putValue("Name", EXPORT_ACTION_NAME);
        this.putValue("ShortDescription", EXPORT_ACTION_DESCRIPTION);
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", "org/netbeans/modules/profiler/resources/export.png");
        this.exportProvider = exportProvider;
        if (loadedSnapshot != null) {
            this.snapshot = loadedSnapshot;
        }
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasExportableView()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_XML);
                }

                public String getDescription() {
                    return EXPORT_DIALOG_XML_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_HTML);
                }

                public String getDescription() {
                    return EXPORT_DIALOG_HTML_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_CSV);
                }

                public String getDescription() {
                    return EXPORT_DIALOG_EXCEL_FILTER;
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_CSV);
                }

                public String getDescription() {
                    return EXPORT_DIALOG_CSV_FILTER;
                }
            });
        }
        if (this.exportProvider.hasLoadedSnapshot()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportAction.FILE_EXTENSION_NPS);
                }

                public String getDescription() {
                    return EXPORT_DIALOG_NPS_FILTER;
                }
            });
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(EXPORT_DIALOG_TITLE);
            this.fileChooser.setApproveButtonText(EXPORT_DIALOG_BUTTON);
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        if (file.exists()) {
            if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(OVERWRITE_FILE_CAPTION, file.getName()), OVERWRITE_FILE_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            if (!file.delete()) {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_OVERWRITE_FILE_MSG, file.getName()));
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        String string;
        File file;
        String string2;
        int n;
        String string3 = exportProvider.getViewName();
        JFileChooser jFileChooser = this.getFileChooser();
        if (exportDir != null) {
            jFileChooser.setCurrentDirectory(exportDir);
        }
        if ((n = jFileChooser.showSaveDialog(IDEUtils.getMainWindow())) != 0) {
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_XML_FILTER)) {
            string2 = FILE_EXTENSION_XML;
            this.exportedFileType = 3;
        } else if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_HTML_FILTER)) {
            string2 = FILE_EXTENSION_HTML;
            this.exportedFileType = 4;
        } else if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_EXCEL_FILTER)) {
            string2 = FILE_EXTENSION_CSV;
            this.exportedFileType = 2;
        } else if (jFileChooser.getFileFilter().getDescription().equals(EXPORT_DIALOG_NPS_FILTER)) {
            string2 = FILE_EXTENSION_NPS;
            this.exportedFileType = 5;
        } else {
            string2 = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        }
        exportDir = jFileChooser.getCurrentDirectory();
        if (file2.isDirectory()) {
            file = file2;
            string = string3;
        } else {
            file = exportDir;
            String string4 = file2.getName();
            int n2 = string4.lastIndexOf(".");
            if (n2 == -1) {
                string = string4;
            } else {
                string = string4.substring(0, n2);
                string2 = string4.substring(n2 + 1);
            }
        }
        return new SelectedFile(file, string, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SelectedFile selectedFile;
        if (!this.exportProvider.hasExportableView() && !this.exportProvider.hasLoadedSnapshot()) {
            NetBeansProfiler.getDefaultNB().displayError(NO_VIEW_MSG);
            return;
        }
        final LiveResultsWindow liveResultsWindow = this.exportProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.exportProvider : null;
        final AppStatusHandler appStatusHandler = NetBeansProfiler.getDefaultNB().getTargetAppRunner().getAppStatusHandler();
        if (liveResultsWindow != null) {
            appStatusHandler.pauseLiveUpdates();
        }
        if ((selectedFile = this.selectExportTargetFile(this.exportProvider)) == null) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (this.exportedFileType == 5) {
            File file = selectedFile.getSelectedFile();
            if (!this.checkFileExists(file)) {
                return;
            }
            try {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)selectedFile.folder)).createData(selectedFile.fileName, selectedFile.fileExt);
                selectedFile = null;
                ResultsManager.getDefault().saveSnapshot(this.snapshot, fileObject);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(SNAPSHOT_CREATE_FAILED_MSG, iOException.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            }
        } else {
            final File file = selectedFile.getSelectedFile();
            selectedFile = null;
            if (!this.checkFileExists(file)) {
                if (liveResultsWindow != null) {
                    appStatusHandler.resumeLiveUpdates();
                }
                return;
            }
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProgressHandle progressHandle = null;
                    progressHandle = ProgressHandleFactory.createHandle((String)EXPORTING_VIEW_MSG);
                    progressHandle.setInitialDelay(0);
                    progressHandle.start();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        ExportDataDumper exportDataDumper = new ExportDataDumper(fileOutputStream);
                        ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, exportDataDumper);
                        if (exportDataDumper.getCaughtException() != null) {
                            NetBeansProfiler.getDefaultNB().displayError(exportDataDumper.getNumExceptions() + IOEXCEPTION_EXPORTING_MSG);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        NetBeansProfiler.getDefaultNB().displayError(OOME_EXPORTING_MSG + outOfMemoryError.getMessage());
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                        if (liveResultsWindow != null) {
                            appStatusHandler.resumeLiveUpdates();
                        }
                    }
                }
            });
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File file, String string, String string2) {
            this.folder = file;
            this.fileName = string;
            this.fileExt = string2;
        }

        File getSelectedFile() {
            return new File(this.folder + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean hasExportableView();

        public boolean hasLoadedSnapshot();
    }
}

