/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HeapDumpWatch {
    public static final String OOME_PROTECTION_ENABLED_KEY = "profiler.info.oomeprotection";
    public static final String OOME_PROTECTION_DUMPPATH_KEY = "profiler.info.oomeprotection.dumppath";
    private static HeapDumpWatch instance;
    private Collection<FileObject> watchedFolders = new ArrayList<FileObject>();
    private HeapDumpFolderListener listener = new HeapDumpFolderListener();
    private Thread refreshThread;

    private HeapDumpWatch() {
    }

    public static synchronized HeapDumpWatch getDefault() {
        if (instance == null) {
            instance = new HeapDumpWatch();
        }
        return instance;
    }

    public void monitor(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The path \"" + string + "\" can't be null.");
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
        if (fileObject != null) {
            if (!fileObject.isFolder()) {
                throw new IllegalArgumentException("The given path \"" + string + "\" is invalid. It must be a folder");
            }
            fileObject.getChildren();
            fileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.watchedFolders.add(fileObject);
        }
    }

    public void releaseAll() {
        for (FileObject fileObject : this.watchedFolders) {
            fileObject.removeFileChangeListener((FileChangeListener)this.listener);
        }
        this.watchedFolders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureHeapDump(FileObject fileObject) {
        if (!fileObject.getExt().equals("hprof")) {
            return;
        }
        if (fileObject.getName().startsWith("heapdump-")) {
            return;
        }
        ProfilerControlPanel2.getDefault().refreshSnapshotsList();
        try {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(this.getClass(), (String)"OOME_PROTECTION_OPEN_HEAPDUMP"), 0, 3);
            NotifyDescriptor.Confirmation confirmation2 = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(this.getClass(), (String)"OOME_PROTECTION_REMOVE_HEAPDUMP"), 0, 3);
            if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
                HeapWalkerManager.getDefault().openHeapWalker(FileUtil.toFile((FileObject)fileObject));
            } else if (ProfilerDialogs.notify((NotifyDescriptor)confirmation2) == NotifyDescriptor.YES_OPTION) {
                fileObject.delete();
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.release(fileObject.getParent());
        }
    }

    private void release(FileObject fileObject) {
        fileObject.removeFileChangeListener((FileChangeListener)this.listener);
        this.watchedFolders.remove(fileObject);
    }

    private class HeapDumpFolderListener
    extends FileChangeAdapter {
        private HeapDumpFolderListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            HeapDumpWatch.this.captureHeapDump(fileEvent.getFile());
        }
    }
}

