/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.heapwalk.HintsController;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.util.NbBundle;

public class HintsControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE_HINTS = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_ViewTitleHints");
    private static final String FIND_BUTTON_TITLE = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_FindButton");
    private static final String FIND_BUTTON_TOOLTIP = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_FindButtonTooltip");
    private static final String LABEL1_STRING = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_Label1String");
    private static final String LABEL2_STRING = NbBundle.getMessage(HintsControllerUI.class, (String)"HintsControllerUI_Label2String");
    private static final Number OBJECTS_DEFAULT = 20;
    private static final int OBJECTS_MAX = 100;
    private HintsController hintsController;
    private JPanel hintsTextContainer;
    private JSpinner spinner;
    private JLabel textLabel1;
    private JLabel textLabel2;
    private JButton findButton;
    private HTMLTextArea dataArea;

    public HintsControllerUI(HintsController hintsController) {
        super(VIEW_TITLE_HINTS, (Icon)Utils.FIND_ACTION_ICON, true);
        this.hintsController = hintsController;
        this.initComponents();
    }

    public void setResult(String string) {
        this.dataArea.setText(string);
        try {
            this.dataArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.findButton.setEnabled(true);
    }

    private void initComponents() {
        final int n = new JTextField().getPreferredSize().height;
        this.setLayout(new BorderLayout());
        this.hintsTextContainer = new JPanel(new GridBagLayout());
        this.hintsTextContainer.setOpaque(false);
        this.hintsTextContainer.setBorder(BorderFactory.createMatteBorder(0, 0, 10, 0, UIUtils.getProfilerResultsBackground()));
        this.textLabel1 = new JLabel(LABEL1_STRING);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.hintsTextContainer.add((Component)this.textLabel1, gridBagConstraints);
        this.spinner = new JExtendedSpinner(new SpinnerNumberModel(OBJECTS_DEFAULT, Integer.valueOf(1), Integer.valueOf(100), (Number)1)){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, n);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.hintsTextContainer.add((Component)this.spinner, gridBagConstraints);
        this.textLabel2 = new JLabel(LABEL2_STRING);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.hintsTextContainer.add((Component)this.textLabel2, gridBagConstraints);
        this.findButton = new JButton(FIND_BUTTON_TITLE){

            protected void fireActionPerformed(ActionEvent actionEvent) {
                HintsControllerUI.this.findButton.setEnabled(false);
                int n = ((Number)HintsControllerUI.this.spinner.getValue()).intValue();
                HintsControllerUI.this.hintsController.computeBiggestObjects(n);
            }
        };
        this.findButton.setToolTipText(FIND_BUTTON_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.hintsTextContainer.add((Component)this.findButton, gridBagConstraints);
        JPanel jPanel = new JPanel(null);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.hintsTextContainer.add((Component)jPanel, gridBagConstraints);
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                if (uRL == null) {
                    return;
                }
                HintsControllerUI.this.hintsController.showURL(uRL);
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setOpaque(true);
        jPanel2.setBackground(this.dataArea.getBackground());
        jPanel2.add((Component)this.hintsTextContainer, "North");
        jPanel2.add((Component)this.dataArea, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel2, 20, 30);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getTitleBorderColor()), BorderFactory.createMatteBorder(10, 4, 5, 5, UIUtils.getProfilerResultsBackground())));
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane, "Center");
        this.setBackground(this.dataArea.getBackground());
    }
}

