/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;

public class ZipUnzipFile {
    private static final int COPY_BLOCK_SIZE = 65536;

    public static void compressFile(String string, String string2, FileAccess fileAccess) throws IOException {
        InputStream inputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        boolean bl = false;
        if (!fileAccess.isStreamElement(string)) {
            return;
        }
        try {
            int n;
            byte[] byArray = new byte[65536];
            inputStream = fileAccess.openInputStreamElement(string);
            deflaterOutputStream = new DeflaterOutputStream(fileAccess.openOutputStreamElement(string2), new Deflater(1), 65536);
            while ((n = inputStream.read(byArray, 0, 65536)) != -1) {
                deflaterOutputStream.write(byArray, 0, n);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.finish();
                    deflaterOutputStream.close();
                }
                if (!bl && fileAccess.isStreamElement(string2)) {
                    fileAccess.removeElement(string2);
                }
            }
            catch (Throwable throwable) {
                throw FileUtil.toIOException(throwable);
            }
        }
    }

    public static void decompressFile(String string, String string2, FileAccess fileAccess) throws IOException {
        InflaterInputStream inflaterInputStream = null;
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            int n;
            if (!fileAccess.isStreamElement(string)) {
                return;
            }
            fileAccess.removeElement(string2);
            inflaterInputStream = new InflaterInputStream(fileAccess.openInputStreamElement(string), new Inflater());
            outputStream = fileAccess.openOutputStreamElement(string2);
            byte[] byArray = new byte[65536];
            while ((n = inflaterInputStream.read(byArray, 0, 65536)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
        finally {
            try {
                if (inflaterInputStream != null) {
                    inflaterInputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (!bl && fileAccess.isStreamElement(string2)) {
                    fileAccess.removeElement(string2);
                }
            }
            catch (Throwable throwable) {
                throw FileUtil.toIOException(throwable);
            }
        }
    }
}

