/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;

final class DocDecoder
implements DocConstants {
    private static final int COUNT_BITS = 3;
    private Resources res = Resources.getInstance();

    DocDecoder() {
    }

    String parseRecords(Record[] recordArray) throws IOException {
        HeaderInfo headerInfo = this.readHeader(recordArray[0].getBytes());
        this.dumpHeader(headerInfo);
        StringBuffer stringBuffer = new StringBuffer(headerInfo.textLen);
        switch (headerInfo.version) {
            case 2: {
                for (int i = 1; i <= headerInfo.textRecordCount; ++i) {
                    byte[] byArray = this.decompress(recordArray[i].getBytes(), headerInfo.textRecordSize);
                    this.log("processing " + byArray.length + " bytes");
                    String string = new String(byArray, "8859_1");
                    stringBuffer.append(string);
                }
                break;
            }
            case 1: {
                for (int i = 1; i <= headerInfo.textRecordCount; ++i) {
                    byte[] byArray = recordArray[i].getBytes();
                    this.log("processing " + byArray.length + " bytes");
                    String string = new String(byArray, "8859_1");
                    stringBuffer.append(string);
                }
                break;
            }
            default: {
                throw new IOException(this.res.getString("UNKNOWN_DOC_VERSION"));
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decompress(byte[] var1_1, int var2_2) throws IOException {
        var3_3 = new byte[var2_2 * 2];
        var4_4 = 0;
        var5_5 = 0;
lbl4:
        // 3 sources

        try {
            while (var5_5 < var1_1.length) {
                block7: {
                    if ((var6_6 = var1_1[var5_5++] & 255) <= 0 || var6_6 >= 9) break block7;
                    while (var6_6-- > 0) {
                        var3_3[var4_4++] = var1_1[var5_5++];
                    }
                    ** GOTO lbl4
                }
                if (var6_6 < 128) {
                    var3_3[var4_4++] = (byte)var6_6;
                    continue;
                }
                if (var6_6 >= 192) {
                    var3_3[var4_4++] = 32;
                    var3_3[var4_4++] = (byte)(var6_6 ^ 128);
                    continue;
                }
                var6_6 <<= 8;
                var7_9 = ((var6_6 += var1_1[var5_5++] & 255) & 16383) >> 3;
                var8_10 = var6_6 & 7;
                var8_10 += 3;
                while (var8_10-- > 0) {
                    var3_3[var4_4] = var3_3[var4_4 - var7_9];
                    ++var4_4;
                }
                ** GOTO lbl4
            }
        }
        catch (ArrayIndexOutOfBoundsException var6_7) {
            throw new IOException(this.res.getString("DOC_TEXT_RECORD_SIZE_EXCEEDED"));
        }
        var6_8 = new byte[var4_4];
        System.arraycopy(var3_3, 0, var6_8, 0, var4_4);
        return var6_8;
    }

    private HeaderInfo readHeader(byte[] byArray) throws IOException {
        HeaderInfo headerInfo = new HeaderInfo();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        dataInputStream.readByte();
        headerInfo.version = dataInputStream.readByte();
        dataInputStream.readShort();
        headerInfo.textLen = dataInputStream.readInt();
        if (headerInfo.textLen < 0) {
            throw new IOException(this.res.getString("DOC_TEXT_LENGTH_EXCEEDED"));
        }
        headerInfo.textRecordCount = dataInputStream.readShort() & 0xFFFF;
        headerInfo.textRecordSize = dataInputStream.readShort() & 0xFFFF;
        dataInputStream.readInt();
        return headerInfo;
    }

    private void dumpHeader(HeaderInfo headerInfo) {
        this.log("<DOC_INFO ");
        this.log("version=\"" + headerInfo.version + "\" ");
        this.log("text-length=\"" + headerInfo.textLen + "\" ");
        this.log("number-of-records=\"" + headerInfo.textRecordCount + "\" ");
        this.log("record-size=\"" + headerInfo.textRecordSize + "\" />");
    }

    private void log(String string) {
        Debug.log((int)4, (String)string);
    }

    private class HeaderInfo {
        int textLen = 0;
        int textRecordCount = 0;
        int textRecordSize = 0;
        int version = 0;

        private HeaderInfo() {
        }
    }
}

