/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;

final class DocEncoder
implements DocConstants {
    private StringBuffer textBuffer = new StringBuffer(4096);
    private int textLen = 0;
    private int textRecCount = 0;

    DocEncoder() {
    }

    void addText(String string) {
        this.textBuffer.append(string);
    }

    void addText(char[] cArray) {
        this.textBuffer.append(cArray);
    }

    void addText(char c) {
        this.textBuffer.append(c);
    }

    Record[] getRecords() throws IOException {
        byte[] byArray = this.processTextBuffer();
        this.textLen = byArray.length;
        this.textRecCount = (short)(byArray.length / 4096);
        byte[] byArray2 = new byte[4096];
        int n = 0;
        ArrayList<Record> arrayList = new ArrayList<Record>(this.textRecCount + 1);
        for (int i = 0; i < this.textRecCount; ++i) {
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            n += byArray2.length;
            Record record = new Record(byArray2);
            arrayList.add(record);
        }
        if (n < this.textLen) {
            ++this.textRecCount;
            byArray2 = new byte[this.textLen - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            Record record = new Record(byArray2);
            arrayList.add(record);
        }
        Record[] recordArray = new Record[arrayList.size() + 1];
        recordArray[0] = new Record(this.getHeaderBytes());
        for (int i = 1; i < recordArray.length; ++i) {
            recordArray[i] = (Record)arrayList.get(i - 1);
        }
        return recordArray;
    }

    private byte[] processTextBuffer() throws IOException {
        String string = this.textBuffer.toString();
        byte[] byArray = string.getBytes("8859_1");
        return byArray;
    }

    private byte[] getHeaderBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt(this.textLen);
        dataOutputStream.writeShort(this.textRecCount);
        dataOutputStream.writeShort(4096);
        dataOutputStream.writeInt(0);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }
}

