/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.style.UnicodeCharacter;
import writer2latex.latex.style.UnicodeRow;

class UnicodeTable {
    protected UnicodeRow[] table = new UnicodeRow[256];
    private UnicodeTable parent;

    public UnicodeTable(UnicodeTable unicodeTable) {
        this.parent = unicodeTable;
        if (unicodeTable != null) {
            for (int i = 0; i < 256; ++i) {
                this.table[i] = unicodeTable.table[i];
            }
        }
    }

    private void createEntry(int n, int n2) {
        if (this.table[n] == null) {
            this.table[n] = new UnicodeRow();
        } else if (this.parent != null && this.table[n] == this.parent.table[n]) {
            this.table[n] = (UnicodeRow)this.parent.table[n].clone();
        }
        if (this.table[n].entries[n2] == null) {
            this.table[n].entries[n2] = new UnicodeCharacter();
        }
    }

    protected void addCharType(char c, int n) {
        int n2 = c / 256;
        int n3 = c % 256;
        this.createEntry(n2, n3);
        this.table[n2].entries[n3].nType = n;
    }

    protected void addCharType(char c, String string) {
        int n = c / 256;
        int n2 = c % 256;
        this.createEntry(n, n2);
        this.table[n].entries[n2].nType = "combining".equals(string) ? 1 : ("ignore".equals(string) ? 2 : 0);
    }

    protected void addMathChar(char c, String string) {
        int n = c / 256;
        int n2 = c % 256;
        this.createEntry(n, n2);
        this.table[n].entries[n2].sMath = string;
    }

    protected void addTextChar(char c, String string, int n) {
        int n2 = c / 256;
        int n3 = c % 256;
        this.createEntry(n2, n3);
        this.table[n2].entries[n3].sText = string;
        this.table[n2].entries[n3].nFontencs = n;
    }

    private UnicodeCharacter getEntry(char c) {
        int n = c / 256;
        int n2 = c % 256;
        if (this.table[n] == null) {
            return null;
        }
        return this.table[n].entries[n2];
    }

    public int getCharType(char c) {
        UnicodeCharacter unicodeCharacter = this.getEntry(c);
        if (unicodeCharacter == null) {
            return 3;
        }
        return unicodeCharacter.nType;
    }

    public boolean hasMathChar(char c) {
        UnicodeCharacter unicodeCharacter = this.getEntry(c);
        if (unicodeCharacter == null) {
            return false;
        }
        return unicodeCharacter.sMath != null;
    }

    public String getMathChar(char c) {
        UnicodeCharacter unicodeCharacter = this.getEntry(c);
        if (unicodeCharacter == null) {
            return null;
        }
        return unicodeCharacter.sMath;
    }

    public boolean hasTextChar(char c) {
        UnicodeCharacter unicodeCharacter = this.getEntry(c);
        if (unicodeCharacter == null) {
            return false;
        }
        return unicodeCharacter.sText != null;
    }

    public String getTextChar(char c) {
        UnicodeCharacter unicodeCharacter = this.getEntry(c);
        if (unicodeCharacter == null) {
            return null;
        }
        return unicodeCharacter.sText;
    }

    public int getFontencs(char c) {
        UnicodeCharacter unicodeCharacter = this.getEntry(c);
        if (unicodeCharacter == null) {
            return 0;
        }
        return unicodeCharacter.nFontencs;
    }

    public int getCharCount() {
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.table[i] == null) continue;
            for (int j = 0; j < 256; ++j) {
                UnicodeCharacter unicodeCharacter = this.table[i].entries[j];
                if (unicodeCharacter == null) continue;
                ++n;
            }
        }
        return n;
    }
}

