/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sinks;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.SinkTokenizer;
import org.apache.lucene.analysis.Token;

public class DateRecognizerSinkTokenizer
extends SinkTokenizer {
    public static final String DATE_TYPE = "date";
    protected DateFormat dateFormat;

    public DateRecognizerSinkTokenizer() {
        this(null, SimpleDateFormat.getDateInstance());
    }

    public DateRecognizerSinkTokenizer(DateFormat dateFormat) {
        this(null, dateFormat);
    }

    public DateRecognizerSinkTokenizer(List input) {
        this(input, SimpleDateFormat.getDateInstance());
    }

    public DateRecognizerSinkTokenizer(List input, DateFormat dateFormat) {
        super(input);
        this.dateFormat = dateFormat;
    }

    public void add(Token t) {
        if (t != null) {
            try {
                Date date = this.dateFormat.parse(new String(t.termBuffer(), 0, t.termLength()));
                if (date != null) {
                    t.setType(DATE_TYPE);
                    this.lst.add(t.clone());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

