# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "hitimes"
  s.version = "1.1.1"
  s.platform = "java"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeremy Hinegardner"]
  s.date = "2010-09-06"
  s.description = "Hitimes is a fast, high resolution timer library for recording\nperformance metrics.  It uses the appropriate low method calls for each\nsystem to get the highest granularity time increments possible.  \n\nIt currently supports any of the following systems:\n\n* any system with the POSIX call <tt>clock_gettime()</tt>,\n* Mac OS X\n* Windows\n* JRuby\n\nUsing Hitimes can be faster than using a series of +Time.new+ calls, and\nit will have a much higher granularity.   It is definitely faster than\nusing +Process.times+."
  s.email = "jeremy@copiousfreetime.org"
  s.extra_rdoc_files = ["README", "HISTORY", "LICENSE", "lib/hitimes.rb", "lib/hitimes/metric.rb", "lib/hitimes/mutexed_stats.rb", "lib/hitimes/paths.rb", "lib/hitimes/stats.rb", "lib/hitimes/timed_metric.rb", "lib/hitimes/timed_value_metric.rb", "lib/hitimes/value_metric.rb", "lib/hitimes/version.rb"]
  s.files = ["README", "HISTORY", "LICENSE", "lib/hitimes.rb", "lib/hitimes/metric.rb", "lib/hitimes/mutexed_stats.rb", "lib/hitimes/paths.rb", "lib/hitimes/stats.rb", "lib/hitimes/timed_metric.rb", "lib/hitimes/timed_value_metric.rb", "lib/hitimes/value_metric.rb", "lib/hitimes/version.rb"]
  s.homepage = "http://copiousfreetime.rubyforge.org/hitimes/"
  s.rdoc_options = ["--line-numbers", "--main", "README"]
  s.require_paths = ["lib", "ext"]
  s.rubyforge_project = "copiousfreetime"
  s.rubygems_version = "1.8.24"
  s.summary = "Hitimes is a fast, high resolution timer library for recording performance metrics"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<rake>, ["~> 0.8.1"])
      s.add_development_dependency(%q<configuration>, ["~> 0.0.5"])
      s.add_development_dependency(%q<json>, ["~> 1.1.3"])
      s.add_development_dependency(%q<rake-compiler>, ["~> 0.5.0"])
    else
      s.add_dependency(%q<rake>, ["~> 0.8.1"])
      s.add_dependency(%q<configuration>, ["~> 0.0.5"])
      s.add_dependency(%q<json>, ["~> 1.1.3"])
      s.add_dependency(%q<rake-compiler>, ["~> 0.5.0"])
    end
  else
    s.add_dependency(%q<rake>, ["~> 0.8.1"])
    s.add_dependency(%q<configuration>, ["~> 0.0.5"])
    s.add_dependency(%q<json>, ["~> 1.1.3"])
    s.add_dependency(%q<rake-compiler>, ["~> 0.5.0"])
  end
end
