/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.services.IIndexedAttributeChild;
import com.jrockit.mc.rjmx.ui.column.ColumnComposite;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.internal.AbstractArrayElementMenuAction;
import com.jrockit.mc.rjmx.ui.messages.internal.Messages;
import java.lang.reflect.Array;
import org.eclipse.jface.action.ActionContributionItem;

public class InsertArrayElementMenuAction
extends AbstractArrayElementMenuAction {
    private final boolean m_insertBelow;

    protected InsertArrayElementMenuAction(ColumnComposite attributeInspector, IColumn column, boolean insertBelow) {
        super(insertBelow ? Messages.INSERT_ARRAY_ELEMENT_BELOW_ACTION : Messages.INSERT_ARRAY_ELEMENT_ABOVE_ACTION, attributeInspector, column);
        this.m_insertBelow = insertBelow;
    }

    @Override
    protected void run(IIndexedAttributeChild selectedElement) {
        IAttribute parent = (IAttribute)selectedElement.getParent();
        Object array = parent.getValue();
        Object newArray = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array) + 1);
        int selectedIndex = selectedElement.getIndex() + (this.m_insertBelow ? 1 : 0);
        if (selectedIndex > 0) {
            System.arraycopy(array, 0, newArray, 0, selectedIndex);
        }
        if (selectedIndex <= Array.getLength(array) - 1) {
            System.arraycopy(array, selectedIndex, newArray, selectedIndex + 1, Array.getLength(array) - selectedIndex);
        }
        parent.setValue(newArray);
    }

    public static ActionContributionItem createInsertArrayElementMenuActionContribution(ColumnComposite attributeInspector, IColumn column, boolean insertBelow) {
        return new InsertArrayElementMenuAction(attributeInspector, column, insertBelow).getActionContribution();
    }
}

