/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkLoader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkStructure;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LoaderContext;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.concurrent.Executor;

public class FileReader
implements Runnable {
    private final Collection<ChunkStructure> loadChunks;
    private final LoaderContext recordingLoader;
    private final RandomAccessFile raf;
    private final Executor executor;

    public FileReader(Collection<ChunkStructure> chunks, RandomAccessFile raf, LoaderContext recordingLoader, Executor executor) {
        this.loadChunks = chunks;
        this.raf = raf;
        this.recordingLoader = recordingLoader;
        this.executor = executor;
    }

    @Override
    public void run() {
        for (ChunkStructure chunk : this.loadChunks) {
            byte[] buffer = this.recordingLoader.takeBuffer();
            try {
                if (buffer == null) {
                    return;
                }
                buffer = this.fillBuffer(chunk, buffer);
                this.executor.execute(new ChunkLoader(chunk.getHeader(), buffer, this.recordingLoader));
            }
            catch (Throwable e) {
                this.recordingLoader.setFailed(e);
                this.recordingLoader.returnBuffer(buffer);
                return;
            }
        }
        this.recordingLoader.allChunksLoaded(this.loadChunks.size());
    }

    private byte[] fillBuffer(ChunkStructure chunk, byte[] buffer) throws IOException {
        if (chunk.getChunkSize() > buffer.length) {
            buffer = new byte[chunk.getChunkSize()];
        }
        this.raf.seek(chunk.getHeader().getChunkPosition());
        this.raf.readFully(buffer, 0, chunk.getChunkSize());
        return buffer;
    }
}

