/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.model;

import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.HashMap;
import java.util.Map;

public enum XAxisDataSource {
    START_TIME("(startTime)", Messages.XAXIS_DATA_SOURCE_START_TIME_NAME),
    END_TIME("(endTime)", Messages.XAXIS_DATA_SOURCE_DURATION_NAME),
    DURATION("(duration)", Messages.XAXIS_DATA_SOURCE_END_TIME_DURATION);

    private final String m_key;
    private final String m_name;

    private XAxisDataSource(String key, String name) {
        this.m_key = key;
        this.m_name = name;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getName() {
        return this.m_name;
    }

    public static XAxisDataSource lookup(String key) {
        XAxisDataSource[] xAxisDataSourceArray = XAxisDataSource.values();
        int n = xAxisDataSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            XAxisDataSource s = xAxisDataSourceArray[n2];
            if (key.equals(s.getKey())) {
                return s;
            }
            ++n2;
        }
        return END_TIME;
    }

    public static Map<String, String> createKeyNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        XAxisDataSource[] xAxisDataSourceArray = XAxisDataSource.values();
        int n = xAxisDataSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            XAxisDataSource s = xAxisDataSourceArray[n2];
            map.put(s.getKey(), s.getName());
            ++n2;
        }
        return map;
    }
}

