/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.components.ui.base.AbstractViewerComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.OperativeSetMenu;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.fields.FieldViewerComparator;
import com.jrockit.mc.ui.fields.FieldViewerFilterControl;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.model.fields.StructuredRowSelection;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class ColumnViewerComponent
extends AbstractViewerComponent
implements IOperativeSetAware {
    public static final String COLUMN_DESCRIPTOR_REPOSITORY = "columnDescriptorRepository";
    private FieldViewerFilterControl m_fieldViewerFilterControl;

    public Field[] createFields() {
        ColumnDescriptorRepository repository = this.getRepository();
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        for (ColumnDescriptor column : repository.getColumnDescriptors()) {
            fields.add(EventFieldToolkit.createField(column, String.valueOf(column.getAttributeIdentifier()) + index, index));
            ++index;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            ViewModelBuilder<?> builder = this.createModelBuilder();
            builder.setEventView(this.createView());
            builder.setOperativeSetEnabled(false);
            serviceLocator.registerService(ViewModelBuilder.class.getName(), builder);
            serviceLocator.registerService((Object)new OperativeSetService(serviceLocator));
            return true;
        }
        return false;
    }

    protected abstract ViewModelBuilder<?> createModelBuilder();

    protected IStatus getModelStatus(Object model) {
        String message = this.getModelBuilder().getLastBuildMessage();
        if (message == null) {
            return this.createOKStatus();
        }
        return new Status(2, "com.jrockit.mc.flightrecorder.ui", message);
    }

    protected final ViewModelBuilder<?> getViewModelBuilder() {
        return (ViewModelBuilder)this.getServiceLocator().getService(ViewModelBuilder.class);
    }

    public FieldViewerFilterControl getViewerFilterControl() {
        return this.m_fieldViewerFilterControl;
    }

    protected void initializeUI() {
        super.initializeUI();
        this.getMenuManager().add((IContributionItem)new OperativeSetMenu((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)));
        FieldViewerFilterControl fvfc = this.getViewerFilterControl();
        if (fvfc != null) {
            fvfc.initialize(this.getViewer(), this.getFields());
            fvfc.setFilteredField(this.getFields()[this.findFilteredColumnIndex()]);
        }
        this.updateSorting();
        EventTypeAcceptor eta = new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository());
        this.getModelBuilder().getView().setEventTypes(eta.getAcceptedSet());
    }

    public void selectAnElement() {
        Object[] allelements;
        if (this.getViewer().getSelection().isEmpty() && (allelements = ((FieldTableViewer)this.getViewer()).getAllElements()) != null && allelements.length > 0) {
            StructuredRowSelection selection = new StructuredRowSelection((Row)allelements[0], this.getFields());
            this.getViewer().setSelection((ISelection)selection, true);
            this.getViewer().getControl().forceFocus();
            this.pushSelection((IStructuredSelection)selection);
        }
    }

    protected abstract void pushSelection(IStructuredSelection var1);

    protected void refresh() {
        this.getModelBuilder().scheduleRebuild();
    }

    protected final StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    protected final IView createView() {
        Role r = this.getRepository().getRole();
        return r.getCommander() != null ? new SimpleView(new ArrayList<IEvent>()) : this.getFlightRecording().createView();
    }

    protected FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    protected final void updateSorting() {
        Field field;
        StructuredViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed() && (field = this.findSortedField()) != null) {
            viewer.setComparator((ViewerComparator)new FieldViewerComparator(viewer, field, field.getSortOrderAscending()));
        }
    }

    protected Composite createTopControl(Composite container) {
        if (this.isFilterable() || this.isOperativeSettable()) {
            Composite topControl = this.getFormToolkit().createComposite(container, 0);
            if (this.isFilterable()) {
                GridData gd1 = new GridData(4, 4, true, false);
                boolean showCombo = this.getFields().length > 1;
                this.m_fieldViewerFilterControl = new FieldViewerFilterControl(topControl, this.getFormToolkit(), showCombo);
                this.m_fieldViewerFilterControl.setLayoutData((Object)gd1);
                this.m_fieldViewerFilterControl.addTraverseListener((TraverseListener)new SimpleTraverseListener());
                this.m_fieldViewerFilterControl.getTextControl().setData("name", (Object)(String.valueOf(this.getComponentDescriptor().getIdentifier()) + ".filter.text"));
                if (showCombo) {
                    this.m_fieldViewerFilterControl.getComboControl().setData("name", (Object)(String.valueOf(this.getComponentDescriptor().getIdentifier()) + ".filter.combo"));
                }
                this.getFormToolkit().adapt((Composite)this.m_fieldViewerFilterControl);
            }
            if (this.isOperativeSettable()) {
                Button checkBox = this.createOperativeSetButton(topControl);
                checkBox.setLayoutData(this.createOperativeSetButtonLayoutData());
            }
            topControl.addTraverseListener((TraverseListener)new SimpleTraverseListener());
            topControl.setLayout(this.createTopControlLayout(topControl));
            this.getFormToolkit().adapt(topControl);
            return topControl;
        }
        return null;
    }

    private Object createOperativeSetButtonLayoutData() {
        GridData ggridData = null;
        ggridData = !this.isFilterable() ? new GridData(0x1000008, 4, true, false) : new GridData(4, 4, false, false);
        ggridData.horizontalIndent = 5;
        return ggridData;
    }

    private Layout createTopControlLayout(Composite topControl) {
        GridLayout layout = new GridLayout();
        layout.numColumns = topControl.getChildren().length;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected final Button createOperativeSetButton(Composite topControl) {
        final Button checkBox = this.getFormToolkit().createButton(topControl, Messages.OPERATIVE_SET_SHOW_ONLY_SET_BUTTON_TEXT, 32);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnViewerComponent.this.getModelBuilder().setOperativeSetEnabled(checkBox.getSelection());
                ColumnViewerComponent.this.getModelBuilder().scheduleRebuild();
            }
        });
        return checkBox;
    }

    protected final <T> ViewModelBuilder<T> getModelBuilder() {
        return (ViewModelBuilder)this.getServiceLocator().getService(ViewModelBuilder.class);
    }

    protected final boolean isOperativeSettable() {
        return this.getRepository().getAllowOperativeSet();
    }

    protected boolean isFilterable() {
        return this.findFilteredColumnIndex() != -1;
    }

    protected Field findSortedField() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            assert (index < this.getFields().length);
            if (column.isInitialSortColumn()) {
                return this.getFields()[index];
            }
            ++index;
        }
        return null;
    }

    private int findFilteredColumnIndex() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            if (column.getUseForFiltering()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected ColumnDescriptorRepository getRepository() {
        return (ColumnDescriptorRepository)this.getComponentSettings().getChildObject(COLUMN_DESCRIPTOR_REPOSITORY, ColumnDescriptorRepository.class);
    }

    protected boolean isOperativesetEnabled() {
        return this.getModelBuilder().getOperativeSetEnabled();
    }

    @Override
    public void operativeSetChange() {
        if (this.isOperativesetEnabled() || this.getRepository().getRole().getCommander() != null) {
            this.markDirty();
        }
    }

    public void consumeEvents(Iterable<IEvent> events, Role role) {
        if (this.getRepository().getRole().listensTo(role)) {
            IView oldView = this.getModelBuilder().getView();
            SimpleView newView = new SimpleView(events);
            newView.setRange(oldView.getRange());
            newView.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository()).getAcceptedSet());
            newView.setFilter(oldView.getFilter());
            this.getModelBuilder().setEventView(newView);
            this.markDirty();
        }
    }

    public void onTypeVisibilityChange() {
        if (this.getRepository().getEventTypeDescriptorRepository().getUserFilterConstrained()) {
            this.getModelBuilder().getView().setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository()).getAcceptedSet());
            this.markDirty();
        }
    }

    public void onChange(long startTime, long endTime) {
        ITimeRange r = this.getModelBuilder().getView().getRange();
        if (r.getStartTimestamp() != startTime || r.getEndTimestamp() != endTime) {
            this.getModelBuilder().getView().setRange((ITimeRange)new TimeRange(startTime, endTime));
            this.markDirty();
        }
    }

    public boolean isTypeChangeEnabled() {
        return this.getRepository().getEventTypeDescriptorRepository().getUserFilterConstrained();
    }

    protected boolean hasBackdropColumn() {
        for (ColumnDescriptor cd : this.getRepository().getColumnDescriptors()) {
            if (!cd.getUseBackdrop()) continue;
            return true;
        }
        return false;
    }
}

