/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.components.ui.base.AbstractUIConfigurer;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.EventColorType;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.TrackGroupInput;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class GraphConfigurer
extends AbstractUIConfigurer {
    public Control createPart(Composite parent) {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        inputs.add(this.createAllowFilter());
        inputs.add(this.createAllowTransitionsChange());
        inputs.add(this.createAllowBackdropChange());
        inputs.add(this.createAllowOperativeSet());
        inputs.add(this.createTransitions());
        inputs.add(this.createBackdropOn());
        inputs.add(this.createTrackGroupRoot());
        inputs.add(InputFactory.createEventTypeInput(this.getServiceLocator()));
        inputs.add(this.createColorInputType());
        inputs.add(InputFactory.createAttributeWithRepositoryForKey(this.getServiceLocator(), "eventTypes", true));
        inputs.add(InputFactory.createValueBegin());
        inputs.add(InputFactory.createColorBegin());
        inputs.add(InputFactory.createValueEnd());
        inputs.add(InputFactory.createColorEnd());
        InputPanel panel = new InputPanel(parent, (Object)this.getTGraphDescriptor(), inputs);
        return panel.getControl();
    }

    private IInput createTrackGroupRoot() {
        return new TrackGroupInput("rootTrackGroup", Messages.GRAPH_CONFIGURER_ROOT_TRACK_NAME, this.getServiceLocator());
    }

    private IInput createColorInputType() {
        return new ComboInput("eventColorType", Messages.GRAPH_CONFIGURER_COLORING_NAME, EventColorType.createMap());
    }

    private IInput createAllowFilter() {
        return new BooleanInput("allowFiltering", Messages.GRAPH_CONFIGURER_ALLOW_FILTERING_NAME);
    }

    private IInput createAllowTransitionsChange() {
        return new BooleanInput("allowTransitions", Messages.GRAPH_CONFIGURER_ALLOW_TRANSITION_CHANGE_NAME);
    }

    private IInput createTransitions() {
        return new BooleanInput("showTransitions", Messages.GRAPH_CONFIGURER_TRANSITIONS_ENABLED_NAME);
    }

    private IInput createAllowBackdropChange() {
        return new BooleanInput("allowBckdrop", Messages.GRAPH_CONFIGURER_ALLOW_BACKDROP_CHANGE_NAME);
    }

    private IInput createBackdropOn() {
        return new BooleanInput("showBackdrop", Messages.GRAPH_CONFIGURER_BACKDROP_ENABLED_NAME);
    }

    private IInput createAllowOperativeSet() {
        return InputFactory.createOperativeSetEnabled();
    }

    private ChartConfiguration getTGraphDescriptor() {
        return (ChartConfiguration)this.getComponentSettings().getChildObject("chartConfiguration", ChartConfiguration.class);
    }
}

