/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class TransitionLookup {
    private final Map<IEventType, IField> m_fromLookup = new HashMap<IEventType, IField>();
    private final Map<IEventType, IField> m_toLookup = new HashMap<IEventType, IField>();

    public TransitionLookup(FlightRecording recording) {
        this.initialize(recording.getEventTypes());
    }

    private void initialize(Collection<? extends IEventType> eventTypes) {
        for (IEventType iEventType : eventTypes) {
            IField field = this.getFirstTransitionField(iEventType, Transition.TRANSITION_FROM);
            if (field != null) {
                EventToolkit.setPartOfTransitionFrom(iEventType);
                this.m_fromLookup.put(iEventType, field);
            }
            if ((field = this.getFirstTransitionField(iEventType, Transition.TRANSITION_TO)) == null) continue;
            EventToolkit.setPartOfTransitionTo(iEventType);
            this.m_toLookup.put(iEventType, field);
        }
    }

    public IField getTransitionToField(IEvent e) {
        return this.getFirstTransitionField(e.getEventType(), Transition.TRANSITION_TO);
    }

    public IField getTransitionFromField(IEvent e) {
        return this.getFirstTransitionField(e.getEventType(), Transition.TRANSITION_FROM);
    }

    private IField getFirstTransitionField(IEventType type, Transition t) {
        for (IField field : type.getFields()) {
            if (!field.hasProperty(t.getKey())) continue;
            return field;
        }
        return null;
    }

    public IMCThread getTransitionTo(IEvent e) {
        if (EventToolkit.hasTransitionTo(e.getEventType())) {
            IField field = this.m_toLookup.get(e.getEventType());
            return (IMCThread)field.getValue(e);
        }
        return null;
    }

    public IMCThread getTransitionFrom(IEvent e) {
        if (EventToolkit.hasTransitionFrom(e.getEventType())) {
            IField field = this.m_fromLookup.get(e.getEventType());
            return (IMCThread)field.getValue(e);
        }
        return null;
    }

    private static enum Transition {
        TRANSITION_TO("transitionTo"),
        TRANSITION_FROM("transitionFrom");

        private final String m_key;

        private Transition(String key) {
            this.m_key = key;
        }

        String getKey() {
            return this.m_key;
        }
    }
}

