/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

public final class Normalizer {
    private final double[] m_normalizationFactors;

    public Normalizer(int size) {
        this.m_normalizationFactors = new double[size];
        int i = 0;
        while (i < size) {
            this.m_normalizationFactors[i] = Double.NaN;
            ++i;
        }
    }

    public Object[] normalize(Object[] values) {
        int i = 0;
        while (i < values.length) {
            double factor = this.m_normalizationFactors[i];
            Object value = values[i];
            values[i] = this.isTouched(factor) && value instanceof Number ? Double.valueOf(((Number)value).doubleValue() / factor) : value;
            ++i;
        }
        return values;
    }

    private boolean isTouched(double value) {
        return !Double.isNaN(value);
    }

    public void setNormalizationFactor(int index, double normalizationFactor) {
        this.m_normalizationFactors[index] = normalizationFactor;
    }
}

