/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.labelingrules;

import com.jrockit.mc.core.labelingrules.Variables;
import java.text.MessageFormat;
import java.util.StringTokenizer;

final class Formatter {
    private final String formatPart;

    public Formatter(String formatPart) {
        this.formatPart = formatPart;
    }

    public String format(Object[] vals) {
        return MessageFormat.format(Formatter.replaceVariables(this.formatPart, vals), vals).trim();
    }

    static String replaceVariables(String formatString, Object[] input) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(formatString, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("{")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("Found unmatched { in rule!");
                }
                String content = stringTokenizer.nextToken();
                if (Variables.getInstance().containsVariable(content)) {
                    token = Variables.getInstance().getVariable(content).evaluate(input);
                    stringTokenizer.nextToken();
                } else {
                    token = "{" + content;
                }
            }
            buffer.append(token);
        }
        return buffer.toString();
    }
}

