/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.SortedSet;
import java.util.TreeSet;

public class GC {
    private static final long NO_TARGET = Long.MAX_VALUE;
    private static long latencyTarget = Long.MAX_VALUE;
    private static Thread daemon = null;
    private static Object lock = new LatencyLock();

    private GC() {
    }

    public static native long maxObjectInspectionAge();

    private static void setLatencyTarget(long l) {
        latencyTarget = l;
        if (daemon == null) {
            Daemon.create();
        } else {
            lock.notify();
        }
    }

    public static LatencyRequest requestLatency(long l) {
        return new LatencyRequest(l);
    }

    public static long currentLatencyTarget() {
        long l = latencyTarget;
        return l == Long.MAX_VALUE ? 0L : l;
    }

    private static class Daemon
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = lock;
                synchronized (object) {
                    long l = latencyTarget;
                    if (l == Long.MAX_VALUE) {
                        daemon = null;
                        return;
                    }
                    long l2 = GC.maxObjectInspectionAge();
                    if (l2 >= l) {
                        System.gc();
                        l2 = 0L;
                    }
                    try {
                        lock.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }

        private Daemon(ThreadGroup threadGroup) {
            super(threadGroup, "GC Daemon");
        }

        public static void create() {
            PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    Object object = threadGroup;
                    while (object != null) {
                        threadGroup = object;
                        object = threadGroup.getParent();
                    }
                    object = new Daemon(threadGroup);
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).setPriority(2);
                    ((Thread)object).start();
                    daemon = (Thread)object;
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        }
    }

    private static class LatencyLock {
        private LatencyLock() {
        }
    }

    public static class LatencyRequest
    implements Comparable<LatencyRequest> {
        private static long counter = 0L;
        private static SortedSet<LatencyRequest> requests = null;
        private long latency;
        private long id;

        private static void adjustLatencyIfNeeded() {
            if (requests == null || requests.isEmpty()) {
                if (latencyTarget != Long.MAX_VALUE) {
                    GC.setLatencyTarget(Long.MAX_VALUE);
                }
            } else {
                LatencyRequest latencyRequest = requests.first();
                if (latencyRequest.latency != latencyTarget) {
                    GC.setLatencyTarget(latencyRequest.latency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LatencyRequest(long l) {
            if (l <= 0L) {
                throw new IllegalArgumentException("Non-positive latency: " + l);
            }
            this.latency = l;
            Object object = lock;
            synchronized (object) {
                this.id = ++counter;
                if (requests == null) {
                    requests = new TreeSet<LatencyRequest>();
                }
                requests.add(this);
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = lock;
            synchronized (object) {
                if (this.latency == Long.MAX_VALUE) {
                    throw new IllegalStateException("Request already cancelled");
                }
                if (!requests.remove(this)) {
                    throw new InternalError("Latency request " + this + " not found");
                }
                if (requests.isEmpty()) {
                    requests = null;
                }
                this.latency = Long.MAX_VALUE;
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        @Override
        public int compareTo(LatencyRequest latencyRequest) {
            long l = this.latency - latencyRequest.latency;
            if (l == 0L) {
                l = this.id - latencyRequest.id;
            }
            return l < 0L ? -1 : (l > 0L ? 1 : 0);
        }

        public String toString() {
            return LatencyRequest.class.getName() + "[" + this.latency + "," + this.id + "]";
        }
    }
}

