/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.internal.ConnectionHandleToolkit;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.internal.HotspotManagementToolkit;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

final class FlightRecorderCommunicationHelper {
    private final MBeanServerConnection server;
    private static final ObjectName FLR_MBEAN_OBJECT_NAME = ConnectionToolkit.createObjectName("com.oracle.jrockit:type=FlightRecorder");

    public FlightRecorderCommunicationHelper(MBeanServerConnection server) {
        this.server = server;
    }

    public Object getAttribute(String attribute) throws FlightRecorderException {
        try {
            try {
                return this.getFlrAttribute(attribute);
            }
            catch (InstanceNotFoundException e) {
                HotspotManagementToolkit.registerMBeans(this.server);
                return this.getFlrAttribute(attribute);
            }
        }
        catch (IOException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + attribute + '!', e);
        }
        catch (JMException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + attribute + '!', e);
        }
    }

    private Object getFlrAttribute(String attribute) throws JMException, IOException {
        return this.server.getAttribute(FLR_MBEAN_OBJECT_NAME, attribute);
    }

    public Object invokeOperation(String name, Object ... parameters) throws IOException, FlightRecorderException {
        try {
            try {
                return this.invokeFlrOperation(name, parameters);
            }
            catch (InstanceNotFoundException e) {
                HotspotManagementToolkit.registerMBeans(this.server);
                return this.invokeFlrOperation(name, parameters);
            }
        }
        catch (JMException e) {
            IOException throwMe = new IOException(e.getMessage());
            throwMe.initCause(e);
            throw throwMe;
        }
    }

    private Object invokeFlrOperation(String operation, Object ... parameters) throws JMException, IOException {
        return this.server.invoke(FLR_MBEAN_OBJECT_NAME, operation, parameters, ConnectionHandleToolkit.extractSignature(parameters));
    }

    public void closeRecording(IRecordingDescriptor descriptor) throws FlightRecorderException {
        try {
            this.invokeOperation("close", descriptor.getObjectName());
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not close the recording!", e);
        }
    }
}

