/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionMetaDataProviderService
implements IMRIMetaDataProviderService {
    private boolean m_hasInitializedExtensions = false;
    private final List<IMRIMetaDataProviderService> m_providers = new ArrayList<IMRIMetaDataProviderService>();

    private synchronized void checkExtenstionsInitialized() {
        if (!this.m_hasInitializedExtensions) {
            this.initializeFromExtensions();
            this.m_hasInitializedExtensions = true;
        }
    }

    private void initializeFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("com.jrockit.mc.rjmx.metadataprovider");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("metaDataProvider")) {
                    try {
                        IMRIMetaDataProviderService provider = (IMRIMetaDataProviderService)config.createExecutableExtension("class");
                        this.m_providers.add(provider);
                    }
                    catch (CoreException e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate meta data provider '" + config.getAttribute("class") + "'!", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public Object getMetaData(IMRIMetaDataService metaDataService, MRI mri, String dataKey) {
        this.checkExtenstionsInitialized();
        for (IMRIMetaDataProviderService providerService : this.m_providers) {
            Object value = providerService.getMetaData(metaDataService, mri, dataKey);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

