/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class DesktopEntry {
    public static final String DEFAULT_GROUP = "Desktop Entry";
    private String group = null;
    private Properties entries = null;
    private static String[] DESKTOP_ENTRY_KEYS = new String[]{"Type", "Version", "Encoding", "Name", "GenericName", "NoDisplay", "Comment", "Icon", "Hidden", "FilePattern", "TryExec", "Exec", "Path", "Terminal", "SwallowTitle", "SwallowExec", "Actions", "MimeType", "SortOrder", "Dev", "FSType", "MountPoint", "ReadOnly", "UnmountIcon", "URL", "Categories ", "OnlyShowIn", "NotShowIn", "StartupNotify", "StartupWMClass"};

    public DesktopEntry() {
        this(DEFAULT_GROUP);
    }

    public DesktopEntry(String string) {
        this.group = string;
        this.entries = new Properties();
        this.set("Version", "1.0");
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public String getType() {
        return this.get("Type");
    }

    public void setType(String string) {
        this.set("Type", string);
    }

    public void setEncoding(String string) {
        this.set("Encoding", string);
    }

    public String getEncoding() {
        return this.get("Encoding");
    }

    public void setName(String string) {
        this.set("Name", string);
    }

    public String getName() {
        return this.get("Name");
    }

    public String getGenericName() {
        return this.get("GenericName");
    }

    public void setGenericName(String string) {
        this.set("GenericName", string);
    }

    public String getExec() {
        return this.get("Exec");
    }

    public void setExec(String string) {
        this.set("Exec", string);
    }

    public String getIcon() {
        return this.get("Icon");
    }

    public void setIcon(String string) {
        this.set("Icon", string);
    }

    public boolean getTerminal() {
        return Boolean.parseBoolean(this.get("Terminal"));
    }

    public void setTerminal(boolean bl) {
        this.set("Terminal", String.valueOf(bl));
    }

    public String getCategories() {
        return this.get("Categories");
    }

    public void setCategories(String string) {
        this.set("Categories", string);
    }

    public String getComment() {
        return this.get("Comment");
    }

    public void setComment(String string) {
        this.set("Comment", string);
    }

    public String getPath() {
        return this.get("Path");
    }

    public void setPath(String string) {
        this.set("Path", string);
    }

    public void set(String string, String string2) {
        if (string2 == null) {
            this.entries.remove(string);
        } else {
            this.entries.setProperty(string, string2);
        }
    }

    public void set(String string, String string2, String string3) {
        this.set(string + "[" + string2 + "]", string3);
    }

    public String get(String string, String string2) {
        return this.get(string + "[" + string2 + "]");
    }

    public String get(String string) {
        return this.entries.getProperty(string);
    }

    public void load(String string) {
        try {
            this.entries.load(new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public static DesktopEntry create(String string) {
        return DesktopEntry.create(DEFAULT_GROUP, string);
    }

    public static DesktopEntry create(String string, String string2) {
        if (null == string || string.trim().equals("")) {
            string = DEFAULT_GROUP;
        }
        DesktopEntry desktopEntry = new DesktopEntry(string);
        desktopEntry.load(string2);
        return desktopEntry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == this.group) {
            stringBuffer.append("[Desktop Entry]\n");
        } else {
            stringBuffer.append("[" + this.group + "]\n");
        }
        Iterator<Object> iterator = this.entries.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(this.entries.getProperty(string));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

