/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SwingScrollWidget
extends Widget {
    private static final int BAR_VERTICAL_SIZE = 16;
    private static final int BAR_HORIZONTAL_SIZE = 16;
    private Widget viewport;
    private Widget view;
    private ComponentWidget verticalWidget;
    private ComponentWidget horizontalWidget;
    private JScrollBar verticalScroll;
    private JScrollBar horizontalScroll;
    private AdjustmentListener verticalListener = new MyAdjustmentListener(true);
    private AdjustmentListener horizontalListener = new MyAdjustmentListener(false);

    public SwingScrollWidget(Scene scene) {
        super(scene);
        this.setLayout(new ScrollLayout());
        this.setCheckClipping(true);
        this.viewport = new Widget(scene);
        this.viewport.setCheckClipping(true);
        this.addChild(this.viewport);
        this.verticalScroll = new JScrollBar(1);
        this.verticalScroll.setUnitIncrement(16);
        this.verticalScroll.setBlockIncrement(64);
        this.verticalWidget = new ComponentWidget(scene, this.verticalScroll);
        this.horizontalScroll = new JScrollBar(0);
        this.horizontalScroll.setUnitIncrement(16);
        this.horizontalScroll.setBlockIncrement(64);
        this.horizontalWidget = new ComponentWidget(scene, this.horizontalScroll);
    }

    public SwingScrollWidget(Scene scene, Widget widget) {
        this(scene);
        this.setView(widget);
    }

    public final Widget getView() {
        return this.view;
    }

    public final void setView(Widget widget) {
        if (this.view != null) {
            this.viewport.removeChild(this.view);
        }
        this.view = widget;
        if (this.view != null) {
            this.viewport.addChild(this.view);
        }
    }

    @Override
    protected Rectangle calculateClientArea() {
        return new Rectangle(this.calculateSize());
    }

    private Dimension calculateSize() {
        Dimension dimension;
        if (this.isPreferredBoundsSet()) {
            Rectangle rectangle = this.getPreferredBounds();
            Insets insets = this.getBorder().getInsets();
            return new Dimension(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }
        Dimension dimension2 = this.view.getBounds().getSize();
        Dimension dimension3 = this.getMinimumSize();
        if (dimension3 != null) {
            if (dimension2.width < dimension3.width) {
                dimension2.width = dimension3.width;
            }
            if (dimension2.height < dimension3.height) {
                dimension2.height = dimension3.height;
            }
        }
        if ((dimension = this.getMaximumSize()) != null) {
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
        }
        return dimension2;
    }

    private class MyAdjustmentListener
    implements AdjustmentListener {
        private boolean vertical;

        private MyAdjustmentListener(boolean bl) {
            this.vertical = bl;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Point point = SwingScrollWidget.this.view.getLocation();
            if (this.vertical) {
                point.y = -SwingScrollWidget.this.verticalScroll.getValue();
            } else {
                point.x = -SwingScrollWidget.this.horizontalScroll.getValue();
            }
            SwingScrollWidget.this.view.setPreferredLocation(point);
            SwingScrollWidget.this.getScene().validate();
        }
    }

    private final class ScrollLayout
    implements Layout {
        private ScrollLayout() {
        }

        @Override
        public void layout(Widget widget) {
            Cloneable cloneable;
            Point point;
            if (SwingScrollWidget.this.isPreferredBoundsSet()) {
                point = SwingScrollWidget.this.getPreferredBounds().getLocation();
                cloneable = SwingScrollWidget.this.getBorder().getInsets();
                point.translate(cloneable.left, cloneable.top);
            } else {
                point = new Point();
            }
            cloneable = SwingScrollWidget.this.view != null ? SwingScrollWidget.this.view.getPreferredBounds() : new Rectangle();
            Rectangle rectangle = SwingScrollWidget.this.view != null ? new Rectangle(SwingScrollWidget.this.view.getLocation(), SwingScrollWidget.this.calculateSize()) : new Rectangle();
            boolean bl = this.checkVertical((Rectangle)cloneable, rectangle);
            boolean bl2 = this.checkHorizontal((Rectangle)cloneable, rectangle);
            if (bl) {
                rectangle.width -= 16;
                bl2 = this.checkHorizontal((Rectangle)cloneable, rectangle);
            }
            if (bl2) {
                rectangle.height -= 16;
                if (!bl && (bl = this.checkVertical((Rectangle)cloneable, rectangle))) {
                    rectangle.width -= 16;
                }
            }
            SwingScrollWidget.this.viewport.resolveBounds(point, new Rectangle(rectangle.getSize()));
            int n = point.x;
            int n2 = point.x + rectangle.width;
            int n3 = point.y;
            int n4 = point.y + rectangle.height;
            if (bl) {
                if (SwingScrollWidget.this.verticalWidget.getParentWidget() == null) {
                    SwingScrollWidget.this.addChild(SwingScrollWidget.this.verticalWidget);
                }
                SwingScrollWidget.this.verticalWidget.resolveBounds(new Point(n2, n3), new Rectangle(16, rectangle.height));
            } else if (SwingScrollWidget.this.verticalWidget.getParentWidget() != null) {
                SwingScrollWidget.this.removeChild(SwingScrollWidget.this.verticalWidget);
            }
            if (bl2) {
                if (SwingScrollWidget.this.horizontalWidget.getParentWidget() == null) {
                    SwingScrollWidget.this.addChild(SwingScrollWidget.this.horizontalWidget);
                }
                SwingScrollWidget.this.horizontalWidget.resolveBounds(new Point(n, n4), new Rectangle(rectangle.width, 16));
            } else if (SwingScrollWidget.this.horizontalWidget.getParentWidget() != null) {
                SwingScrollWidget.this.removeChild(SwingScrollWidget.this.horizontalWidget);
            }
            SwingScrollWidget.this.verticalScroll.removeAdjustmentListener(SwingScrollWidget.this.verticalListener);
            SwingScrollWidget.this.verticalScroll.setValues(-rectangle.y, rectangle.height, ((Rectangle)cloneable).y, ((Rectangle)cloneable).y + ((Rectangle)cloneable).height);
            SwingScrollWidget.this.verticalScroll.addAdjustmentListener(SwingScrollWidget.this.verticalListener);
            SwingScrollWidget.this.horizontalScroll.removeAdjustmentListener(SwingScrollWidget.this.horizontalListener);
            SwingScrollWidget.this.horizontalScroll.setValues(-rectangle.x, rectangle.width, ((Rectangle)cloneable).x, ((Rectangle)cloneable).x + ((Rectangle)cloneable).width);
            SwingScrollWidget.this.horizontalScroll.addAdjustmentListener(SwingScrollWidget.this.horizontalListener);
        }

        @Override
        public boolean requiresJustification(Widget widget) {
            return false;
        }

        @Override
        public void justify(Widget widget) {
        }

        private boolean checkHorizontal(Rectangle rectangle, Rectangle rectangle2) {
            return (rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) && rectangle2.width > 48;
        }

        private boolean checkVertical(Rectangle rectangle, Rectangle rectangle2) {
            return (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) && rectangle2.height > 48;
        }
    }
}

