/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.wizards;

import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.wizards.OnePageWizard;
import com.jrockit.mc.ui.wizards.SizeConstrainedWizardDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OnePageWizardDialog
extends SizeConstrainedWizardDialog {
    private String m_title;
    private Image m_image;
    private boolean m_setFinishButtonAsOK = true;
    private boolean m_hideCancelButton;

    public OnePageWizardDialog(Shell shell, IWizardPage page) {
        super(shell, (IWizard)new OnePageWizard(page));
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.getOnePageWizard().setDialogSettings(settings);
    }

    public IDialogSettings getDialogSettings() {
        return this.getOnePageWizard().getDialogSettings();
    }

    public IWizardPage getPage() {
        return this.getOnePageWizard().getPage();
    }

    private OnePageWizard getOnePageWizard() {
        return (OnePageWizard)this.getWizard();
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setTitle(String title) {
        this.m_title = title;
        super.setTitle(title);
    }

    public void setFinishButtonLabelAsOK(boolean setFinishButtonAsOK) {
        this.m_setFinishButtonAsOK = setFinishButtonAsOK;
    }

    public void setHideCancelButton(boolean hideCancelButton) {
        this.m_hideCancelButton = hideCancelButton;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.m_image != null) {
            this.getShell().setImage(this.m_image);
        }
        if (this.m_title != null) {
            this.getShell().setText(this.m_title);
        }
        this.updateShellSize();
        DisplayToolkit.placeDialogInCenter(this.getParentShell(), this.getShell());
        if (this.m_setFinishButtonAsOK) {
            this.getButton(16).setText(IDialogConstants.OK_LABEL);
        }
        if (this.m_hideCancelButton) {
            Button hideButton;
            Button showButton;
            if (parent.getDisplay().getDismissalAlignment() == 131072) {
                showButton = this.getButton(16);
                hideButton = this.getButton(1);
            } else {
                showButton = this.getButton(1);
                hideButton = this.getButton(16);
            }
            hideButton.setVisible(false);
            showButton.setText(IDialogConstants.OK_LABEL);
            showButton.setFocus();
        }
        return control;
    }

    public boolean performFinish() {
        return this.getWizard().performFinish();
    }
}

